/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.spectrogram;

import java.util.Arrays;
import org.jamdev.jpamutils.JamArr;
import org.jamdev.jpamutils.spectrogram.ComplexArray;
import org.jamdev.jpamutils.spectrogram.Spectrogram;

public class SpecTransform {
    private static final double DEFAULT_MIN_DB = 0.0;
    double[][] specData;
    private Spectrogram spectrgram;
    private ComplexArray[] complexData;
    private boolean maintainPhase = false;

    public SpecTransform(Spectrogram spectrgram) {
        this.spectrgram = spectrgram;
        this.initialiseSpecData();
    }

    public SpecTransform dBSpec() {
        return this.dBSpec(false, 0.0);
    }

    public SpecTransform dBSpec(boolean power) {
        return this.dBSpec(power, 0.0);
    }

    public SpecTransform dBSpec(Double mindB) {
        if (mindB == null) {
            return this.dBSpec();
        }
        return this.dBSpec(false, mindB);
    }

    public SpecTransform dBSpec(boolean power, double mindB) {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.dBSpec(this.specData, power, mindB);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform normalise(double min_leveldB, double ref_level_dB) {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.normalise(this.specData, min_leveldB, ref_level_dB);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform normaliseMinMax() {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.normaliseMinMax(this.specData);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform normaliseRowSum() {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.normaliseRowSum(this.specData);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform normaliseStd(double mean, double std) {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.normaliseStd(this.specData, mean, std);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform reduceTonalNoiseMean(int timeConstLen) {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.reduceTonalNoiseMean(this.specData, timeConstLen);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform reduceTonalNoiseMedian() {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.reduceTonalNoiseMedian(this.specData);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform medianFilter(double rowfactor, double colfactor) {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.medianFilter(this.specData, rowfactor, colfactor);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform enhance(double enhanceFactor) {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.enhance(this.specData, enhanceFactor);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform interpolate(double fMin, double fMax, int freqBins) {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.interpolate(this.specData, fMin, fMax, freqBins, this.spectrgram.getSampleRate());
        if (this.maintainPhase) {
            // empty if block
        }
        return this;
    }

    public SpecTransform clamp(double minVal, double maxVal) {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.clamp(this.specData, minVal, maxVal);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public SpecTransform gaussianFilter(double sigma) {
        if (this.specData == null) {
            this.initialiseSpecData();
        }
        this.specData = SpecTransform.blurImage(this.specData, sigma);
        if (this.maintainPhase) {
            this.absSpec2Complex();
        }
        return this;
    }

    public static double[][] dBSpec(double[][] array, boolean power, double minddB) {
        double coeff = 20.0;
        if (power) {
            coeff = 10.0;
        }
        double[][] logSpectrgram = new double[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                logSpectrgram[i][j] = coeff * Math.log10(array[i][j]);
                if (!(logSpectrgram[i][j] < -100.0)) continue;
                logSpectrgram[i][j] = -100.0;
            }
        }
        return logSpectrgram;
    }

    public static double[][] normalise(double[][] array, double min_leveldB, double ref_level_dB) {
        double[][] normalizeSpec = new double[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                normalizeSpec[i][j] = 2.0 * ((array[i][j] - ref_level_dB - min_leveldB) / -min_leveldB) - 1.1407;
            }
        }
        return normalizeSpec;
    }

    public static double[][] normaliseMinMax(double[][] img) {
        double[][] array = SpecTransform.copyArr(img);
        double min = JamArr.min(array);
        array = JamArr.subtract(array, min);
        double max = JamArr.max(array);
        array = JamArr.divide(array, max);
        return array;
    }

    public static double[][] copyArr(double[][] array) {
        double[][] arrCopy = new double[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, arrCopy[i], 0, array[i].length);
        }
        return arrCopy;
    }

    public static double[][] normaliseRowSum(double[][] img) {
        double[][] array = SpecTransform.copyArr(img);
        double tot = 0.0;
        for (int i = 0; i < array.length; ++i) {
            tot += JamArr.sum(JamArr.pow(array[i], 2.0));
        }
        if ((tot = Math.sqrt(tot)) != 0.0) {
            return JamArr.divide(array, tot);
        }
        return array;
    }

    public static double[][] clamp(double[][] array, double minVal, double maxVal) {
        double[][] clampedSpec = new double[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                clampedSpec[i][j] = array[i][j] < minVal ? minVal : (array[i][j] > maxVal ? maxVal : array[i][j]);
            }
        }
        return clampedSpec;
    }

    public static double[][] interpolate(double[][] array, double fMin, double fMax, int freqBins, float sR) {
        int fftlen = array[0].length;
        int minIndex = (int)Math.max(0.0, (double)fftlen * (fMin / (double)(sR / 2.0f)));
        int maxIndex = (int)Math.min((double)(fftlen - 1), (double)fftlen * (fMax / (double)(sR / 2.0f)));
        double[][] specInterp = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            double[] fftSliceInterp = Arrays.copyOfRange(array[i], minIndex, maxIndex);
            specInterp[i] = fftSliceInterp;
            fftSliceInterp = SpecTransform.nearestNeighbourInterp(fftSliceInterp, freqBins);
            specInterp[i] = fftSliceInterp;
        }
        return specInterp;
    }

    public static double[] nearestNeighbourInterp(double[] inputArray, int w2) {
        int w1 = inputArray.length;
        double[] temp = new double[w2];
        double x_ratio = (double)w1 / (double)w2;
        for (int j = 0; j < w2; ++j) {
            double px = Math.floor((double)j * x_ratio);
            temp[j] = inputArray[(int)px];
        }
        return temp;
    }

    public static double[][] reduceTonalNoiseMean(double[][] input, double timeLenConst) {
        double eps = 1.0 - Math.exp(Math.log(0.15) * 1.0 / timeLenConst);
        double[] rMean = JamArr.mean(input, 0);
        double[][] imgNew = new double[input.length][];
        int nx = imgNew.length;
        for (int i = 0; i < nx; ++i) {
            imgNew[i] = JamArr.subtract(input[i], rMean);
            rMean = JamArr.add(JamArr.product(rMean, 1.0 - eps), JamArr.product(input[i], eps));
        }
        return imgNew;
    }

    public static double[][] reduceTonalNoiseMedian(double[][] img) {
        double[][] imgNew = new double[img.length][img[0].length];
        double[] median = JamArr.median(img, 1);
        for (int i = 0; i < img[0].length; ++i) {
            for (int j = 0; j < img.length; ++j) {
                imgNew[j][i] = img[j][i] - median[i];
            }
        }
        return imgNew;
    }

    public static double[][] normaliseStd(double[][] img, double mean, double std) {
        double std_orig = JamArr.std(img);
        return JamArr.add(JamArr.product(JamArr.divide(JamArr.subtract(img, JamArr.mean(img)), std_orig), std), mean);
    }

    public static double[][] filterIsolatedSpots(double[][] img, int[][] struct) {
        return null;
    }

    public static double[][] blurImage(double[][] img, double sigma) {
        double[][] kernel = SpecTransform.generateKernal(sigma);
        int inputWidth = img.length;
        int inputHeight = img[0].length;
        int kernelWidth = kernel.length;
        int kernelHeight = kernel[0].length;
        if (kernelWidth <= 0 || (kernelWidth & 1) != 1) {
            throw new IllegalArgumentException("Kernel must have odd width");
        }
        if (kernelHeight <= 0 || (kernelHeight & 1) != 1) {
            throw new IllegalArgumentException("Kernel must have odd height");
        }
        int kernelWidthRadius = kernelWidth >>> 1;
        int kernelHeightRadius = kernelHeight >>> 1;
        double[][] outputData = new double[inputWidth][inputHeight];
        for (int i = inputWidth - 1; i >= 0; --i) {
            for (int j = inputHeight - 1; j >= 0; --j) {
                double newValue = 0.0;
                for (int kw = kernelWidth - 1; kw >= 0; --kw) {
                    for (int kh = kernelHeight - 1; kh >= 0; --kh) {
                        newValue += kernel[kw][kh] * img[SpecTransform.bound(i + kw - kernelWidthRadius, inputWidth)][SpecTransform.bound(j + kh - kernelHeightRadius, inputHeight)];
                    }
                }
                outputData[i][j] = newValue;
            }
        }
        return outputData;
    }

    private static int bound(int value, int endIndex) {
        if (value < 0) {
            return 0;
        }
        if (value < endIndex) {
            return value;
        }
        return endIndex - 1;
    }

    public static double[][] generateKernal(double sigma) {
        int y;
        int x;
        int W = 5;
        double[][] kernel = new double[W][W];
        double mean = W / 2;
        double sum = 0.0;
        for (x = 0; x < W; ++x) {
            for (y = 0; y < W; ++y) {
                kernel[x][y] = Math.exp(-0.5 * (Math.pow(((double)x - mean) / sigma, 2.0) + Math.pow(((double)y - mean) / sigma, 2.0))) / (Math.PI * 2 * sigma * sigma);
                sum += kernel[x][y];
            }
        }
        for (x = 0; x < W; ++x) {
            y = 0;
            while (y < W) {
                double[] dArray = kernel[x];
                int n = y++;
                dArray[n] = dArray[n] / sum;
            }
        }
        return kernel;
    }

    public static double[][] medianFilter(double[][] img1, double rowfactor, double colfactor) {
        double[][] output = new double[img1.length][];
        double[] col_median = JamArr.product(JamArr.median(img1, 0), colfactor);
        double[] row_median = JamArr.product(JamArr.median(img1, 1), rowfactor);
        for (int i = 0; i < img1.length; ++i) {
            double[] temp = new double[img1[i].length];
            for (int j = 0; j < img1.length; ++j) {
                if (!(img1[i][j] <= col_median[i]) && !(img1[i][j] <= row_median[i])) {
                    temp[j] = img1[i][j];
                }
                if (!(temp[j] > 0.0)) continue;
                temp[j] = 1.0;
            }
            output[i] = temp;
        }
        return output;
    }

    public static double[][] enhance(double[][] img, double enhancement) {
        if (enhancement > 0.0) {
            double med = JamArr.median(img);
            double std = JamArr.std(img);
            double wid = 1.0 / enhancement * std;
            double[][] scaling = JamArr.divide(1.0, JamArr.add(JamArr.exp(JamArr.product(JamArr.divide(JamArr.subtract(img, med + std), wid), -1.0)), 1.0));
            return JamArr.product(img, scaling);
        }
        return img;
    }

    private void initialiseSpecData() {
        this.specData = this.spectrgram.getAbsoluteSpectrogram();
        this.complexData = this.spectrgram.getComplexSpectrogram();
    }

    public double[][] getReal() {
        double[][] real = new double[this.complexData.length][this.complexData[0].length()];
        for (int i = 0; i < this.complexData.length; ++i) {
            for (int j = 0; j < this.complexData[i].length(); ++j) {
                real[i][j] = this.complexData[i].getReal(j);
            }
        }
        return real;
    }

    public double[][] getImag() {
        double[][] imag = new double[this.complexData.length][this.complexData[0].length()];
        for (int i = 0; i < this.complexData.length; ++i) {
            for (int j = 0; j < this.complexData[i].length(); ++j) {
                imag[i][j] = this.complexData[i].getImag(j);
            }
        }
        return imag;
    }

    private void absSpec2Complex() {
        for (int i = 0; i < this.complexData.length; ++i) {
            for (int j = 0; j < this.complexData[i].length(); ++j) {
                int n = j > this.specData[i].length - 1 ? 2 * this.specData[i].length - j - 1 : j;
                double newReal = Math.sqrt(Math.pow(this.specData[i][n], 2.0) - Math.pow(this.complexData[i].getImag(j), 2.0));
                this.complexData[i].set(j, newReal, this.complexData[i].getImag(j));
            }
        }
    }

    public double[][] getTransformedData() {
        return this.specData;
    }

    public Spectrogram getSpectrgram() {
        return this.spectrgram;
    }

    public void setTransformedData(double[][] absoluteSpectrogram) {
        this.specData = absoluteSpectrogram;
    }
}

