/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.spectrogram;

import org.jamdev.jpamutils.spectrogram.ComplexArray;
import org.jamdev.jpamutils.spectrogram.FastFFT;
import org.jamdev.jpamutils.spectrogram.WindowFunction;
import org.jamdev.jpamutils.wavFiles.AudioData;

public class Spectrogram {
    private AudioData wave;
    private int fftLength = 1024;
    private int fftHop = 512;
    private int numFrames;
    private int numFrequencyUnit;
    private ComplexArray[] complexSpectrogram;
    private int framesPerSecond;
    private double frequencyBinSize;
    private float sR;

    public Spectrogram(AudioData wave, int fftLength, int fftHop) {
        this.sR = wave.getSampleRate();
        this.fftLength = fftLength;
        this.fftHop = fftHop;
        this.buildSpectrogram(wave);
    }

    public double[][] getAbsoluteSpectrogram() {
        return Spectrogram.buildAbsoluteSpectram(this.complexSpectrogram);
    }

    private void buildSpectrogram(AudioData wave) {
        double[] amplitudes = wave.getScaledSampleAmpliudes();
        int pointer = 0;
        int numHops = (int)Math.ceil((double)amplitudes.length / (double)this.fftHop);
        int numOverlappedSamples = this.fftLength * numHops;
        double[] overlapAmp = new double[numOverlappedSamples];
        int numSamples = amplitudes.length + this.fftLength - this.fftHop;
        int nn = 0;
        for (int i = 0; i < numSamples; ++i) {
            overlapAmp[pointer++] = i < amplitudes.length ? amplitudes[i] : 0.0;
            if (pointer % this.fftLength != 0 || nn > numHops) continue;
            i = ++nn * this.fftHop;
        }
        numSamples = numOverlappedSamples;
        amplitudes = overlapAmp;
        this.numFrames = numSamples / this.fftLength;
        this.framesPerSecond = (int)((double)this.numFrames / wave.getLengthInSeconds());
        WindowFunction window = new WindowFunction();
        window.setWindowType(3);
        double[] win = window.generate(this.fftLength);
        double[][] signals = new double[this.numFrames][];
        for (int f = 0; f < this.numFrames; ++f) {
            signals[f] = new double[this.fftLength];
            int startSample = f * this.fftLength;
            for (int n = 0; n < this.fftLength; ++n) {
                signals[f][n] = amplitudes[startSample + n] * win[n];
            }
        }
        this.complexSpectrogram = new ComplexArray[this.numFrames];
        FastFFT fastFFT = new FastFFT();
        for (int i = 0; i < this.numFrames; ++i) {
            this.complexSpectrogram[i] = fastFFT.rfftFull(signals[i], signals[i].length);
        }
        this.numFrequencyUnit = this.complexSpectrogram[0].length() / 2;
        this.frequencyBinSize = (double)wave.getSampleRate() / 2.0 / (double)this.numFrequencyUnit;
    }

    public static double[][] buildAbsoluteSpectram(ComplexArray[] complexSpectrogram) {
        double[][] absoluteSpectrogram = new double[complexSpectrogram.length][];
        for (int i = 0; i < complexSpectrogram.length; ++i) {
            absoluteSpectrogram[i] = new double[complexSpectrogram[i].length() / 2];
            for (int j = 0; j < absoluteSpectrogram[i].length; ++j) {
                absoluteSpectrogram[i][j] = Math.sqrt(complexSpectrogram[i].getReal(j) * complexSpectrogram[i].getReal(j) + complexSpectrogram[i].getImag(j) * complexSpectrogram[i].getImag(j));
            }
        }
        return absoluteSpectrogram;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public double getFrequencyBinSize() {
        return this.frequencyBinSize;
    }

    public ComplexArray[] getFFTData() {
        return this.complexSpectrogram;
    }

    public float getSampleRate() {
        return this.sR;
    }

    public int getFFTLength() {
        return this.fftLength;
    }

    public int getFFTHop() {
        return this.fftHop;
    }

    public ComplexArray[] getComplexSpectrogram() {
        return this.complexSpectrogram;
    }

    public void setComplexSpectrogram(ComplexArray[] complexSpectrogram) {
        this.complexSpectrogram = complexSpectrogram;
    }
}

