/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.wavFiles;

import java.util.Arrays;
import org.jamdev.jpamutils.wavFiles.PreEmphasisFilter;
import org.jamdev.jpamutils.wavFiles.WavInterpolator;

public class AudioData {
    public WavInterpolator wavInterpolator;
    public PreEmphasisFilter preEmphasisFilter;
    public int[] samples;
    public float sampleRate;
    public double bitRate = 16.0;

    public AudioData(int[] samples, float sampleRate) {
        this.samples = samples;
        this.sampleRate = sampleRate;
        this.preEmphasisFilter = new PreEmphasisFilter();
        this.wavInterpolator = new WavInterpolator();
    }

    public AudioData(short[] samples, float sampleRate) {
        this(AudioData.short2Int(samples), sampleRate);
    }

    public AudioData(double[] wavArray, float sampleRate) {
        int[] samples = new int[wavArray.length];
        for (int i = 0; i < wavArray.length; ++i) {
            samples[i] = (int)(wavArray[i] * Math.pow(2.0, this.bitRate));
        }
        this.samples = samples;
        this.sampleRate = sampleRate;
        this.preEmphasisFilter = new PreEmphasisFilter();
        this.wavInterpolator = new WavInterpolator();
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int[] getSampleAmplitudes() {
        return this.samples;
    }

    public double getLengthInSeconds() {
        return (double)this.samples.length / (double)this.sampleRate;
    }

    public double[] getScaledSampleAmpliudes() {
        double bitSize = Math.pow(2.0, this.bitRate) / 2.0;
        double[] wavArray = new double[this.samples.length];
        for (int i = 0; i < wavArray.length; ++i) {
            wavArray[i] = (double)this.samples[i] / bitSize;
        }
        return wavArray;
    }

    public AudioData trim(int sampleStart, int samplEnd) {
        return new AudioData(Arrays.copyOfRange(this.samples, sampleStart, samplEnd), this.sampleRate);
    }

    public AudioData interpolate(float interpSr) {
        double[] wavArray = this.getScaledSampleAmpliudes();
        double[] intperarr = this.wavInterpolator.interpolate(wavArray, this.sampleRate, interpSr);
        int[] samplesDecimated = new int[intperarr.length];
        double bitSize = Math.pow(2.0, this.bitRate);
        for (int i = 0; i < intperarr.length; ++i) {
            samplesDecimated[i] = (int)(bitSize * intperarr[i]);
        }
        return new AudioData(samplesDecimated, interpSr);
    }

    public AudioData preEmphasis(double factor) {
        return new AudioData(this.preEmphasisFilter.preEmphasis(this.samples, factor), this.sampleRate);
    }

    public static int[] short2Int(short[] samples) {
        int[] arr = new int[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            arr[i] = samples[i];
        }
        return arr;
    }
}

