/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.wavFiles;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class WavFile
extends AudioFileReader {
    private URL file;
    private AudioFileFormat audioFormat;
    private int byteLength = -1;

    public WavFile(File file) throws UnsupportedAudioFileException, IOException {
        this(file.toURI().toURL());
    }

    public WavFile(URL file) throws UnsupportedAudioFileException, IOException {
        this.file = file;
        this.audioFormat = this.getAudioFileFormat();
    }

    private static long readUnsignedIntLE(DataInputStream is) throws IOException {
        byte[] buf = new byte[4];
        is.readFully(buf);
        return buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
    }

    private static short readUnsignedShortLE(DataInputStream is) throws IOException {
        byte[] buf = new byte[2];
        is.readFully(buf);
        return (short)(buf[0] & 0xFF | (buf[1] & 0xFF) << 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        try (FileInputStream is = new FileInputStream(file);){
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(is);
            return audioFileFormat;
        }
    }

    public AudioFileFormat getAudioFileFormat() {
        if (this.audioFormat != null) {
            return this.audioFormat;
        }
        try {
            return this.getAudioFileFormat(this.file);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream in) throws UnsupportedAudioFileException, IOException {
        DataInputStream din = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        if (din.readInt() != 1380533830) {
            throw new UnsupportedAudioFileException("Invalid WAV chunk header.");
        }
        WavFile.readUnsignedIntLE(din);
        if (din.readInt() != 1463899717) {
            throw new UnsupportedAudioFileException("Invalid WAV chunk header.");
        }
        boolean foundFmt = false;
        boolean foundData = false;
        int compressionCode = 0;
        short numberChannels = 0;
        short blockAlign = 0;
        int bitsPerSample = 0;
        long sampleRate = 0L;
        long bytesPerSecond = 0L;
        long chunkLength = 0L;
        block8: while (!foundData) {
            int chunkId = din.readInt();
            chunkLength = WavFile.readUnsignedIntLE(din);
            switch (chunkId) {
                case 1718449184: {
                    foundFmt = true;
                    compressionCode = WavFile.readUnsignedShortLE(din);
                    numberChannels = WavFile.readUnsignedShortLE(din);
                    sampleRate = WavFile.readUnsignedIntLE(din);
                    bytesPerSecond = WavFile.readUnsignedIntLE(din);
                    blockAlign = WavFile.readUnsignedShortLE(din);
                    bitsPerSample = WavFile.readUnsignedShortLE(din);
                    din.skip(chunkLength - 16L);
                    continue block8;
                }
                case 1717658484: {
                    din.skip(chunkLength);
                    continue block8;
                }
                case 1684108385: {
                    if (!foundFmt) {
                        throw new UnsupportedAudioFileException("This implementation requires WAV fmt chunks precede data chunks.");
                    }
                    foundData = true;
                    continue block8;
                }
            }
            din.skip(chunkLength);
        }
        this.byteLength = din.available();
        return new AudioFileFormat(AudioFileFormat.Type.WAVE, new AudioFormat(switch (compressionCode) {
            case 1 -> {
                if (bitsPerSample <= 8) {
                    yield AudioFormat.Encoding.PCM_UNSIGNED;
                }
                yield AudioFormat.Encoding.PCM_SIGNED;
            }
            default -> throw new UnsupportedAudioFileException("Unrecognized WAV compression code: 0x" + Integer.toHexString(compressionCode));
        }, sampleRate, bitsPerSample, numberChannels, (bitsPerSample + 7) / 8 * numberChannels, bytesPerSecond, false), (int)chunkLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        try (InputStream is = url.openStream();){
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(is);
            return audioFileFormat;
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new FileInputStream(file));
    }

    public AudioInputStream getAudioInputStream() throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(this.file);
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat aff = this.getAudioFileFormat(stream);
        return new AudioInputStream(stream, aff.getFormat(), aff.getFrameLength());
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(url.openStream());
    }

    public static int[] getSampleAmplitudes(AudioFormat wavHeader, byte[] data) {
        int bytePerSample = wavHeader.getSampleSizeInBits() / 8;
        int numSamples = data.length / bytePerSample;
        int[] amplitudes = new int[numSamples];
        int pointer = 0;
        for (int i = 0; i < numSamples; ++i) {
            int amplitude = 0;
            for (int byteNumber = 0; byteNumber < bytePerSample; ++byteNumber) {
                amplitude = (short)(amplitude | (short)((data[pointer++] & 0xFF) << byteNumber * 8));
            }
            amplitudes[i] = amplitude;
        }
        return amplitudes;
    }

    public static byte[] trim(AudioFormat wavHeader, byte[] bytes, int maxSamples) {
        if (maxSamples <= 0) {
            return bytes;
        }
        int bytePerSample = wavHeader.getSampleSizeInBits() / 8;
        int numSamples = bytes.length / bytePerSample;
        int trimSamples = numSamples - maxSamples;
        byte[] trimByteChan = new byte[maxSamples * bytePerSample];
        int pointer = 0;
        int n = 0;
        for (int i = trimSamples / 2; i < numSamples - trimSamples / 2; ++i) {
            for (int byteNumber = 0; byteNumber < bytePerSample; ++byteNumber) {
                if (n >= trimByteChan.length || pointer >= bytes.length) {
                    System.err.println("Warning: Trim indices are wrong?: " + wavHeader.toString());
                    return trimByteChan;
                }
                trimByteChan[n++] = bytes[pointer++];
            }
        }
        return trimByteChan;
    }

    public static byte[] getSingleChannelByte(AudioFormat wavHeader, byte[] bytes, int channel) {
        int bytePerSample = wavHeader.getChannels() * wavHeader.getSampleSizeInBits() / 8;
        int bytesPerSampleChannel = wavHeader.getSampleSizeInBits() / 8;
        int numSamples = bytes.length / bytePerSample;
        byte[] singleByteChan = new byte[numSamples * bytesPerSampleChannel];
        int pointer = 0;
        int n = 0;
        for (int i = 0; i < numSamples; ++i) {
            for (int j = 0; j < wavHeader.getChannels(); ++j) {
                for (int byteNumber = 0; byteNumber < bytesPerSampleChannel; ++byteNumber) {
                    if (j == channel) {
                        singleByteChan[n] = (byte)(bytes[pointer] & 0xFF);
                        ++n;
                    }
                    ++pointer;
                }
            }
        }
        return singleByteChan;
    }

    public File getFile() {
        try {
            return new File(this.file.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getFileURL() {
        return this.file;
    }

    public int getByteLength() {
        return this.byteLength;
    }
}

