/*
 * Decompiled with CFR 0.152.
 */
package org.jamdev.jpamutils.wavFiles;

import java.util.Arrays;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import uk.me.berndporr.iirj.Butterworth;

public class WavInterpolator {
    private UnivariateFunction interp;

    public double[] interpolate(double[] wavArray, float sR, float interpSr) {
        if (sR == interpSr) {
            return Arrays.copyOf(wavArray, wavArray.length);
        }
        if (interpSr < sR) {
            return this.decimate(wavArray, sR, interpSr);
        }
        if (interpSr > sR) {
            return this.upSample(wavArray, sR, interpSr);
        }
        return null;
    }

    public double[] upSample(double[] wavArray, float sR, float interpSr) {
        int arraySize = (int)((double)wavArray.length * ((double)interpSr / (double)sR));
        return this.getScaled(wavArray, arraySize);
    }

    public double[] decimate(double[] wavArray, float sR, float decimatorSr) {
        Butterworth butterworth = new Butterworth();
        butterworth.lowPass(4, (double)sR, (double)(decimatorSr / 2.0f));
        double[] wavArray2 = new double[wavArray.length];
        for (int i = 0; i < wavArray.length; ++i) {
            wavArray2[i] = butterworth.filter(wavArray[i]);
        }
        int arraySize = (int)((double)wavArray2.length * ((double)decimatorSr / (double)sR));
        return this.getScaled(wavArray2, arraySize);
    }

    public double[] getScaled(double[] x, int l) {
        double[] indices = new double[x.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (double)i / (double)(x.length - 1);
        }
        SplineInterpolator interpolator = new SplineInterpolator();
        this.interp = interpolator.interpolate(indices, x);
        double[] stretched = new double[l];
        for (int i = 0; i < l; ++i) {
            stretched[i] = this.interp.value((double)i / (double)l);
        }
        return stretched;
    }
}

