/*
 * Decompiled with CFR 0.152.
 */
package io.github.maven.repository.bos;

import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosObjectInputStream;
import com.baidubce.services.bos.model.BosObject;
import com.baidubce.services.bos.model.ListObjectsRequest;
import com.baidubce.services.bos.model.ListObjectsResponse;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.services.bos.model.PutObjectRequest;
import io.github.maven.repository.bos.BosConnect;
import io.github.maven.repository.bos.KeyResolver;
import io.github.maven.repository.bos.Progress;
import io.github.maven.repository.bos.ProgressFileInputStream;
import io.github.maven.repository.bos.ProgressFileOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BosStorageRepo {
    private static final Logger log = LoggerFactory.getLogger(BosStorageRepo.class);
    private final String bucket;
    private final String baseDirectory;
    private final KeyResolver keyResolver = new KeyResolver();
    private BosClient bosClient;

    public BosStorageRepo(String bucket, String baseDirectory) {
        this.bucket = bucket;
        this.baseDirectory = baseDirectory;
    }

    public void connect(AuthenticationInfo authenticationInfo, String endpoint) throws AuthenticationException {
        this.bosClient = BosConnect.connect(authenticationInfo, endpoint);
    }

    public void copy(String resourceName, File destination, Progress progress) throws TransferFailedException, ResourceDoesNotExistException {
        String key = this.resolveKey(resourceName);
        try {
            BosObject bosObject = this.bosClient.getObject(this.bucket, key);
            destination.getParentFile().mkdirs();
            try (ProgressFileOutputStream outputStream = new ProgressFileOutputStream(destination, progress);
                 BosObjectInputStream inputStream = bosObject.getObjectContent();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
        catch (Exception e) {
            log.warn("Could not transfer file from [bucket={}, baseDirectory={}, key={}]", new Object[]{this.bucket, this.baseDirectory, key, e});
        }
    }

    public void put(File file, String destination, Progress progress) throws TransferFailedException {
        String key = this.resolveKey(destination);
        try (ProgressFileInputStream inputStream = new ProgressFileInputStream(file, progress);){
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, (InputStream)inputStream, this.createContentLengthMetadata(file));
            this.bosClient.putObject(putObjectRequest);
        }
        catch (Exception e) {
            log.warn("Could not transfer file to [bucket={}, baseDirectory={}, key={}]", new Object[]{this.bucket, this.baseDirectory, key, e});
            throw new TransferFailedException("Could not transfer file " + file.getName());
        }
    }

    private ObjectMetadata createContentLengthMetadata(File file) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(file.length());
        return metadata;
    }

    public boolean newResourceAvailable(String resourceName, long timeStamp) throws ResourceDoesNotExistException {
        String key = this.resolveKey(resourceName);
        log.info("Checking if new key exists, [bucket={}, baseDirectory={}, key={}]", new Object[]{this.bucket, this.baseDirectory, key});
        try {
            ObjectMetadata objectMetadata = this.bosClient.getObjectMetadata(this.bucket, key);
            long updated = objectMetadata.getLastModified().getTime();
            return updated > timeStamp;
        }
        catch (Exception e) {
            log.warn("Could not find key [bucket={}, baseDirectory={}, key={}]", new Object[]{this.bucket, this.baseDirectory, key, e});
            throw new ResourceDoesNotExistException("Could not find key " + key);
        }
    }

    public List<String> list(String path) {
        String key = this.resolveKey(path);
        ListObjectsResponse listObjectsResponse = this.bosClient.listObjects(new ListObjectsRequest(this.bucket).withPrefix(key));
        ArrayList<String> objects = new ArrayList<String>();
        this.retrieveAllObjects(listObjectsResponse, objects);
        return objects;
    }

    private void retrieveAllObjects(ListObjectsResponse listObjectsResponse, List<String> objects) {
        listObjectsResponse.getContents().forEach(os -> objects.add(os.getKey()));
        if (listObjectsResponse.isTruncated()) {
            ListObjectsResponse nextBatchOfObjects = this.bosClient.listNextBatchOfObjects(listObjectsResponse);
            this.retrieveAllObjects(nextBatchOfObjects, objects);
        }
    }

    public boolean exists(String resourceName) {
        String key = this.resolveKey(resourceName);
        try {
            this.bosClient.getObjectMetadata(this.bucket, key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void disconnect() {
        if (this.bosClient != null) {
            this.bosClient.shutdown();
        }
    }

    private String resolveKey(String path) {
        return this.keyResolver.resolve(this.baseDirectory, path);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }
}

