/*
 * Decompiled with CFR 0.152.
 */
package io.github.maven.repository.bos;

import io.github.maven.repository.bos.AbstractStorageWagon;
import io.github.maven.repository.bos.BosStorageRepo;
import io.github.maven.repository.bos.KeyResolver;
import io.github.maven.repository.bos.ProgressImpl;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BosStorageWagon
extends AbstractStorageWagon {
    private static final Logger log = LoggerFactory.getLogger(BosStorageWagon.class);
    private BosStorageRepo bosStorageRepo;
    private final KeyResolver keyResolver = new KeyResolver();

    public void get(String resourceName, File file) throws TransferFailedException, ResourceDoesNotExistException {
        Resource resource = new Resource(resourceName);
        this.listenerContainer.fireTransferInitiated(resource, 5);
        this.listenerContainer.fireTransferStarted(resource, 5, file);
        ProgressImpl progress = new ProgressImpl(resource, 5, this.listenerContainer);
        try {
            this.bosStorageRepo.copy(resourceName, file, progress);
            this.listenerContainer.fireTransferCompleted(resource, 5);
        }
        catch (Exception e) {
            this.listenerContainer.fireTransferError(resource, 5, e);
            throw e;
        }
    }

    public List<String> getFileList(String s) throws TransferFailedException {
        try {
            List<String> list = this.bosStorageRepo.list(s);
            list = this.convertBosListToMavenFileList(list, s);
            if (list.isEmpty()) {
                throw new ResourceDoesNotExistException(s);
            }
            return list;
        }
        catch (Exception e) {
            throw new TransferFailedException("Could not fetch objects with prefix: " + s);
        }
    }

    public void put(File file, String resourceName) throws TransferFailedException {
        Resource resource = new Resource(resourceName);
        log.info("Uploading file {} to {}", (Object)file.getAbsolutePath(), (Object)resourceName);
        this.listenerContainer.fireTransferInitiated(resource, 6);
        this.listenerContainer.fireTransferStarted(resource, 6, file);
        ProgressImpl progress = new ProgressImpl(resource, 6, this.listenerContainer);
        try {
            this.bosStorageRepo.put(file, resourceName, progress);
            this.listenerContainer.fireTransferCompleted(resource, 6);
        }
        catch (TransferFailedException e) {
            this.listenerContainer.fireTransferError(resource, 6, (Exception)((Object)e));
            throw e;
        }
    }

    public boolean getIfNewer(String resourceName, File file, long timeStamp) throws TransferFailedException, ResourceDoesNotExistException {
        if (this.bosStorageRepo.newResourceAvailable(resourceName, timeStamp)) {
            this.get(resourceName, file);
            return true;
        }
        return false;
    }

    public void putDirectory(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Collection allFiles = FileUtils.listFiles((File)source, null, (boolean)true);
        String relativeDestination = destination;
        if (destination != null && destination.startsWith(".")) {
            relativeDestination = destination.length() == 1 ? "" : destination.substring(1);
        }
        for (File file : allFiles) {
            String relativePath = PathUtils.toRelative((File)source, (String)file.getAbsolutePath());
            this.put(file, relativeDestination + "/" + relativePath);
        }
    }

    public boolean resourceExists(String resourceName) {
        return this.bosStorageRepo.exists(resourceName);
    }

    private List<String> convertBosListToMavenFileList(List<String> list, String path) {
        String prefix = this.keyResolver.resolve(this.bosStorageRepo.getBaseDirectory(), path);
        HashSet folders = new HashSet();
        List<String> result = list.stream().map(key -> {
            String filePath = key;
            if (prefix != null && prefix.length() > 0) {
                filePath = key.substring(prefix.length() + 1);
            }
            this.extractFolders(folders, filePath);
            return filePath;
        }).collect(Collectors.toList());
        result.addAll(folders);
        return result;
    }

    private void extractFolders(Set<String> folders, String filePath) {
        if (filePath.contains("/")) {
            String folder = filePath.substring(0, filePath.lastIndexOf(47));
            folders.add(folder + "/");
            if (folder.contains("/")) {
                this.extractFolders(folders, folder);
            }
        } else {
            folders.add(filePath);
        }
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws AuthenticationException {
        this.repository = repository;
        this.sessionListenerContainer.fireSessionOpening();
        String[] strings = repository.getBasedir().split("/");
        String bucket = strings[1];
        String directory = "/" + strings[2];
        log.info("Opening connection for bucket {} and directory {}", (Object)bucket, (Object)directory);
        this.bosStorageRepo = new BosStorageRepo(bucket, directory);
        this.bosStorageRepo.connect(authenticationInfo, repository.getHost());
        this.sessionListenerContainer.fireSessionLoggedIn();
        this.sessionListenerContainer.fireSessionOpened();
    }

    public void disconnect() {
        this.sessionListenerContainer.fireSessionDisconnecting();
        this.bosStorageRepo.disconnect();
        this.sessionListenerContainer.fireSessionLoggedOff();
        this.sessionListenerContainer.fireSessionDisconnected();
    }

    public void setBosStorageRepo(BosStorageRepo bosStorageRepo) {
        this.bosStorageRepo = bosStorageRepo;
    }

    public BosStorageRepo getBosStorageRepo() {
        return this.bosStorageRepo;
    }

    public KeyResolver getKeyResolver() {
        return this.keyResolver;
    }
}

