/*
 * Decompiled with CFR 0.152.
 */
package io.github.maven.repository.bos;

import io.github.maven.repository.bos.Progress;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public final class ProgressFileOutputStream
extends FileOutputStream {
    private final Progress progress;

    public ProgressFileOutputStream(File file, Progress progress) throws FileNotFoundException {
        super(file);
        this.progress = progress;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.progress.progress(new byte[]{(byte)b}, 1);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        super.write(bytes);
        this.progress.progress(bytes, bytes.length);
    }

    @Override
    public void write(byte[] byteArray, int off, int len) throws IOException {
        super.write(byteArray, off, len);
        if (off == 0) {
            this.progress.progress(byteArray, len);
        } else {
            byte[] bytes = new byte[len];
            System.arraycopy(byteArray, off, bytes, 0, len);
            this.progress.progress(bytes, len);
        }
    }
}

