/*
 * Decompiled with CFR 0.152.
 */
package io.github.maven.repository.bos;

import io.github.maven.repository.bos.SessionListenerContainer;
import java.util.Vector;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionListener;

public class SessionListenerContainerImpl
implements SessionListenerContainer {
    private final Wagon wagon;
    private final Vector<SessionListener> sessionListeners;

    public SessionListenerContainerImpl(Wagon wagon) {
        this.wagon = wagon;
        this.sessionListeners = new Vector();
    }

    @Override
    public void addSessionListener(SessionListener sessionListener) {
        if (sessionListener == null) {
            throw new NullPointerException();
        }
        if (!this.sessionListeners.contains(sessionListener)) {
            this.sessionListeners.add(sessionListener);
        }
    }

    @Override
    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionListeners.remove(sessionListener);
    }

    @Override
    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.sessionListeners.contains(sessionListener);
    }

    @Override
    public void fireSessionOpening() {
        SessionEvent sessionEvent = new SessionEvent(this.wagon, 5);
        this.sessionListeners.forEach(e -> e.sessionOpening(sessionEvent));
    }

    @Override
    public void fireSessionOpened() {
        SessionEvent sessionEvent = new SessionEvent(this.wagon, 6);
        this.sessionListeners.forEach(e -> e.sessionOpened(sessionEvent));
    }

    @Override
    public void fireSessionDisconnecting() {
        SessionEvent sessionEvent = new SessionEvent(this.wagon, 2);
        this.sessionListeners.forEach(e -> e.sessionDisconnecting(sessionEvent));
    }

    @Override
    public void fireSessionDisconnected() {
        SessionEvent sessionEvent = new SessionEvent(this.wagon, 3);
        this.sessionListeners.forEach(se -> se.sessionDisconnected(sessionEvent));
    }

    @Override
    public void fireSessionLoggedIn() {
        SessionEvent sessionEvent = new SessionEvent(this.wagon, 7);
        this.sessionListeners.forEach(se -> se.sessionLoggedIn(sessionEvent));
    }

    @Override
    public void fireSessionLoggedOff() {
        SessionEvent sessionEvent = new SessionEvent(this.wagon, 8);
        this.sessionListeners.forEach(se -> se.sessionLoggedOff(sessionEvent));
    }
}

