package com.admob.ads

//import com.appsflyer.AppsFlyerConversionListener
//import com.appsflyer.AppsFlyerLib
//import com.appsflyer.adrevenue.AppsFlyerAdRevenue
//import com.appsflyer.api.PurchaseClient
//import com.appsflyer.api.Store
//import com.facebook.ads.AudienceNetworkAds
import android.app.Activity
import android.app.Application
import android.os.Bundle
import android.os.SystemClock
import androidx.lifecycle.DefaultLifecycleObserver
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.ProcessLifecycleOwner
import com.admob.ActivityActivityLifecycleCallbacks
import com.admob.AdType
import com.admob.Ads
import com.admob.AdsChild
import com.admob.SAdCallback
import com.admob.adLogger
import com.admob.ads.banner.AdmobBanner
import com.admob.ads.interstitial.AdmobInterResume
import com.admob.ads.nativead.AdmobNative
import com.admob.ads.open.AdmobOpenResume
import com.admob.delay
import com.admob.getStringAssetFile
import com.admob.isDebuggable
import com.admob.logAdClicked
import com.admob.logAdError
import com.admob.logParams
import com.admob.tracking.SGTracking
import com.google.android.gms.ads.AdActivity
import com.google.android.gms.ads.AdRequest
import com.google.android.gms.ads.LoadAdError
import com.google.android.gms.ads.MobileAds
import com.google.firebase.ktx.Firebase
import com.google.firebase.remoteconfig.ktx.remoteConfig
import com.google.firebase.remoteconfig.ktx.remoteConfigSettings
import com.google.gson.Gson
import timber.log.Timber

object AdsSDK {

    internal lateinit var app: Application
    internal  var isDebugging : Boolean = if(::app.isInitialized) app.isDebuggable() else false
    internal var isLogEnable = false

    var isEnableBanner = true
        private set

    var isEnableNative = true
        private set

    var isEnableInter = true
        private set

    var isEnableOpenAds = true
        private set

    var isEnableRewarded = true
        private set

    var isPremium = false
        private set

    private var autoLogPaidValueTrackingInSdk = false


    // Callback for AdsSDK
    private var outsideAdCallback: SAdCallback? = null


    private var preventShowResumeAd = false


//    internal var isEnableAppsflyer = false

    internal var isEnableTiktokEvent = false

    private var gson = Gson()

    var sgTracking:SGTracking? = null


    /**
     * Mark loading time
     *  [String] => AdUnitId
     *  [Long] => Start time loading
     *  [Long] => End time loading
     */
    private var adUnitLoadingTime = mutableMapOf<String, Pair<Long, Long>?>()

    val adCallback: SAdCallback = object : SAdCallback {

        override fun onAdStartLoading(adUnit: String, adType: AdType) {
            super.onAdStartLoading(adUnit, adType)
            adLogger(adType, adUnit, "onAdStartLoading")

            // Đánh dấu thời gian bắt đầu load quảng cáo
            markAdStartLoading(adUnit)
        }

        override fun onAdClicked(adUnit: String, adType: AdType) {
            super.onAdClicked(adUnit, adType)
            outsideAdCallback?.onAdClicked(adUnit, adType)
            adLogger(adType, adUnit, "onAdClicked")
            logAdClicked(adType, adUnit)
        }

        override fun onAdClosed(adUnit: String, adType: AdType) {
            super.onAdClosed(adUnit, adType)
            outsideAdCallback?.onAdClosed(adUnit, adType)
            adLogger(adType, adUnit, "onAdClosed")

            // Reset đánh dấu quảng cáo
            clearMarkLoadingTime(adUnit)
        }

        override fun onAdDismissedFullScreenContent(adUnit: String, adType: AdType) {
            super.onAdDismissedFullScreenContent(adUnit, adType)
            outsideAdCallback?.onAdDismissedFullScreenContent(adUnit, adType)
            adLogger(adType, adUnit, "onAdDismissedFullScreenContent")

            // Reset đánh dấu quảng cáo
            clearMarkLoadingTime(adUnit)
        }

        override fun onAdShowedFullScreenContent(adUnit: String, adType: AdType) {
            super.onAdShowedFullScreenContent(adUnit, adType)
            outsideAdCallback?.onAdShowedFullScreenContent(adUnit, adType)
            adLogger(adType, adUnit, "onAdShowedFullScreenContent")
        }

        override fun onAdFailedToShowFullScreenContent(
            error: String,
            adUnit: String,
            adType: AdType
        ) {
            super.onAdFailedToShowFullScreenContent(error, adUnit, adType)
            outsideAdCallback?.onAdFailedToShowFullScreenContent(error, adUnit, adType)
            adLogger(adType, adUnit, "onAdFailedToShowFullScreenContent")

            markAdEndLoading(adUnit)
            val loadingTime = getAdLoadingTime(adUnit)
            logAdError(
                error,
                adUnit,
                adType,
                loadingTime
            )

            clearMarkLoadingTime(adUnit)
        }

        override fun onAdFailedToLoad(adUnit: String, adType: AdType, error: LoadAdError) {
            super.onAdFailedToLoad(adUnit, adType, error)
            outsideAdCallback?.onAdFailedToLoad(adUnit, adType, error)
            adLogger(adType, adUnit, "onAdFailedToLoad(${error.code} - ${error.message})")


            // Đánh dấu thời gian bắt đầu load xong quảng cáo (load bị lỗi)
            markAdEndLoading(adUnit)
            val loadingTime = getAdLoadingTime(adUnit)
            logAdError(
                error.message,
                adUnit,
                adType,
                loadingTime
            )

            clearMarkLoadingTime(adUnit)
        }

        override fun onAdImpression(adUnit: String, adType: AdType) {
            super.onAdImpression(adUnit, adType)
            outsideAdCallback?.onAdImpression(adUnit, adType)
            adLogger(adType, adUnit, "onAdImpression")
        }

        override fun onAdLoaded(adUnit: String, adType: AdType) {
            super.onAdLoaded(adUnit, adType)
            outsideAdCallback?.onAdLoaded(adUnit, adType)
            adLogger(adType, adUnit, "onAdLoaded")


            // Đánh dấu thời gian bắt đầu load xong quảng cáo (load bị lỗi)
            markAdEndLoading(adUnit)
        }

        override fun onAdOpened(adUnit: String, adType: AdType) {
            super.onAdOpened(adUnit, adType)
            outsideAdCallback?.onAdOpened(adUnit, adType)
            adLogger(adType, adUnit, "onAdOpened")
        }

        override fun onAdSwipeGestureClicked(adUnit: String, adType: AdType) {
            super.onAdSwipeGestureClicked(adUnit, adType)
            outsideAdCallback?.onAdSwipeGestureClicked(adUnit, adType)
            adLogger(adType, adUnit, "onAdSwipeGestureClicked")
        }

        override fun onPaidValueListener(bundle: Bundle) {
            super.onPaidValueListener(bundle)
            outsideAdCallback?.onPaidValueListener(bundle)

            if (autoLogPaidValueTrackingInSdk) {
                logParams("AdValue") {
                    bundle.keySet().forEach { key ->
                        val value = bundle.getString(key)
                        if (!value.isNullOrBlank()) {
                            param(key, value)
                        }
                    }
                }
            }
        }

        override fun onSetInterFloorId() {
            super.onSetInterFloorId()
            outsideAdCallback?.onSetInterFloorId()
        }

        override fun onDisable() {
            super.onDisable()
            outsideAdCallback?.onDisable()
        }

        override fun onCollapsibleDismiss() {
            super.onCollapsibleDismiss()
            outsideAdCallback?.onCollapsibleDismiss()
        }
    }

    val activities = mutableSetOf<Activity>()

    val clazzIgnoreAdResume = mutableListOf<Class<*>>()

    private val applicationStateObserver = object : DefaultLifecycleObserver {


        override fun onStart(owner: LifecycleOwner) {
            super.onStart(owner)
            if (preventShowResumeAd) {
                preventShowResumeAd = false
                return
            }
            AdmobInterResume.onInterAppResume()
            AdmobOpenResume.onOpenAdAppResume()
        }

        override fun onResume(owner: LifecycleOwner) {
            super.onResume(owner)

        }

        override fun onStop(owner: LifecycleOwner) {
            super.onStop(owner)
        }
    }

    private val activityLifecycleCallbacks = object : ActivityActivityLifecycleCallbacks() {
        override fun onActivityCreated(activity: Activity, bundle: Bundle?) {
            super.onActivityCreated(activity, bundle)
            activities.add(activity)
        }

        override fun onActivityResumed(activity: Activity) {
            super.onActivityResumed(activity)
            activities.add(activity)
        }

        override fun onActivityDestroyed(activity: Activity) {
            super.onActivityDestroyed(activity)
            activities.remove(activity)
        }
    }

    fun init(
        application: Application,
        path: String,
        keyConfigAds: String,
        isDebug : Boolean = application.isDebuggable(),
        logEnable: Boolean = true,
        listDeviceTest: List<String> = emptyList()
    ): AdsSDK {
        app = application
        this.isDebugging = isDebug
        this.isLogEnable = logEnable
        Timber.plant(object :Timber.DebugTree(){

            override fun createStackElementTag(element: StackTraceElement): String? {
                val parts = super.createStackElementTag(element)?.split("$")
                    ?: return super.createStackElementTag(element)

                if (parts.size >= 2) {
                    return "(${element.fileName}:${element.lineNumber}) ${parts[1]}"
                }
                // https://stackoverflow.com/a/49216400/5199098
                return "(${element.fileName}:${element.lineNumber}) ${element.methodName}"
            }
        })

        ProcessLifecycleOwner.get().lifecycle.addObserver(applicationStateObserver)
        application.registerActivityLifecycleCallbacks(activityLifecycleCallbacks)

        delay(1000) {
            MobileAds.setRequestConfiguration(
                MobileAds.getRequestConfiguration().toBuilder()
                    .setTestDeviceIds(listDeviceTest)
                    .build()
            )
            MobileAds.initialize(application){ status ->
                Timber.d("MobileAds initialize success")
                status.adapterStatusMap.forEach {
                    Timber.d("Adapter: ${it.key} - ${it.value.initializationState}")
                }
            }
//            AudienceNetworkAds.initialize(application)
        }

        getData(path,keyConfigAds)
        return this
    }


    private val listAds = mutableListOf<AdsChild>()
    private fun getData(path: String, keyConfigAds: String) {
        try {
            val data = getStringAssetFile(path, app)
            val ads = gson.fromJson<Ads>(data, Ads::class.java)
            listAds.clear()
            listAds.addAll(ads.listAdsChild)
            listAds.forEach {
                Timber.d(it.toString())
            }
        } catch (e: Exception) {
            Timber.d(e, "no load data json ads file")
        }
        getRemoteConfig(keyConfigAds)
    }

    private fun getRemoteConfig(keyConfigAds: String) {
        Firebase.remoteConfig.apply {
            setConfigSettingsAsync(remoteConfigSettings { minimumFetchIntervalInSeconds = 0 })
            fetchAndActivate().addOnCompleteListener {
                try {
                    val data = getString(keyConfigAds)

                    if (data.isNullOrBlank()) return@addOnCompleteListener

                    val ads = gson.fromJson<Ads>(data, Ads::class.java)
                    listAds.clear()
                    listAds.addAll(ads.listAdsChild)
                    listAds.forEach {
                        Timber.d(it.toString())
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        }
    }

    /**
     * Get AdsChild by space
     */
    fun getAdChild(space: String): AdsChild? {

        return listAds.find {
            it.spaceName == space
        }

    }

    /**
     * Enable or disable Tiktok event
     * Default is disable
     */
    fun enableTiktokEvent(isEnable: Boolean): AdsSDK{
        isEnableTiktokEvent = isEnable
        return this
    }


//    fun enableAppsflyer(appsflyerId: String): AdsSDK {
//        isEnableAppsflyer = true
////        val afRevenueBuilder = AppsFlyerAdRevenue.Builder(app)
////        AppsFlyerAdRevenue.initialize(afRevenueBuilder.build())
////        AppsFlyerLib.getInstance().init(
////            appsflyerId,
////            object : AppsFlyerConversionListener {
////                override fun onConversionDataSuccess(p0: MutableMap<String, Any>?) {
////                    Log.i("AdsSDK", "AppsFlyer ==> onConversionDataSuccess($p0)")
////                }
////
////                override fun onConversionDataFail(p0: String?) {
////                    Log.i("AdsSDK", "AppsFlyer ==> onConversionDataFail($p0)")
////                }
////
////                override fun onAppOpenAttribution(p0: MutableMap<String, String>?) {
////                    Log.i("AdsSDK", "AppsFlyer ==> onAppOpenAttribution($p0)")
////                }
////
////                override fun onAttributionFailure(p0: String?) {
////                    Log.i("AdsSDK", "AppsFlyer ==> onAttributionFailure($p0")
////                }
////            },
////            app
////        )
////
////        AppsFlyerLib.getInstance().setCollectAndroidID(true)
////        AppsFlyerLib.getInstance().setCollectIMEI(true)
////        AppsFlyerLib.getInstance().setCollectOaid(true)
////        AppsFlyerLib.getInstance().start(app)
////
////        val builder = PurchaseClient.Builder(app, Store.GOOGLE)
////
////        builder.logSubscriptions(true)
////        builder.autoLogInApps(true)
////
////        if (BuildConfig.DEBUG) {
////            AppsFlyerLib.getInstance().setDebugLog(true)
////        }
////
////        val afPurchaseClient = builder.build()
////        afPurchaseClient.startObservingTransactions()
////        return this
//    }

    /**
     * Set callback for AdsSDK
     * This callback will be called when any ad event is triggered
     */
    fun setAdCallback(callback: SAdCallback): AdsSDK {
        outsideAdCallback = callback
        return this
    }

    /**
     * Hàm để thêm các activity không hiển thị App Open ad khi resume app
     * Add class to ignore resume ad show
     * This class will not trigger resume ad show
     * Default auto add AdActivity
     */
    fun addIgnoreAdResume(vararg clazz: Class<*>): AdsSDK {
        clazzIgnoreAdResume.clear()
        clazzIgnoreAdResume.add(AdActivity::class.java)
        clazzIgnoreAdResume.addAll(clazz)
        return this
    }

    /**
     * Prevent show resume ad when app resume
     * This function will prevent show resume ad when app resume
     */
    fun preventShowResumeAdNextTime() {
        preventShowResumeAd = true
    }


    /**
     * Set enable or disable banner
     */
    fun setEnableBanner(isEnable: Boolean) {
        isEnableBanner = isEnable
        AdmobBanner.setEnableBanner(isEnable)
    }

    /**
     * Set enable or disable native
     */
    fun setEnableNative(isEnable: Boolean) {
        isEnableNative = isEnable
        AdmobNative.setEnableNative(isEnable)
    }

    /**
     * Set enable or disable interstitial
     */
    fun setEnableInter(isEnable: Boolean) {
        isEnableInter = isEnable
    }

    /**
     * Set enable or disable open ads
     */
    fun setEnableOpenAds(isEnable: Boolean) {
        isEnableOpenAds = isEnable
    }

    /**
     * Set enable or disable rewarded
     */
    fun setEnableRewarded(isEnable: Boolean) {
        isEnableRewarded = isEnable
    }

    /**
     * Set premium user
     *  Tự động disable tất cả các loại quảng cáo
     */
    fun setPremium() {
        isPremium = true
        setEnableNative(false)
        setEnableInter(false)
        setEnableOpenAds(false)
        setEnableRewarded(false)
        setEnableBanner(false)
    }

    /**
     * Set Auto tracking paid value in SDK
     * Default is false
     * Các event sẽ được tracking và log qua SGTracking
     */
    fun setAutoTrackingPaidValueInSdk(useInSDK: Boolean): AdsSDK {
        autoLogPaidValueTrackingInSdk = useInSDK
        return this
    }

    /**
     * Hàm trả về AdRequest mặc định
     */
    internal fun defaultAdRequest(): AdRequest {
        return AdRequest.Builder().build()
    }

    /**
     * Đánh dấu thời gian bắt đầu load quảng cáo
     */
    private fun markAdStartLoading(adUnitId: String) {
        adUnitLoadingTime[adUnitId] = Pair(SystemClock.elapsedRealtime(), 0)
    }

    /**
     * Đánh dấu thời gian kết thúc load quảng cáo
     */
    private fun markAdEndLoading(adUnitId: String) {
        val pairStartEndTime = adUnitLoadingTime[adUnitId]
        pairStartEndTime ?: return
        val startAdLoadingTime = pairStartEndTime.first
        adUnitLoadingTime[adUnitId] = Pair(startAdLoadingTime, SystemClock.elapsedRealtime())
    }

    /**
     * Lấy thời gian load quảng cáo
     */
    internal fun getAdLoadingTime(adUnitId: String): Long {
        val pairStartEndTime = adUnitLoadingTime[adUnitId]
        pairStartEndTime ?: return -1

        val startAdLoadingTime = pairStartEndTime.first
        val endAdLoadingTime = pairStartEndTime.second

        if (startAdLoadingTime <= 0 || endAdLoadingTime <= 0) {
            return -1
        }

        if (endAdLoadingTime - startAdLoadingTime <= 0) {
            return -1
        }

        return endAdLoadingTime - startAdLoadingTime
    }

    /**
     * Xóa đánh dấu thời gian load quảng cáo
     */
    internal fun clearMarkLoadingTime(adUnitId: String) {
        adUnitLoadingTime.remove(adUnitId)
    }

}



