package com.admob.ads.interstitial

import com.admob.ads.AdsSDK
import com.admob.getClazzOnTop
import com.admob.getComponentActivityOnTop
import com.admob.topActivityIsAd
import com.admob.ui.dialogs.DialogWelcomeBackAds
import com.admob.waitActivityResumed
import com.admob.waitActivityStop

object AdmobInterResume {

    private lateinit var adUnitId: String

    fun load(id: String) {
        adUnitId = id
        AdmobInter.load(adUnitId, null)
    }

    internal fun onInterAppResume(nextAction: () -> Unit = {}) {

        if (!AdsSDK.isEnableInter){
            nextAction.invoke()
            return
        }

        if (!AdmobInterResume::adUnitId.isInitialized) {
            return
        }

        val activity = AdsSDK.getComponentActivityOnTop()
        activity ?: return

        val clazzOnTop = AdsSDK.getClazzOnTop()
        val adActivityOnTop = AdsSDK.topActivityIsAd()
        val containClazzOnTop = AdsSDK.clazzIgnoreAdResume.contains(AdsSDK.getClazzOnTop())
        if (clazzOnTop == null || containClazzOnTop || adActivityOnTop) {
            return
        }

        if (!AdmobInter.checkShowInterCondition(adUnitId, true)) {
            return
        }

        val dialog = DialogWelcomeBackAds(activity) {
            if (AdmobInter.checkShowInterCondition(adUnitId, true)) {
//                AdmobInter.show(
//                    adUnitId = adUnitId,
//                    showLoadingInter = false,
//                    forceShow = true,
//                    loadAfterDismiss = true,
//                    loadIfNotAvailable = true,
//                    callback = null,
//                    nextAction = nextAction
//                )
            }
        }

        activity.waitActivityStop {
            if (dialog.isShowing) {
                dialog.dismiss()
            }
        }

        activity.waitActivityResumed {
            dialog.show()
        }
    }
}
