/*
 * Decompiled with CFR 0.152.
 */
package com.admob.cmp;

import android.app.Activity;
import android.content.ContentResolver;
import android.provider.Settings;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/admob/cmp/Utils;", "", "()V", "getDeviceID", "", "application", "Landroid/app/Activity;", "md5", "s", "SoftGO Ads SDK_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @NotNull
    public final String getDeviceID(@NotNull Activity application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        String android_id = Settings.Secure.getString((ContentResolver)application.getContentResolver(), (String)"android_id");
        Intrinsics.checkNotNull((Object)android_id);
        String string = this.md5(android_id);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
        return string2;
    }

    @NotNull
    public final String md5(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            String string = s;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            digest.update(byArray);
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            int n = messageDigest.length;
            for (int i = 0; i < n; ++i) {
                StringBuilder h = new StringBuilder(Integer.toHexString(0xFF & messageDigest[i]));
                while (h.length() < 2) {
                    h.insert(0, "0");
                }
                hexString.append((CharSequence)h);
            }
            String string2 = hexString.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

