/*
 * Decompiled with CFR 0.152.
 */
package com.admob;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Bundle;
import android.os.Handler;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.activity.ComponentActivity;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.admob.AdType;
import com.admob.TTrackingKt;
import com.admob.UtilsKt;
import com.admob.ads.AdsSDK;
import com.admob.ads.open.AdmobOpenResume;
import com.admob.databinding.AdLoadingViewBinding;
import com.google.android.gms.ads.AdActivity;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.ResponseInfo;
import com.google.firebase.analytics.ktx.ParametersBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u001c\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\u001c\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u001b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\b\u0010\u001c\u001a\u00020\u0015H\u0007\u001a(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010#\u001a\u0018\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'\u001a&\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u001b\u001a\u0014\u0010+\u001a\u00020\u00112\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\u0014\u0010-\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\n\u0010.\u001a\u00020\u0011*\u00020/\u001a\u0018\u00100\u001a\u00020\u0011*\u0002012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\f\u00102\u001a\u0004\u0018\u000101*\u000203\u001a\u0010\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u000105*\u000203\u001a\f\u00106\u001a\u0004\u0018\u000107*\u000203\u001a\n\u00108\u001a\u000209*\u00020'\u001a\n\u0010:\u001a\u000209*\u00020;\u001a\n\u0010<\u001a\u000209*\u00020;\u001a\u001a\u0010=\u001a\u00020\u0011*\u0004\u0018\u0001072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\n\u0010>\u001a\u000209*\u000203\u001a\u0018\u0010?\u001a\u00020\u0011*\u0002072\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\u0018\u0010A\u001a\u00020\u0011*\u0002072\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\u0018\u0010C\u001a\u00020\u0011*\u0002072\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\u0018\u0010E\u001a\u00020\u0011*\u00020'2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\u0018\u0010F\u001a\u00020\u0011*\u0002012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\u001a\u0018\u0010G\u001a\u00020\u0011*\u0002012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0011\u0010\b\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006H"}, d2={"anchoredAdaptiveBannerSize", "Lcom/google/android/gms/ads/AdSize;", "getAnchoredAdaptiveBannerSize", "()Lcom/google/android/gms/ads/AdSize;", "displayMetrics", "Landroid/util/DisplayMetrics;", "getDisplayMetrics", "()Landroid/util/DisplayMetrics;", "inlineAdaptiveBannerSize", "getInlineAdaptiveBannerSize", "screenHeight", "", "getScreenHeight", "()I", "screenWidth", "getScreenWidth", "adLogger", "", "adType", "Lcom/admob/AdType;", "adUnitId", "", "message", "delay", "duration", "block", "Lkotlin/Function0;", "", "getNetwork", "getPaidTrackingBundle", "Landroid/os/Bundle;", "adValue", "Lcom/google/android/gms/ads/AdValue;", "adId", "responseInfo", "Lcom/google/android/gms/ads/ResponseInfo;", "getStringAssetFile", "path", "application", "Landroid/app/Application;", "logAdError", "adError", "loadingTime", "onNextActionWhenResume", "nextAction", "safeRun", "addLoadingView", "Landroid/view/ViewGroup;", "avoidShowWhenResume", "Landroid/app/Activity;", "getActivityOnTop", "Lcom/admob/ads/AdsSDK;", "getClazzOnTop", "Ljava/lang/Class;", "getComponentActivityOnTop", "Landroidx/activity/ComponentActivity;", "isDebuggable", "", "isInternetConnected", "Landroid/content/Context;", "isNetworkAvailable", "runIfResuming", "topActivityIsAd", "waitActivityDestroy", "onDestroy", "waitActivityResumed", "onResumed", "waitActivityStop", "onStopped", "waitToResume", "waitingResume", "waitingResumeNoDelay", "SoftGO Ads SDK_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/admob/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,476:1\n1#2:477\n*E\n"})
public final class UtilsKt {
    public static final boolean isDebuggable(@NotNull Application $this$isDebuggable) {
        Intrinsics.checkNotNullParameter((Object)$this$isDebuggable, (String)"<this>");
        return ($this$isDebuggable.getApplicationInfo().flags & 2) != 0;
    }

    @NotNull
    public static final DisplayMetrics getDisplayMetrics() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"getDisplayMetrics(...)");
        return displayMetrics;
    }

    public static final int getScreenWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public static final int getScreenHeight() {
        return Resources.getSystem().getDisplayMetrics().heightPixels;
    }

    @NotNull
    public static final AdSize getInlineAdaptiveBannerSize() {
        int adWidth = (int)((float)UtilsKt.getScreenWidth() / UtilsKt.getDisplayMetrics().density);
        AdSize adSize = AdSize.getCurrentOrientationInlineAdaptiveBannerAdSize((Context)((Context)AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release()), (int)adWidth);
        Intrinsics.checkNotNullExpressionValue((Object)adSize, (String)"getCurrentOrientationInl\u2026AdaptiveBannerAdSize(...)");
        return adSize;
    }

    @NotNull
    public static final AdSize getAnchoredAdaptiveBannerSize() {
        int adWidth = (int)((float)UtilsKt.getScreenWidth() / UtilsKt.getDisplayMetrics().density);
        AdSize adSize = AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)((Context)AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release()), (int)adWidth);
        Intrinsics.checkNotNullExpressionValue((Object)adSize, (String)"getCurrentOrientationAnc\u2026AdaptiveBannerAdSize(...)");
        return adSize;
    }

    public static final void logAdError(@NotNull String adError, @NotNull String adId, @NotNull AdType adType, long loadingTime) {
        String string;
        Intrinsics.checkNotNullParameter((Object)adError, (String)"adError");
        Intrinsics.checkNotNullParameter((Object)adId, (String)"adId");
        Intrinsics.checkNotNullParameter((Object)adType, (String)"adType");
        AdType adType2 = adType;
        if (Intrinsics.areEqual((Object)adType2, (Object)AdType.OpenApp.INSTANCE)) {
            string = Intrinsics.areEqual((Object)adId, (Object)AdmobOpenResume.INSTANCE.getAdUnitId$SoftGO_Ads_SDK_release()) ? "ad_open_ads_resume" : "ad_open_ads";
        } else if (Intrinsics.areEqual((Object)adType2, (Object)AdType.Inter.INSTANCE)) {
            string = "ad_interstitial";
        } else if (Intrinsics.areEqual((Object)adType2, (Object)AdType.Banner.INSTANCE)) {
            string = "ad_banner";
        } else if (Intrinsics.areEqual((Object)adType2, (Object)AdType.Native.INSTANCE)) {
            string = "ad_native";
        } else if (Intrinsics.areEqual((Object)adType2, (Object)AdType.Rewarded.INSTANCE)) {
            string = "ad_rewarded";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String adFormat = string;
        TTrackingKt.logParams("ad_error", (Function1<? super ParametersBuilder, Unit>)((Function1)new Function1<ParametersBuilder, Unit>(adId, adFormat, loadingTime, adError){
            final /* synthetic */ String $adId;
            final /* synthetic */ String $adFormat;
            final /* synthetic */ long $loadingTime;
            final /* synthetic */ String $adError;
            {
                this.$adId = $adId;
                this.$adFormat = $adFormat;
                this.$loadingTime = $loadingTime;
                this.$adError = $adError;
                super(1);
            }

            public final void invoke(@NotNull ParametersBuilder $this$logParams) {
                Intrinsics.checkNotNullParameter((Object)$this$logParams, (String)"$this$logParams");
                $this$logParams.param("ad_unit_id", this.$adId);
                $this$logParams.param("ad_format", this.$adFormat);
                $this$logParams.param("loading_time", String.valueOf(this.$loadingTime));
                $this$logParams.param("error_reason", StringsKt.take((String)StringsKt.replace$default((String)this.$adError, (String)" ", (String)"_", (boolean)false, (int)4, null), (int)100));
                String string = Locale.getDefault().getCountry();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCountry(...)");
                $this$logParams.param("country_code", string);
                $this$logParams.param("network_type", UtilsKt.getNetwork());
            }
        }));
    }

    @NotNull
    public static final Bundle getPaidTrackingBundle(@NotNull AdValue adValue, @NotNull String adId, @NotNull String adType, @Nullable ResponseInfo responseInfo) {
        Bundle bundle;
        block0: {
            AdapterResponseInfo adapterResponseInfo;
            Intrinsics.checkNotNullParameter((Object)adValue, (String)"adValue");
            Intrinsics.checkNotNullParameter((Object)adId, (String)"adId");
            Intrinsics.checkNotNullParameter((Object)adType, (String)"adType");
            Bundle $this$getPaidTrackingBundle_u24lambda_u241 = bundle = new Bundle();
            boolean bl = false;
            $this$getPaidTrackingBundle_u24lambda_u241.putString("ad_unit_id", adId);
            $this$getPaidTrackingBundle_u24lambda_u241.putString("ad_type", adType);
            $this$getPaidTrackingBundle_u24lambda_u241.putString("revenue_micros", String.valueOf(adValue.getValueMicros()));
            $this$getPaidTrackingBundle_u24lambda_u241.putString("precision_type", String.valueOf(adValue.getPrecisionType()));
            ResponseInfo responseInfo2 = responseInfo;
            AdapterResponseInfo adapterResponseInfo2 = adapterResponseInfo = responseInfo2 != null ? responseInfo2.getLoadedAdapterResponseInfo() : null;
            if (adapterResponseInfo2 == null) break block0;
            AdapterResponseInfo it = adapterResponseInfo2;
            boolean bl2 = false;
            $this$getPaidTrackingBundle_u24lambda_u241.putString("ad_source_id", it.getAdSourceId());
            $this$getPaidTrackingBundle_u24lambda_u241.putString("ad_source_name", it.getAdSourceName());
        }
        return bundle;
    }

    public static final void waitingResume(@NotNull Activity $this$waitingResume, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$waitingResume, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if ($this$waitingResume instanceof ComponentActivity) {
            if (((ComponentActivity)$this$waitingResume).getLifecycle().getCurrentState() == Lifecycle.State.RESUMED) {
                block.invoke();
                return;
            }
            ((ComponentActivity)$this$waitingResume).getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver($this$waitingResume, block){
                final /* synthetic */ Activity $this_waitingResume;
                final /* synthetic */ Function0<Unit> $block;
                {
                    this.$this_waitingResume = $receiver;
                    this.$block = $block;
                }

                public void onResume(@NotNull LifecycleOwner owner) {
                    Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                    super.onResume(owner);
                    ((ComponentActivity)this.$this_waitingResume).getLifecycle().removeObserver((LifecycleObserver)this);
                    UtilsKt.delay(1500, (Function0<Unit>)((Function0)new Function0<Unit>(this.$block){
                        final /* synthetic */ Function0<Unit> $block;
                        {
                            this.$block = $block;
                            super(0);
                        }

                        public final void invoke() {
                            this.$block.invoke();
                        }
                    }));
                }
            });
            return;
        }
        block.invoke();
    }

    public static final void waitingResumeNoDelay(@NotNull Activity $this$waitingResumeNoDelay, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$waitingResumeNoDelay, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if ($this$waitingResumeNoDelay instanceof ComponentActivity) {
            if (((ComponentActivity)$this$waitingResumeNoDelay).getLifecycle().getCurrentState() == Lifecycle.State.RESUMED) {
                UtilsKt.delay(20, (Function0<Unit>)((Function0)new Function0<Unit>(block){
                    final /* synthetic */ Function0<Unit> $block;
                    {
                        this.$block = $block;
                        super(0);
                    }

                    public final void invoke() {
                        this.$block.invoke();
                    }
                }));
                return;
            }
            ((ComponentActivity)$this$waitingResumeNoDelay).getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver($this$waitingResumeNoDelay, block){
                final /* synthetic */ Activity $this_waitingResumeNoDelay;
                final /* synthetic */ Function0<Unit> $block;
                {
                    this.$this_waitingResumeNoDelay = $receiver;
                    this.$block = $block;
                }

                public void onDestroy(@NotNull LifecycleOwner owner) {
                    Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                    super.onDestroy(owner);
                    ((ComponentActivity)this.$this_waitingResumeNoDelay).getLifecycle().removeObserver((LifecycleObserver)this);
                }

                public void onResume(@NotNull LifecycleOwner owner) {
                    Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                    super.onResume(owner);
                    ((ComponentActivity)this.$this_waitingResumeNoDelay).getLifecycle().removeObserver((LifecycleObserver)this);
                    UtilsKt.delay(20, (Function0<Unit>)((Function0)new Function0<Unit>(this.$block){
                        final /* synthetic */ Function0<Unit> $block;
                        {
                            this.$block = $block;
                            super(0);
                        }

                        public final void invoke() {
                            this.$block.invoke();
                        }
                    }));
                }
            });
            return;
        }
    }

    public static final void waitToResume(@NotNull Application $this$waitToResume, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$waitToResume, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        DefaultLifecycleObserver applicationStateObserver2 = new DefaultLifecycleObserver(block){
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$block = $block;
            }

            public void onStart(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super.onStart(owner);
            }

            public void onResume(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super.onResume(owner);
                this.$block.invoke();
                ProcessLifecycleOwner.Companion.get().getLifecycle().removeObserver((LifecycleObserver)this);
            }
        };
        ProcessLifecycleOwner.Companion.get().getLifecycle().addObserver((LifecycleObserver)applicationStateObserver2);
    }

    public static final void avoidShowWhenResume(@NotNull Activity $this$avoidShowWhenResume, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$avoidShowWhenResume, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if ($this$avoidShowWhenResume instanceof ComponentActivity && ((ComponentActivity)$this$avoidShowWhenResume).getLifecycle().getCurrentState() == Lifecycle.State.RESUMED) {
            block.invoke();
            return;
        }
    }

    public static final void delay(int duration, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (duration > 0) {
            UtilsKt.safeRun((Function0<Unit>)((Function0)new Function0<Unit>(duration, block){
                final /* synthetic */ int $duration;
                final /* synthetic */ Function0<Unit> $block;
                {
                    this.$duration = $duration;
                    this.$block = $block;
                    super(0);
                }

                public final void invoke() {
                    new Handler().postDelayed(() -> delay.1.invoke$lambda$0(this.$block), (long)this.$duration);
                }

                private static final void invoke$lambda$0(Function0 $block) {
                    Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
                    $block.invoke();
                }
            }));
            return;
        }
        block.invoke();
    }

    public static final void delay(long duration, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (duration > 0L) {
            UtilsKt.safeRun((Function0<Unit>)((Function0)new Function0<Unit>(duration, block){
                final /* synthetic */ long $duration;
                final /* synthetic */ Function0<Unit> $block;
                {
                    this.$duration = $duration;
                    this.$block = $block;
                    super(0);
                }

                public final void invoke() {
                    new Handler().postDelayed(() -> delay.2.invoke$lambda$0(this.$block), this.$duration);
                }

                private static final void invoke$lambda$0(Function0 $block) {
                    Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
                    $block.invoke();
                }
            }));
            return;
        }
        block.invoke();
    }

    public static final void safeRun(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            block.invoke();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static final boolean isInternetConnected(@NotNull Context $this$isInternetConnected) {
        Intrinsics.checkNotNullParameter((Object)$this$isInternetConnected, (String)"<this>");
        Object object = $this$isInternetConnected.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager cm = (ConnectivityManager)object;
        return cm.getActiveNetwork() != null && cm.getNetworkCapabilities(cm.getActiveNetwork()) != null;
    }

    public static final void runIfResuming(@Nullable ComponentActivity $this$runIfResuming, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ComponentActivity componentActivity = $this$runIfResuming;
        if ((componentActivity != null && (componentActivity = componentActivity.getLifecycle()) != null ? componentActivity.getCurrentState() : null) == Lifecycle.State.RESUMED) {
            block.invoke();
        }
    }

    public static final void addLoadingView(@NotNull ViewGroup $this$addLoadingView) {
        Intrinsics.checkNotNullParameter((Object)$this$addLoadingView, (String)"<this>");
        FrameLayout frameLayout = AdLoadingViewBinding.inflate(LayoutInflater.from((Context)$this$addLoadingView.getContext()), $this$addLoadingView, false).getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"getRoot(...)");
        FrameLayout view = frameLayout;
        $this$addLoadingView.removeAllViews();
        $this$addLoadingView.addView((View)view);
        view.requestLayout();
    }

    @Nullable
    public static final Activity getActivityOnTop(@NotNull AdsSDK $this$getActivityOnTop) {
        Intrinsics.checkNotNullParameter((Object)$this$getActivityOnTop, (String)"<this>");
        Iterable iterable = $this$getActivityOnTop.getActivities();
        Object var2_2 = null;
        for (Object t : iterable) {
            Activity it = (Activity)t;
            boolean bl = false;
            if (!(!it.isFinishing())) continue;
            var2_2 = t;
        }
        return var2_2;
    }

    public static final boolean topActivityIsAd(@NotNull AdsSDK $this$topActivityIsAd) {
        Intrinsics.checkNotNullParameter((Object)$this$topActivityIsAd, (String)"<this>");
        Activity top = UtilsKt.getActivityOnTop($this$topActivityIsAd);
        return top instanceof AdActivity;
    }

    @Nullable
    public static final ComponentActivity getComponentActivityOnTop(@NotNull AdsSDK $this$getComponentActivityOnTop) {
        Intrinsics.checkNotNullParameter((Object)$this$getComponentActivityOnTop, (String)"<this>");
        Iterable iterable = $this$getComponentActivityOnTop.getActivities();
        Object var3_2 = null;
        for (Object t : iterable) {
            Activity it = (Activity)t;
            boolean bl = false;
            if (!(it instanceof ComponentActivity && !((ComponentActivity)it).isFinishing())) continue;
            var3_2 = t;
        }
        Object var1_7 = var3_2;
        return var1_7 instanceof ComponentActivity ? (ComponentActivity)var1_7 : null;
    }

    @Nullable
    public static final Class<?> getClazzOnTop(@NotNull AdsSDK $this$getClazzOnTop) {
        Intrinsics.checkNotNullParameter((Object)$this$getClazzOnTop, (String)"<this>");
        ComponentActivity componentActivity = UtilsKt.getComponentActivityOnTop(AdsSDK.INSTANCE);
        if (componentActivity == null) {
            return null;
        }
        ComponentActivity activity = componentActivity;
        return activity.getClass();
    }

    public static final boolean isNetworkAvailable(@NotNull Context $this$isNetworkAvailable) {
        ConnectivityManager connectivityManager;
        Intrinsics.checkNotNullParameter((Object)$this$isNetworkAvailable, (String)"<this>");
        ConnectivityManager connectivityManager2 = connectivityManager = (ConnectivityManager)$this$isNetworkAvailable.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)connectivityManager2);
        Network network = connectivityManager2.getActiveNetwork();
        NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
        return networkCapabilities != null && networkCapabilities.hasCapability(12);
    }

    public static final void waitActivityResumed(@NotNull ComponentActivity $this$waitActivityResumed, @NotNull Function0<Unit> onResumed) {
        Intrinsics.checkNotNullParameter((Object)$this$waitActivityResumed, (String)"<this>");
        Intrinsics.checkNotNullParameter(onResumed, (String)"onResumed");
        $this$waitActivityResumed.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver($this$waitActivityResumed, onResumed){
            final /* synthetic */ ComponentActivity $this_waitActivityResumed;
            final /* synthetic */ Function0<Unit> $onResumed;
            {
                this.$this_waitActivityResumed = $receiver;
                this.$onResumed = $onResumed;
            }

            public void onResume(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super.onResume(owner);
                this.$this_waitActivityResumed.getLifecycle().removeObserver((LifecycleObserver)this);
                this.$onResumed.invoke();
            }
        });
    }

    public static final void waitActivityStop(@NotNull ComponentActivity $this$waitActivityStop, @NotNull Function0<Unit> onStopped) {
        Intrinsics.checkNotNullParameter((Object)$this$waitActivityStop, (String)"<this>");
        Intrinsics.checkNotNullParameter(onStopped, (String)"onStopped");
        $this$waitActivityStop.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver($this$waitActivityStop, onStopped){
            final /* synthetic */ ComponentActivity $this_waitActivityStop;
            final /* synthetic */ Function0<Unit> $onStopped;
            {
                this.$this_waitActivityStop = $receiver;
                this.$onStopped = $onStopped;
            }

            public void onStop(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super.onStop(owner);
                this.$this_waitActivityStop.getLifecycle().removeObserver((LifecycleObserver)this);
                this.$onStopped.invoke();
            }
        });
    }

    public static final void waitActivityDestroy(@NotNull ComponentActivity $this$waitActivityDestroy, @NotNull Function0<Unit> onDestroy) {
        Intrinsics.checkNotNullParameter((Object)$this$waitActivityDestroy, (String)"<this>");
        Intrinsics.checkNotNullParameter(onDestroy, (String)"onDestroy");
        $this$waitActivityDestroy.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver($this$waitActivityDestroy, onDestroy){
            final /* synthetic */ ComponentActivity $this_waitActivityDestroy;
            final /* synthetic */ Function0<Unit> $onDestroy;
            {
                this.$this_waitActivityDestroy = $receiver;
                this.$onDestroy = $onDestroy;
            }

            public void onDestroy(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super.onDestroy(owner);
                this.$this_waitActivityDestroy.getLifecycle().removeObserver((LifecycleObserver)this);
                this.$onDestroy.invoke();
            }
        });
    }

    public static final void onNextActionWhenResume(@NotNull Function0<Unit> nextAction) {
        block0: {
            Intrinsics.checkNotNullParameter(nextAction, (String)"nextAction");
            ComponentActivity componentActivity = UtilsKt.getComponentActivityOnTop(AdsSDK.INSTANCE);
            if (componentActivity == null) break block0;
            UtilsKt.waitActivityResumed(componentActivity, (Function0<Unit>)((Function0)new Function0<Unit>(nextAction){
                final /* synthetic */ Function0<Unit> $nextAction;
                {
                    this.$nextAction = $nextAction;
                    super(0);
                }

                public final void invoke() {
                    this.$nextAction.invoke();
                }
            }));
        }
    }

    public static final void adLogger(@NotNull AdType adType, @NotNull String adUnitId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)adType, (String)"adType");
        Intrinsics.checkNotNullParameter((Object)adUnitId, (String)"adUnitId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Timber.Forest.tag("AdsSDK.[" + adType + "]").i("[" + adUnitId + "] => " + message, new Object[0]);
    }

    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public static final String getNetwork() {
        Object object = AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release().getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return "-";
        }
        Network nw = network;
        NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(nw);
        if (networkCapabilities == null) {
            return "-";
        }
        NetworkCapabilities actNw = networkCapabilities;
        if (actNw.hasTransport(1)) {
            return "WIFI";
        }
        if (actNw.hasTransport(3)) {
            return "ETHERNET";
        }
        if (actNw.hasTransport(0)) {
            Object object2 = AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release().getSystemService("phone");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
            TelephonyManager tm = (TelephonyManager)object2;
            switch (tm.getDataNetworkType()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
                case 16: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 17: {
                    return "3G";
                }
                case 13: 
                case 18: 
                case 19: {
                    return "4G";
                }
                case 20: {
                    return "5G";
                }
            }
            return "_";
        }
        return "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String getStringAssetFile(@NotNull String path, @NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Object json = null;
        try {
            InputStream inputStream;
            InputStream inputStream2 = application.getAssets().open(path);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"open(...)");
            Closeable closeable = inputStream = inputStream2;
            Object object = Charsets.UTF_8;
            Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            object = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                object2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            json = object2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return json;
    }
}

