package com.admob.cmp

import android.annotation.SuppressLint
import android.app.Activity
import android.provider.Settings
import java.security.MessageDigest
import java.security.NoSuchAlgorithmException
import java.util.Locale

object Utils {
    fun getDeviceID(application: Activity): String {
        @SuppressLint("HardwareIds") val android_id =
            Settings.Secure.getString(application.contentResolver, Settings.Secure.ANDROID_ID)
        return md5(android_id).uppercase(Locale.getDefault())
    }

    fun md5(s: String): String {
        try {
            // Create MD5 Hash
            val digest = MessageDigest.getInstance("MD5")
            digest.update(s.toByteArray())
            val messageDigest = digest.digest()

            // Create Hex String
            val hexString = StringBuilder()
            for (i in messageDigest.indices) {
                val h = StringBuilder(Integer.toHexString(0xFF and messageDigest[i].toInt()))
                while (h.length < 2) h.insert(0, "0")
                hexString.append(h)
            }
            return hexString.toString()
        } catch (e: NoSuchAlgorithmException) {
            e.printStackTrace()
        }
        return ""
    }
}