package com.admob.tracking

// Helper class to build the map for event data

import android.os.Bundle

class EventParameterBuilder {
    private val dataMap = mutableMapOf<String, Any>()

    // Method to add key-value pairs to the map
    fun add(key: String, value: Any) = apply {
        dataMap[key] = value
    }

    // Build the final map
    fun build(): Map<String, Any> = dataMap

    // Convert dataMap to a Bundle
    fun toBundle(): Bundle {
        val bundle = Bundle()
        for ((key, value) in dataMap) {
            when (value) {
                is Int -> bundle.putInt(key, value)
                is String -> bundle.putString(key, value)
                is Boolean -> bundle.putBoolean(key, value)
                is Float -> bundle.putFloat(key, value)
                is Long -> bundle.putLong(key, value)
                is Double -> bundle.putDouble(key, value)
                is ArrayList<*> -> {
                    // Safe cast to specific types
                    when {
                        value.all { it is String } -> bundle.putStringArrayList(key, ArrayList(value.filterIsInstance<String>()))
                        value.all { it is Int } -> bundle.putIntegerArrayList(key, ArrayList(value.filterIsInstance<Int>()))
                        // Add more type checks for ArrayList if needed
                    }
                }
                is Bundle -> bundle.putBundle(key, value)
                // Add more type cases as needed
                else -> throw IllegalArgumentException("Unsupported data type for key: $key")
            }
        }
        return bundle
    }
}

