package com.admob

import android.os.Bundle
import com.google.android.libraries.ads.mobile.sdk.common.LoadAdError
import com.google.gson.annotations.SerializedName

/**
 * TAdCallback
 * This is a callback interface for Admob Ads
 */
interface SAdCallback {
    fun onAdStartLoading(adUnit: String, adType: AdType) {}
    fun onAdClicked(adUnit: String, adType: AdType) {}
    fun onAdClosed(adUnit: String, adType: AdType) {}
    fun onAdDismissedFullScreenContent(adUnit: String, adType: AdType) {}
    fun onAdShowedFullScreenContent(adUnit: String, adType: AdType) {}
    fun onAdFailedToShowFullScreenContent(error : String, adUnit: String, adType: AdType) {}
    fun onAdFailedToLoad(adUnit: String, adType: AdType, error: LoadAdError) {}
    fun onAdImpression(adUnit: String, adType: AdType) {}
    fun onAdLoaded(adUnit: String, adType: AdType) {}
    fun onAdOpened(adUnit: String, adType: AdType) {}
    fun onAdSwipeGestureClicked(adUnit: String, adType: AdType) {}
    fun onPaidValueListener(bundle : Bundle) {}
    fun onSetInterFloorId(){} /*When application resume, some device init all member variable, pls call set InterFloor.setId*/
    fun onDisable(){}
    fun onCollapsibleDismiss(){}
}

/**
 * AdType
 * This is an enum class for Admob Ads
 * support OpenApp, Inter, Banner, Native, Rewarded
 */
sealed class AdType(var name: String) {
    data object OpenApp : AdType("OpenApp")
    data object Inter : AdType("Inter")
    data object Banner : AdType("Banner")
    data object Native : AdType("Native")
    data object Rewarded : AdType("Rewarded")
}

/**
 * @ReplacedWith("AdsChild")
 * AdData
 * This is a data class for Admob Ads
 * support adUnitId, adType, adSpace
 */
data class AdData(
    val adUnitId: String,
    val adType: String,
    val adSpace: String,
)

/**
 * AdsChild tương ứng với Ads trong file json và chính là một space quảng cáo
 * This is a data class for Admob Ads
 * support spaceName, adsType, adsId, isEnable
 * @property spaceName
 * @property adsType
 * @property adsId
 * @property isEnable
 * @constructor Create empty AdsChild
 */
class AdsChild {
    @SerializedName("spaceName")
    var spaceName:String = "null"

    @SerializedName("adsType")
    var adsType:String = "null"

    @SerializedName("id")
    var adsId:String = "null"

    @SerializedName("isEnable")
    var isEnable : Boolean = true

    override fun toString(): String {
        return "AdsChild spaceName='$spaceName', adsType='$adsType', adsId='$adsId' , isEnable='$isEnable' )"
    }
}

class Ads {
    @SerializedName("listAds")
    var listAdsChild:ArrayList<AdsChild> = ArrayList()
    override fun toString(): String {
        return "Ads(listAdsChild=$listAdsChild)"
    }

}

fun AdsChild.isEnable() = true