package com.admob.ads.banner

import android.app.Activity
import android.os.Bundle
import android.view.ViewGroup
import com.admob.AdType
import com.admob.SAdCallback
import com.google.android.libraries.ads.mobile.sdk.common.LoadAdError

object AdmobBannerFloor {
    fun showAdaptive(
        activity: Activity,
        adUnitIdHigh: String,
        adUnitIdMedium: String,
        adUnitIdLow: String,
        adContainer: ViewGroup,
        forceRefresh: Boolean = false,
        callback: SAdCallback? = null
    ) {
        var currAdUnitId = adUnitIdHigh

        fun showAdaptiveBanner(adUnitId : String){
            showAdaptiveBanner(
                activity = activity,
                adUnitId = adUnitId,
                adContainer = adContainer,
                forceRefresh = forceRefresh,
                callback = callback,
                onLoadFailure = {
                    if (currAdUnitId == adUnitIdHigh) {
                        currAdUnitId = adUnitIdMedium
                    }

                    if (currAdUnitId == adUnitIdMedium) {
                        currAdUnitId = adUnitIdLow
                    }

                    showAdaptiveBanner(currAdUnitId)
                },
            )
        }

        showAdaptiveBanner(currAdUnitId)

    }

    private fun showAdaptiveBanner(
        activity: Activity,
        adUnitId: String,
        adContainer: ViewGroup,
        forceRefresh: Boolean = false,
        callback: SAdCallback? = null,
        onLoadFailure: () -> Unit,
    ) {
        AdmobBanner.showAnchoredAdaptive(
            activity,
            adContainer,
            adUnitId,
            forceRefresh,
            callback = object : SAdCallback {
                override fun onAdClicked(adUnit: String, adType: AdType) {
                    callback?.onAdClicked(adUnit, adType)
                }

                override fun onAdClosed(adUnit: String, adType: AdType) {
                    callback?.onAdClosed(adUnit, adType)
                }

                override fun onAdDismissedFullScreenContent(adUnit: String, adType: AdType) {
                    callback?.onAdDismissedFullScreenContent(adUnit, adType)
                }

                override fun onAdShowedFullScreenContent(adUnit: String, adType: AdType) {
                    callback?.onAdShowedFullScreenContent(adUnit, adType)
                }

                override fun onAdFailedToShowFullScreenContent(error : String, adUnit: String, adType: AdType) {
                    callback?.onAdFailedToShowFullScreenContent(error, adUnit, adType)
                }

                override fun onAdFailedToLoad(adUnit: String, adType: AdType, error: LoadAdError) {
                    callback?.onAdFailedToLoad(adUnit, adType, error)
                    onLoadFailure.invoke()
                }

                override fun onAdImpression(adUnit: String, adType: AdType) {
                    callback?.onAdImpression(adUnit, adType)
                }

                override fun onAdLoaded(adUnit: String, adType: AdType) {
                    callback?.onAdLoaded(adUnit, adType)
                }

                override fun onAdOpened(adUnit: String, adType: AdType) {
                    callback?.onAdOpened(adUnit, adType)
                }

                override fun onAdSwipeGestureClicked(adUnit: String, adType: AdType) {
                    callback?.onAdSwipeGestureClicked(adUnit, adType)
                }

                override fun onPaidValueListener(bundle: Bundle) {
                    callback?.onPaidValueListener(bundle)
                }
            }
        )
    }
}