/*
 * Decompiled with CFR 0.152.
 */
package com.admob.app_update;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import com.admob.ads.AdsSDK;
import com.google.android.gms.tasks.Task;
import com.google.android.play.core.appupdate.AppUpdateInfo;
import com.google.android.play.core.appupdate.AppUpdateManager;
import com.google.android.play.core.appupdate.AppUpdateManagerFactory;
import com.google.android.play.core.appupdate.AppUpdateOptions;
import com.google.android.play.core.install.InstallState;
import com.google.firebase.ktx.Firebase;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.ktx.RemoteConfigKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/admob/app_update/UpdateHelper;", "", "<init>", "()V", "TAG", "", "checkShowUpdate", "", "checkShowUpdateForResult", "activity", "Landroidx/activity/ComponentActivity;", "checkUpdateAfterShowAd", "nextAction", "Lkotlin/Function0;", "SoftGO Ads SDK_release"})
public final class UpdateHelper {
    @NotNull
    public static final UpdateHelper INSTANCE = new UpdateHelper();
    @NotNull
    private static final String TAG = "Update";

    private UpdateHelper() {
    }

    public final void checkShowUpdate() {
        FirebaseRemoteConfig remoteConfig = RemoteConfigKt.getRemoteConfig((Firebase)Firebase.INSTANCE);
        FirebaseRemoteConfigSettings configSettings = RemoteConfigKt.remoteConfigSettings(UpdateHelper::checkShowUpdate$lambda$0);
        remoteConfig.setConfigSettingsAsync(configSettings);
        remoteConfig.fetchAndActivate().addOnCompleteListener(arg_0 -> UpdateHelper.checkShowUpdate$lambda$6(remoteConfig, arg_0));
    }

    public final void checkShowUpdateForResult(@NotNull ComponentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        FirebaseRemoteConfig remoteConfig = RemoteConfigKt.getRemoteConfig((Firebase)Firebase.INSTANCE);
        FirebaseRemoteConfigSettings configSettings = RemoteConfigKt.remoteConfigSettings(UpdateHelper::checkShowUpdateForResult$lambda$7);
        remoteConfig.setConfigSettingsAsync(configSettings);
        remoteConfig.fetchAndActivate().addOnCompleteListener(arg_0 -> UpdateHelper.checkShowUpdateForResult$lambda$13(remoteConfig, activity, arg_0));
    }

    public final void checkUpdateAfterShowAd(@NotNull Function0<Unit> nextAction) {
        Intrinsics.checkNotNullParameter(nextAction, (String)"nextAction");
        nextAction.invoke();
        this.checkShowUpdate();
    }

    private static final Unit checkShowUpdate$lambda$0(FirebaseRemoteConfigSettings.Builder $this$remoteConfigSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$remoteConfigSettings, (String)"$this$remoteConfigSettings");
        $this$remoteConfigSettings.setMinimumFetchIntervalInSeconds(0L);
        return Unit.INSTANCE;
    }

    private static final void checkShowUpdate$lambda$6$lambda$3$lambda$2(InstallState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        switch (state.installStatus()) {
            case 6: {
                Timber.Forest.d("CANCELED", new Object[0]);
                break;
            }
            case 4: {
                Timber.Forest.d("INSTALLED", new Object[0]);
                break;
            }
            case 3: {
                Timber.Forest.d("INSTALLING", new Object[0]);
            }
        }
    }

    private static final Unit checkShowUpdate$lambda$6$lambda$3(AppUpdateManager $appUpdateManager, AppUpdateInfo appUpdateInfo) {
        if (appUpdateInfo.updateAvailability() == 2) {
            try {
                Activity activity = (Activity)CollectionsKt.lastOrNull((Iterable)AdsSDK.INSTANCE.getActivities());
                if (activity == null) {
                    return Unit.INSTANCE;
                }
                Activity activity2 = activity;
                $appUpdateManager.startUpdateFlow(appUpdateInfo, activity2, AppUpdateOptions.newBuilder((int)1).build());
                $appUpdateManager.registerListener(UpdateHelper::checkShowUpdate$lambda$6$lambda$3$lambda$2);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                // empty catch block
            }
        }
        return Unit.INSTANCE;
    }

    private static final void checkShowUpdate$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void checkShowUpdate$lambda$6$lambda$5(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Timber.Forest.d("checkShowUpdate: appUpdateInfoTask- fail " + it.getMessage(), new Object[0]);
    }

    private static final void checkShowUpdate$lambda$6(FirebaseRemoteConfig $remoteConfig, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isSuccessful()) {
            Object $i$a$-runCatching-UpdateHelper$checkShowUpdate$1$22;
            long versionRemote = $remoteConfig.getLong("version_force_update");
            int currentCode = 0;
            currentCode = 1000;
            Timber.Forest.d("checkShowUpdate: " + versionRemote, new Object[0]);
            try {
                boolean $i$a$-runCatching-UpdateHelper$checkShowUpdate$1$22 = false;
                PackageManager manager = AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release().getPackageManager();
                PackageInfo info = manager.getPackageInfo(AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release().getPackageName(), 1);
                currentCode = info.versionCode;
                $i$a$-runCatching-UpdateHelper$checkShowUpdate$1$22 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable manager) {
                $i$a$-runCatching-UpdateHelper$checkShowUpdate$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)manager));
            }
            if ((long)currentCode <= versionRemote) {
                Timber.Forest.d("checkShowUpdate: currentCode <= versionRemote", new Object[0]);
                AppUpdateManager appUpdateManager = AppUpdateManagerFactory.create((Context)((Context)AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release()));
                Intrinsics.checkNotNullExpressionValue((Object)appUpdateManager, (String)"create(...)");
                AppUpdateManager appUpdateManager2 = appUpdateManager;
                Task task2 = appUpdateManager2.getAppUpdateInfo();
                Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"getAppUpdateInfo(...)");
                Task appUpdateInfoTask = task2;
                appUpdateInfoTask.addOnSuccessListener(arg_0 -> UpdateHelper.checkShowUpdate$lambda$6$lambda$4(arg_0 -> UpdateHelper.checkShowUpdate$lambda$6$lambda$3(appUpdateManager2, arg_0), arg_0)).addOnFailureListener(UpdateHelper::checkShowUpdate$lambda$6$lambda$5);
            }
        }
    }

    private static final Unit checkShowUpdateForResult$lambda$7(FirebaseRemoteConfigSettings.Builder $this$remoteConfigSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$remoteConfigSettings, (String)"$this$remoteConfigSettings");
        $this$remoteConfigSettings.setMinimumFetchIntervalInSeconds(0L);
        return Unit.INSTANCE;
    }

    private static final void checkShowUpdateForResult$lambda$13$lambda$10$lambda$9(ActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result.getResultCode() == -1) {
            Timber.Forest.d("checkShowUpdateForResult: + result.resultCode == RESULT_OK ", new Object[0]);
        }
        if (result.getResultCode() == 0) {
            Timber.Forest.d("checkShowUpdateForResult: + result.resultCode == RESULT_CANCELED ", new Object[0]);
        }
        if (result.getResultCode() == 1) {
            Timber.Forest.d("checkShowUpdateForResult: + result.resultCode == RESULT_IN_APP_UPDATE_FAILED ", new Object[0]);
        }
    }

    private static final Unit checkShowUpdateForResult$lambda$13$lambda$10(ComponentActivity $activity, AppUpdateManager $appUpdateManager, AppUpdateInfo appUpdateInfo) {
        Timber.Forest.d("appUpdateInfo.updateAvailability(): " + appUpdateInfo.updateAvailability(), new Object[0]);
        if (appUpdateInfo.updateAvailability() == 2) {
            try {
                ActivityResultLauncher activityResultLauncher = $activity.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartIntentSenderForResult(), UpdateHelper::checkShowUpdateForResult$lambda$13$lambda$10$lambda$9);
                Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResult(...)");
                ActivityResultLauncher resultLauncher = activityResultLauncher;
                $appUpdateManager.startUpdateFlowForResult(appUpdateInfo, resultLauncher, AppUpdateOptions.newBuilder((int)1).build());
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                // empty catch block
            }
        }
        return Unit.INSTANCE;
    }

    private static final void checkShowUpdateForResult$lambda$13$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void checkShowUpdateForResult$lambda$13$lambda$12(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Timber.Forest.d("checkShowUpdate: appUpdateInfoTask- fail " + it.getMessage(), new Object[0]);
    }

    private static final void checkShowUpdateForResult$lambda$13(FirebaseRemoteConfig $remoteConfig, ComponentActivity $activity, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isSuccessful()) {
            Object $i$a$-runCatching-UpdateHelper$checkShowUpdateForResult$1$22;
            long versionRemote = $remoteConfig.getLong("version_force_update");
            int currentCode = 0;
            currentCode = 1000;
            Timber.Forest.d("checkShowUpdate: " + versionRemote, new Object[0]);
            try {
                boolean $i$a$-runCatching-UpdateHelper$checkShowUpdateForResult$1$22 = false;
                PackageManager manager = AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release().getPackageManager();
                PackageInfo info = manager.getPackageInfo(AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release().getPackageName(), 1);
                currentCode = info.versionCode;
                $i$a$-runCatching-UpdateHelper$checkShowUpdateForResult$1$22 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable manager) {
                $i$a$-runCatching-UpdateHelper$checkShowUpdateForResult$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)manager));
            }
            if ((long)currentCode <= versionRemote) {
                Timber.Forest.d("checkShowUpdate: currentCode <= versionRemote", new Object[0]);
                AppUpdateManager appUpdateManager = AppUpdateManagerFactory.create((Context)((Context)AdsSDK.INSTANCE.getApp$SoftGO_Ads_SDK_release()));
                Intrinsics.checkNotNullExpressionValue((Object)appUpdateManager, (String)"create(...)");
                AppUpdateManager appUpdateManager2 = appUpdateManager;
                Task task2 = appUpdateManager2.getAppUpdateInfo();
                Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"getAppUpdateInfo(...)");
                Task appUpdateInfoTask = task2;
                appUpdateInfoTask.addOnSuccessListener(arg_0 -> UpdateHelper.checkShowUpdateForResult$lambda$13$lambda$11(arg_0 -> UpdateHelper.checkShowUpdateForResult$lambda$13$lambda$10($activity, appUpdateManager2, arg_0), arg_0)).addOnFailureListener(UpdateHelper::checkShowUpdateForResult$lambda$13$lambda$12);
            }
        }
    }
}

