package io.pica.ads

import android.os.Bundle
import com.google.android.gms.ads.AdValue

interface AdCallback {

    fun onAdShow(network: String, adType: String)
    fun onAdClose(adType: String)
    fun onAdFailToLoad(messageError: String?)
    fun onAdFailToShow(message: String)
    fun onAdImpression(adType: String)
    fun onAdOff()
    fun onAdClick(){}
    fun onPaidEvent(params: Bundle, adValue:AdValue) {}
    fun onRewardShow(network: String, adType: String) {}

}