package io.pica.ads.model2

import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
import io.pica.ads.utils.AdDef

@Keep
data class AdsChild(
    @SerializedName("adsIds")
    var adsIds: MutableList<AdsId> = mutableListOf(),
    @SerializedName("adsType")
    var adsType: String = "null", // interstitial
    @SerializedName("spaceName")
    var spaceName: String = "null",
    @SerializedName("status")
    var status: Boolean = true,
    var adsSize: String = AdDef.GOOGLE_AD_BANNER.MEDIUM_RECTANGLE_300x250,
    var currentIndexAds: Int = 1
) {

    override fun toString(): String {
        return "AdsChild(adsIds=$adsIds, adsType='$adsType', spaceName='$spaceName', status=$status, adsSize='$adsSize', currentIndexAds=$currentIndexAds)"
    }
}