package io.pica.ads.utils

import com.adjust.sdk.Adjust
import com.adjust.sdk.AdjustAdRevenue
import com.adjust.sdk.AdjustConfig
import com.google.android.gms.ads.AdValue


object AdjustUtils {

    var enableAdjust: Boolean = false
    var eventNamePurchase: String = ""

    fun enableAdjustApply(enable: Boolean) {
        enableAdjust = enable
    }

    fun setCustomEventNamePurchase(eventName: String) {
        eventNamePurchase = eventName
    }

    /**
     * pushTrackEventAdmob push event to adjust when user purchased
     * @param adValue ad value
     */
    fun pushTrackEventAdmob(adValue: AdValue) {

        if (enableAdjust) {
            val adRevenue = AdjustAdRevenue(AdjustConfig.AD_REVENUE_ADMOB)
            adRevenue.setRevenue(adValue.valueMicros / 1000000.0, adValue.currencyCode)
            // Push ad revenue event to adjust
            Adjust.trackAdRevenue(adRevenue)
        }
    }


}