package io.pica.cmp

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.View
import android.view.animation.LinearInterpolator
import android.view.animation.RotateAnimation
import android.widget.ImageView
import android.widget.TextView
import io.pica.ads.R

class DialogLoadingForm(
    private val context: Context,
    private val title: String?,
    private val des: String?
) : Dialog(context) {


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.dialog_loading_form)
        setCancelable(false)
        setCanceledOnTouchOutside(false)

        val viewRotate = findViewById<ImageView>(R.id.imvLoading)
        findViewById<TextView>(R.id.tvTitle)?.text = title
        findViewById<TextView>(R.id.tvContent)?.text = des
        animRotation(viewRotate)
    }

    override fun show() {
        super.show()
        window?.setLayout(-1, -2)
        window?.setBackgroundDrawableResource(android.R.color.transparent)
    }

    private fun animRotation(view: View) {
        val rotateAnimation = RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f)
        rotateAnimation.interpolator = LinearInterpolator()
        rotateAnimation.duration = 1500
        rotateAnimation.isFillEnabled = true
        rotateAnimation.repeatCount = -1
        rotateAnimation.fillAfter = true
        view.startAnimation(rotateAnimation)
    }
}