package io.pica.cmp

import android.annotation.SuppressLint
import android.app.Activity
import android.provider.Settings
import java.security.MessageDigest

object Utils {

    @SuppressLint("HardwareIds")
    fun getDeviceID(activity: Activity): String {
        return md5(Settings.Secure.getString(activity.contentResolver, Settings.Secure.ANDROID_ID)).uppercase()
    }

    private fun md5(string: String): String {
        return try {
            val messageDigest = MessageDigest.getInstance("MD5")
            messageDigest.update(string.toByte())
            val digest = messageDigest.digest()
            val stringBuffer = StringBuffer()
            for (b in digest) {
                var hexString = Integer.toHexString(b.toInt() and 255)
                while (hexString.length < 2) {
                    hexString = "0$hexString"
                }
                stringBuffer.append(hexString)
            }
            stringBuffer.toString()
        }catch (e: Exception){
            ""
        }
    }

}

