/*
 * @Author: MCC<maichanchinhls@gmail.com>
 * @Date: 9/24/24, 12:44 AM
 * @Accounts
 *      -> https://github.com/maichanchinh
 *      -> https://stackoverflow.com/users/1851616/mai-chan-chinh
 *
 */

package io.pica.ads.config

data class ByteBrewConfig(
    val isEnableByteBrew: Boolean = false,
    val byteBrewAppId: String,
    val byteBrewAppKey: String
){
    class ByteBrewConfigBuilder{
        private var isEnableByteBrew: Boolean = false
        private var byteBrewAppId: String = ""
        private var byteBrewAppKey: String = ""

        fun isEnableByteBrew(isEnableByteBrew: Boolean) = apply { this.isEnableByteBrew = isEnableByteBrew }
        fun byteBrewAppId(byteBrewAppId: String) = apply { this.byteBrewAppId = byteBrewAppId }
        fun byteBrewAppKey(byteBrewAppKey: String) = apply { this.byteBrewAppKey = byteBrewAppKey }

        fun build() = ByteBrewConfig(isEnableByteBrew, byteBrewAppId, byteBrewAppKey)
    }
}
