package io.pica.ads.model2


import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
import io.pica.ads.utils.AdDef

@Keep
data class Ads(
    @SerializedName("appId")
    var appId: String = "",
    @SerializedName("listAds")
    var listAds: MutableList<AdsChild> = mutableListOf(),
    @SerializedName("network")
    var network: String = AdDef.NETWORK.GOOGLE, // google
    @SerializedName("packetName")
    var packetName: String = "",
){

    override fun toString(): String {
        return "Ads(appId='$appId', listAds=$listAds, network='$network', packetName='$packetName')"
    }
}