package io.pica.ads.utils

import android.content.Context
import android.util.DisplayMetrics
import android.util.Log
import android.view.Gravity
import android.widget.Toast
import java.io.File
import java.io.IOException
import java.io.InputStream

object Utils {
    fun showToastDebug(context: Context?, text: String) {
        if (Constant.isDebug) {
            Log.d("Utils", "showToastDebug: $text")
        }
        if (context != null && Constant.isShowToastDebug) {
            Toast.makeText(context, "Utils: \n$text", Toast.LENGTH_LONG)
                .apply {
                    setGravity(Gravity.TOP, 0, 100)
                }
                .show()
        }
    }

    //    fun showToastDebug(application: Application?, text:String){
//        if(application != null && Constant.isShowToastDebug) {
//            Toast.makeText(application, text, Toast.LENGTH_LONG).show()
//        }
//    }
    fun getStringAssetFile(path: String, context: Context): String {
        return try {
            val inputStream: InputStream = context.assets.open(path)
            inputStream.bufferedReader().use { it.readText() }
        } catch (ex: Exception) {
            ex.printStackTrace()
            return ""
        }
    }

    fun convertDpToPixel(dp: Float, context: Context): Float {
        return dp * (context.resources
            .displayMetrics.densityDpi.toFloat() / DisplayMetrics.DENSITY_DEFAULT)
    }

    @Throws(IOException::class)
    fun getFileFromAssets(context: Context, fileName: String): File =
        File(context.cacheDir, fileName)
            .also {
                if (!it.exists()) {
                    it.outputStream().use { cache ->
                        context.assets.open(fileName).use { inputStream ->
                            inputStream.copyTo(cache)
                        }
                    }
                }
            }

    fun convertPixelsToDp(px: Float, context: Context): Float {
        return px / (context.resources
            .displayMetrics.densityDpi.toFloat() / DisplayMetrics.DENSITY_DEFAULT)
    }

}
