/*
 * Decompiled with CFR 0.152.
 */
package com.bytebrew.bytebrewlibrary;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.bytebrew.bytebrewlibrary.ByteBrewAdType;
import com.bytebrew.bytebrewlibrary.ByteBrewHandler;
import com.bytebrew.bytebrewlibrary.ByteBrewListener;
import com.bytebrew.bytebrewlibrary.ByteBrewProgressionType;
import com.bytebrew.bytebrewlibrary.ByteBrewPurchaseResult;
import com.bytebrew.bytebrewlibrary.ByteBrewPurchaseValidationResult;
import com.bytebrew.bytebrewlibrary.ByteBrewPushNotifications;
import com.bytebrew.bytebrewlibrary.ByteBrewRemoteConfigResponse;
import com.bytebrew.bytebrewlibrary.PurchaseResponseListener;
import com.bytebrew.bytebrewlibrary.RemoteConfigListener;
import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class ByteBrew {
    private static boolean isInitialized = false;

    protected static void SetSDKInitialized() {
        isInitialized = true;
        ByteBrewPushNotifications.ByteBrewSDKInitialized();
    }

    public static void InitializeByteBrew(String appID, String appKey, String engineVersion, Context context) {
        if (isInitialized) {
            return;
        }
        ByteBrewListener.CreateListeners((Application)context.getApplicationContext());
        ByteBrewHandler.getInstance().InitializeByteBrew(appID, appKey, engineVersion, context);
    }

    public static boolean IsByteBrewInitialized() {
        return isInitialized;
    }

    public static void StartPushNotifications(Context context) {
        if (!ByteBrewHandler.getInstance().initializationCalled) {
            Log.d((String)"ByteBrew Message", (String)"You must call the ByteBrew Initialization first.");
        }
        ByteBrewPushNotifications.StartByteBrewPushNotifications(context);
    }

    public static void SetCustomData(String key, String value) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            event.put("key", (Object)key);
            event.put("value", (Object)value);
            event.put("type", (Object)"string");
            ByteBrewHandler.getInstance().SendCustomDataAttribution(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void SetCustomData(String key, double value) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            event.put("key", (Object)key);
            event.put("value", (Object)Double.toString(value));
            event.put("type", (Object)"double");
            ByteBrewHandler.getInstance().SendCustomDataAttribution(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void SetCustomData(String key, int value) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            event.put("key", (Object)key);
            event.put("value", (Object)Integer.toString(value));
            event.put("type", (Object)"integer");
            ByteBrewHandler.getInstance().SendCustomDataAttribution(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void SetCustomData(String key, boolean value) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            event.put("key", (Object)key);
            event.put("value", (Object)Boolean.toString(value));
            event.put("type", (Object)"boolean");
            ByteBrewHandler.getInstance().SendCustomDataAttribution(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void NewCustomEvent(String eventName) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            event.put("category", (Object)"custom");
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)eventName);
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void NewCustomEvent(String eventName, String value) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)eventName);
            externalData.put("value", (Object)value);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void NewCustomEvent(String eventName, float value) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)eventName);
            externalData.put("value", (Object)Float.toString(value));
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void NewProgressionEvent(ByteBrewProgressionType progressionStatus, String environment, String stage) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("progressionStatus", (Object)progressionStatus.GetName());
            externalData.put("progressionEnvironment", (Object)environment);
            externalData.put("progressionStage", (Object)stage);
            event.put("category", (Object)"progression");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void NewProgressionEvent(ByteBrewProgressionType progressionStatus, String environment, String stage, String value) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("progressionStatus", (Object)progressionStatus.GetName());
            externalData.put("progressionEnvironment", (Object)environment);
            externalData.put("progressionStage", (Object)stage);
            externalData.put("progressionValue", (Object)value);
            event.put("category", (Object)"progression");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void NewProgressionEvent(ByteBrewProgressionType progressionStatus, String environment, String stage, float value) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("progressionStatus", (Object)progressionStatus.GetName());
            externalData.put("progressionEnvironment", (Object)environment);
            externalData.put("progressionStage", (Object)stage);
            externalData.put("progressionValue", (Object)Float.toString(value));
            event.put("category", (Object)"progression");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void TrackAdEvent(ByteBrewAdType adType, String adLocation) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"adEvent");
            externalData.put("placementType", (Object)adType.GetName());
            externalData.put("adLocation", (Object)adLocation);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void TrackAdEvent(ByteBrewAdType adType, String adLocation, String AdID) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"adEvent");
            externalData.put("placementType", (Object)adType.GetName());
            externalData.put("adLocation", (Object)adLocation);
            externalData.put("ADID", (Object)AdID);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void TrackAdEvent(ByteBrewAdType adType, String adLocation, String AdID, String adProvider) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"adEvent");
            externalData.put("placementType", (Object)adType.GetName());
            externalData.put("adLocation", (Object)adLocation);
            externalData.put("ADID", (Object)AdID);
            externalData.put("adProvider", (Object)adProvider);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void TrackAdEvent(ByteBrewAdType adType, String adProvider, String adUnitName, double revenue) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"adEvent");
            externalData.put("placementType", (Object)adType.GetName());
            externalData.put("adProvider", (Object)adProvider);
            externalData.put("adUnitName", (Object)adUnitName);
            DecimalFormat df = new DecimalFormat("#");
            df.setMaximumFractionDigits(20);
            externalData.put("revenue", (Object)df.format(revenue));
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void TrackAdEvent(ByteBrewAdType adType, String adProvider, String adUnitName, String adLocation, double revenue) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"adEvent");
            externalData.put("placementType", (Object)adType.GetName());
            externalData.put("adProvider", (Object)adProvider);
            externalData.put("adUnitName", (Object)adUnitName);
            externalData.put("adLocation", (Object)adLocation);
            DecimalFormat df = new DecimalFormat("#");
            df.setMaximumFractionDigits(20);
            externalData.put("revenue", (Object)df.format(revenue));
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    @Deprecated
    public static void TrackAdEvent(String placementType, String adLocation) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"adEvent");
            externalData.put("placementType", (Object)placementType);
            externalData.put("adLocation", (Object)adLocation);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    @Deprecated
    public static void TrackAdEvent(String placementType, String adLocation, String AdID) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"adEvent");
            externalData.put("placementType", (Object)placementType);
            externalData.put("adLocation", (Object)adLocation);
            externalData.put("ADID", (Object)AdID);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    @Deprecated
    public static void TrackAdEvent(String placementType, String adLocation, String AdID, String adProvider) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"adEvent");
            externalData.put("placementType", (Object)placementType);
            externalData.put("adLocation", (Object)adLocation);
            externalData.put("ADID", (Object)AdID);
            externalData.put("adProvider", (Object)adProvider);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void TrackInAppPurchaseEvent(String store, String currency, float amount, String itemID, String category) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"IAPEvent");
            externalData.put("store", (Object)store);
            externalData.put("currency", (Object)currency);
            externalData.put("amount", (Object)Float.toString(amount));
            externalData.put("itemID", (Object)itemID);
            externalData.put("category", (Object)category);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void TrackGoogleInAppPurchaseEvent(String store, String currency, float amount, String itemID, String category, String receipt, String signature) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"IAPEvent");
            externalData.put("store", (Object)store);
            externalData.put("currency", (Object)currency);
            externalData.put("amount", (Object)Float.toString(amount));
            externalData.put("itemID", (Object)itemID);
            externalData.put("category", (Object)category);
            externalData.put("receipt", (Object)receipt);
            externalData.put("signature", (Object)signature);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().CreateCustomEvent(event.toString());
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void ValidateGoogleInAppPurchaseEvent(String store, String currency, float amount, String itemID, String category, String receipt, String signature, final PurchaseResponseListener listener) {
        if (!isInitialized) {
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"IAPEvent");
            externalData.put("store", (Object)store);
            externalData.put("currency", (Object)currency);
            externalData.put("amount", (Object)Float.toString(amount));
            externalData.put("itemID", (Object)itemID);
            externalData.put("category", (Object)category);
            externalData.put("receipt", (Object)receipt);
            externalData.put("signature", (Object)signature);
            event.put("category", (Object)"custom");
            event.put("externalData", (Object)externalData);
            ByteBrewHandler.getInstance().ValidateIAPEvent(event.toString(), new ByteBrewPurchaseValidationResult(){

                @Override
                public void purchaseValidated(ByteBrewPurchaseResult result) {
                    listener.purchaseValidated(result);
                }
            });
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
        }
    }

    public static void LoadRemoteConfigs(final RemoteConfigListener configListener) {
        ByteBrewHandler.getInstance().LoadRemoteConfigurations(new ByteBrewRemoteConfigResponse(){

            @Override
            public void loadedConfigs(boolean status) {
                configListener.RetrievedConfigs(status);
            }
        });
    }

    public static boolean HasRemoteConfigsBeenSet() {
        return ByteBrewHandler.getInstance().IsRemoteConfigsSet();
    }

    public static String RetrieveRemoteConfigValue(String key, String defaultValue) {
        return ByteBrewHandler.getInstance().GetRemoteConfigForKey(key, defaultValue);
    }

    public static void RestartTracking(Context context) {
        ByteBrewHandler.getInstance().StartTracking(context);
    }

    public static void StopTracking(Context context) {
        ByteBrewHandler.getInstance().StopTracking(context);
    }

    public static String GetUserID() {
        if (!isInitialized) {
            return null;
        }
        return ByteBrewHandler.userID;
    }
}

