/*
 * Decompiled with CFR 0.152.
 */
package com.bytebrew.bytebrewlibrary;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bytebrew.bytebrewlibrary.ByteBrewPushNotifications;
import com.bytebrew.bytebrewlibrary.BytePushConfigs;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.FirebaseMessaging;
import org.json.JSONObject;

public class ByteBrewFCMInitializer {
    FirebaseApp firebaseApp;

    public void StartFCM(Context context, JSONObject config) {
        try {
            Log.d((String)"ByteBrew FCM", (String)"starting fcm initialization");
            String applicationID = config.getString("app-id");
            String apiKey = config.getString("api-key");
            String senderID = config.getString("sender-id");
            String projectID = config.getString("project-id");
            try {
                FirebaseApp.getInstance();
                Log.d((String)"ByteBrew FCM Init", (String)"Is Already Initialized");
                this.GetToken();
            }
            catch (Exception e) {
                Log.d((String)"ByteBrew FCM Init", (String)"Not Already Initialized");
                this.firebaseApp = FirebaseApp.initializeApp((Context)context, (FirebaseOptions)new FirebaseOptions.Builder().setApplicationId(applicationID).setApiKey(apiKey).setGcmSenderId(senderID).setProjectId(projectID).build());
                this.GetToken();
            }
        }
        catch (Exception e) {
            Log.d((String)"ByteBrew FCM Exception", (String)e.getMessage());
        }
    }

    public void GetToken() {
        try {
            FirebaseApp.getInstance();
            Log.d((String)"ByteBrew FCM Init", (String)"Is Initialized");
        }
        catch (Exception e) {
            Log.d((String)"ByteBrew FCM Init", (String)"Not Initialized");
            return;
        }
        Log.d((String)"ByteBrew FCM", (String)"Getting Push Token");
        FirebaseMessaging messaging = (FirebaseMessaging)FirebaseApp.getInstance().get(FirebaseMessaging.class);
        messaging.getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

            public void onComplete(@NonNull Task<String> task) {
                if (!task.isSuccessful()) {
                    Log.d((String)"ByteBrew", (String)"Fetching FCM registration token failed", (Throwable)task.getException());
                    return;
                }
                String token = (String)task.getResult();
                BytePushConfigs.getInstance().SetPushToken(token);
                ByteBrewPushNotifications.SetPushTokenSetup();
            }
        });
    }
}

