/*
 * Decompiled with CFR 0.152.
 */
package com.bytebrew.bytebrewlibrary;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.bytebrew.bytebrewlibrary.ByteBrewHTTPManager;
import com.bytebrew.bytebrewlibrary.ByteBrewHTTPRetrievalResponse;
import com.bytebrew.bytebrewlibrary.ByteBrewInitializer;
import com.bytebrew.bytebrewlibrary.ByteBrewPurchaseResult;
import com.bytebrew.bytebrewlibrary.ByteBrewPurchaseValidationResult;
import com.bytebrew.bytebrewlibrary.ByteBrewReferrerRetriever;
import com.bytebrew.bytebrewlibrary.ByteBrewReferrerStatusListener;
import com.bytebrew.bytebrewlibrary.ByteBrewRemoteConfigResponse;
import com.bytebrew.bytebrewlibrary.ByteBrewUtils;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

class ByteBrewHandler
extends Activity {
    public static ByteBrewHandler _instance = null;
    private static Context currentContext = null;
    private static String androidDeviceID;
    private static String androidBuildID;
    private static String engineVersion;
    private static String buildVersion;
    private static String googleADID;
    private static String GEOCode;
    private static String packageName;
    private static String deviceModel;
    private static String deviceMaker;
    private static String deviceCarrier;
    private static String deviceCarrierCodes;
    private static String screenSize;
    private static String osVersion;
    private static String deviceName;
    private static String phoneCapacity;
    private static final String PLATFORM = "Android";
    protected static String gameID;
    protected static String DEVKEY;
    protected static String userID;
    protected static String sessionID;
    protected static String sessionKey;
    private static boolean trackingEnabled;
    private static String language;
    private static String deviceTimeZone;
    private static Date _startTime;
    private static JSONObject remoteConfigurations;
    private static boolean isCurrentUser;
    private static String bb_sdk_version;
    private static ByteBrewUtils byteBrewUtils;
    private static final ExecutorService executorService;
    protected boolean initializationCalled = false;

    public ByteBrewHandler() {
        byteBrewUtils = new ByteBrewUtils();
    }

    public static ByteBrewHandler getInstance() {
        if (_instance == null) {
            _instance = new ByteBrewHandler();
        }
        return _instance;
    }

    public void InitializeByteBrew(String gameId, String gameKey, String engineV, Context context) {
        Log.i((String)"ByteBrew Message", (String)"Starting Initialization");
        if (gameId.length() == 0) {
            throw new IllegalArgumentException("App ID must contain a string");
        }
        if (gameKey.length() == 0) {
            throw new IllegalArgumentException("App Key must contain a string");
        }
        if (engineV.length() == 0) {
            throw new IllegalArgumentException("Engine Version must contain a string");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        currentContext = context;
        isCurrentUser = byteBrewUtils.isCurrentUser(context);
        trackingEnabled = byteBrewUtils.isTrackingEnabled(currentContext);
        if (!trackingEnabled) {
            return;
        }
        engineVersion = engineV;
        buildVersion = byteBrewUtils.GetAppVersion(context);
        androidDeviceID = byteBrewUtils.GetAndroidDeviceID(context);
        androidBuildID = byteBrewUtils.GetDeviceBuildID();
        GEOCode = byteBrewUtils.getCountryCode(context).toUpperCase();
        deviceName = byteBrewUtils.GetDeviceName(context);
        deviceMaker = byteBrewUtils.GetDeviceMaker();
        screenSize = byteBrewUtils.GeScreenSize(context);
        phoneCapacity = byteBrewUtils.GetStorageCapacity();
        deviceCarrier = byteBrewUtils.GetDeviceCarrier(context);
        deviceCarrierCodes = byteBrewUtils.GetDeviceCarrierCodes(context);
        gameID = gameId;
        DEVKEY = gameKey;
        packageName = context.getPackageName();
        language = byteBrewUtils.GetLanguageSettings();
        deviceTimeZone = byteBrewUtils.GetDeviceTimeZone();
        osVersion = Build.VERSION.RELEASE;
        deviceModel = byteBrewUtils.GetDeviceModel();
        _startTime = new Date();
        sessionID = byteBrewUtils.CreateSessionID();
        sessionKey = "";
        if (isCurrentUser) {
            userID = byteBrewUtils.GetUserID(context);
            this.CreateUserEvent();
        } else {
            userID = byteBrewUtils.SetUserID(context);
            this.CreateNewUser();
        }
        byteBrewUtils.SetAppConfig(gameId, gameKey, currentContext);
        this.initializationCalled = true;
    }

    public void SetAdID(String adID) {
        googleADID = adID;
    }

    private void CreateNewUser() {
        if (!trackingEnabled) {
            return;
        }
        final JSONObject logEvent = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"new_user");
            externalData.put("deviceID", (Object)androidDeviceID);
            externalData.put("buildID", (Object)androidBuildID);
            externalData.put("userLocale", (Object)language);
            externalData.put("userTimeZone", (Object)deviceTimeZone);
            logEvent.put("user_adid", (Object)googleADID);
            logEvent.put("game_id", (Object)gameID);
            logEvent.put("sdk_version", (Object)bb_sdk_version);
            logEvent.put("geo", (Object)GEOCode);
            logEvent.put("engine_version", (Object)engineVersion);
            logEvent.put("version_number", (Object)buildVersion);
            logEvent.put("bundle_id", (Object)packageName);
            logEvent.put("deviceCarrier", (Object)deviceCarrier);
            logEvent.put("carrierCodes", (Object)deviceCarrierCodes);
            logEvent.put("deviceScreenSize", (Object)screenSize);
            logEvent.put("deviceCapacity", (Object)phoneCapacity);
            logEvent.put("device_maker", (Object)deviceMaker);
            logEvent.put("device_name", (Object)deviceName);
            logEvent.put("device", (Object)deviceModel);
            logEvent.put("os_version", (Object)osVersion);
            logEvent.put("platform", (Object)PLATFORM);
            logEvent.put("category", (Object)"user");
            logEvent.put("user_id", (Object)userID);
            logEvent.put("session_id", (Object)sessionID);
            logEvent.put("externalData", (Object)externalData);
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
            return;
        }
        try {
            Log.i((String)"ByteBrew", (String)"Creating New User Event");
            final ByteBrewReferrerRetriever referrerRetriever = new ByteBrewReferrerRetriever(currentContext);
            referrerRetriever.RetrieveReferrer(new ByteBrewReferrerStatusListener(){

                @Override
                public void OnFinished() {
                    if (logEvent.optJSONObject("externalData") != null && referrerRetriever.GetRefererPackage() != null) {
                        try {
                            logEvent.getJSONObject("externalData").put("referrerPayload", (Object)referrerRetriever.GetRefererPackage().toString());
                        }
                        catch (Exception jsonException) {
                            Log.i((String)"ByteBrew Exception", (String)jsonException.getMessage());
                        }
                    }
                    new ByteBrewInitializer(executorService, gameID, DEVKEY).InitializeUser(logEvent, currentContext);
                }
            });
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("Create New User: " + e.getMessage()));
        }
    }

    protected static void UserResumed() {
        if (!trackingEnabled) {
            return;
        }
        _startTime = new Date();
        JSONObject logEvent = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"game_open");
            externalData.put("userLocale", (Object)language);
            externalData.put("userTimeZone", (Object)deviceTimeZone);
            externalData.put("buildID", (Object)androidBuildID);
            logEvent.put("user_adid", (Object)googleADID);
            logEvent.put("game_id", (Object)gameID);
            logEvent.put("sdk_version", (Object)bb_sdk_version);
            logEvent.put("geo", (Object)GEOCode);
            logEvent.put("engine_version", (Object)engineVersion);
            logEvent.put("version_number", (Object)buildVersion);
            logEvent.put("bundle_id", (Object)packageName);
            logEvent.put("deviceCarrier", (Object)deviceCarrier);
            logEvent.put("carrierCodes", (Object)deviceCarrierCodes);
            logEvent.put("deviceScreenSize", (Object)screenSize);
            logEvent.put("deviceCapacity", (Object)phoneCapacity);
            logEvent.put("device_maker", (Object)deviceMaker);
            logEvent.put("device_name", (Object)deviceName);
            logEvent.put("device", (Object)deviceModel);
            logEvent.put("os_version", (Object)osVersion);
            logEvent.put("platform", (Object)PLATFORM);
            logEvent.put("category", (Object)"user");
            logEvent.put("user_id", (Object)userID);
            logEvent.put("session_id", (Object)sessionID);
            logEvent.put("externalData", (Object)externalData);
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
            return;
        }
        try {
            Log.i((String)"ByteBrew", (String)"Creating User Event");
            new ByteBrewInitializer(executorService, gameID, DEVKEY).InitializeUser(logEvent, currentContext);
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("Create User Resume: " + e.getMessage()));
        }
    }

    public void LoadRemoteConfigurations(final ByteBrewRemoteConfigResponse retrieval) {
        try {
            Log.i((String)"ByteBrew", (String)"Getting remote configurations.");
            new ByteBrewHTTPManager(executorService, gameID, DEVKEY).GetData(new ByteBrewHTTPRetrievalResponse(){

                @Override
                public void retrievedConfigs(boolean status) {
                    Log.i((String)"ByteBrew", (String)"Remote Configs Responded");
                    retrieval.loadedConfigs(status);
                }
            });
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("LoadRemoteConfigurations: " + e.getMessage()));
        }
    }

    private void CreateUserEvent() {
        if (!trackingEnabled) {
            return;
        }
        JSONObject logEvent = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("eventType", (Object)"game_open");
            externalData.put("userLocale", (Object)language);
            externalData.put("userTimeZone", (Object)deviceTimeZone);
            externalData.put("buildID", (Object)androidBuildID);
            logEvent.put("user_adid", (Object)googleADID);
            logEvent.put("game_id", (Object)gameID);
            logEvent.put("sdk_version", (Object)bb_sdk_version);
            logEvent.put("geo", (Object)GEOCode);
            logEvent.put("engine_version", (Object)engineVersion);
            logEvent.put("version_number", (Object)buildVersion);
            logEvent.put("bundle_id", (Object)packageName);
            logEvent.put("deviceCarrier", (Object)deviceCarrier);
            logEvent.put("carrierCodes", (Object)deviceCarrierCodes);
            logEvent.put("deviceScreenSize", (Object)screenSize);
            logEvent.put("deviceCapacity", (Object)phoneCapacity);
            logEvent.put("device_maker", (Object)deviceMaker);
            logEvent.put("device_name", (Object)deviceName);
            logEvent.put("device", (Object)deviceModel);
            logEvent.put("os_version", (Object)osVersion);
            logEvent.put("platform", (Object)PLATFORM);
            logEvent.put("category", (Object)"user");
            logEvent.put("user_id", (Object)userID);
            logEvent.put("session_id", (Object)sessionID);
            logEvent.put("externalData", (Object)externalData);
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
            return;
        }
        try {
            Log.i((String)"ByteBrew", (String)"Creating User Event");
            new ByteBrewInitializer(executorService, gameID, DEVKEY).InitializeUser(logEvent, currentContext);
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("Create User Event: " + e.getMessage()));
        }
    }

    public static void CreateSessionEndEvent() {
        if (!trackingEnabled) {
            return;
        }
        Date endTime = new Date();
        int secondsPlayed = (int)((endTime.getTime() - _startTime.getTime()) / 1000L);
        JSONObject logEvent = new JSONObject();
        try {
            JSONObject externalData = new JSONObject();
            externalData.put("sessionLength", (Object)("" + secondsPlayed));
            logEvent.put("user_adid", (Object)googleADID);
            logEvent.put("game_id", (Object)gameID);
            logEvent.put("sdk_version", (Object)bb_sdk_version);
            logEvent.put("geo", (Object)GEOCode);
            logEvent.put("engine_version", (Object)engineVersion);
            logEvent.put("version_number", (Object)buildVersion);
            logEvent.put("bundle_id", (Object)packageName);
            logEvent.put("deviceCarrier", (Object)deviceCarrier);
            logEvent.put("carrierCodes", (Object)deviceCarrierCodes);
            logEvent.put("deviceScreenSize", (Object)screenSize);
            logEvent.put("deviceCapacity", (Object)phoneCapacity);
            logEvent.put("device_maker", (Object)deviceMaker);
            logEvent.put("device_name", (Object)deviceName);
            logEvent.put("device", (Object)deviceModel);
            logEvent.put("os_version", (Object)osVersion);
            logEvent.put("platform", (Object)PLATFORM);
            logEvent.put("category", (Object)"game_close");
            logEvent.put("user_id", (Object)userID);
            logEvent.put("session_id", (Object)sessionID);
            logEvent.put("session_key", (Object)sessionKey);
            logEvent.put("externalData", (Object)externalData);
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
            return;
        }
        try {
            Log.i((String)"ByteBrew: ", (String)"Creating Session End Event");
            new ByteBrewHTTPManager(executorService, gameID, DEVKEY).Send(logEvent);
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("CreateNewUser: " + e.getMessage()));
        }
    }

    public void SendCustomDataAttribution(String items) {
        if (!trackingEnabled) {
            return;
        }
        JSONObject logEvent = null;
        try {
            logEvent = new JSONObject(items);
            logEvent.put("game_id", (Object)gameID);
            logEvent.put("bundle_id", (Object)packageName);
            logEvent.put("platform", (Object)PLATFORM);
            logEvent.put("user_id", (Object)userID);
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
            return;
        }
        try {
            Log.i((String)"ByteBrew: ", (String)"Creating Custom Data update");
            new ByteBrewHTTPManager(executorService, gameID, DEVKEY).Send(logEvent, true);
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("CustomDataUpdate: " + e.getMessage()));
        }
    }

    public void CreateCustomEvent(String items) {
        if (!trackingEnabled) {
            return;
        }
        JSONObject logEvent = null;
        try {
            logEvent = new JSONObject(items);
            logEvent.getJSONObject("externalData").put("buildID", (Object)androidBuildID);
            logEvent.getJSONObject("externalData").put("userLocale", (Object)language);
            logEvent.getJSONObject("externalData").put("userTimeZone", (Object)deviceTimeZone);
            logEvent.put("user_adid", (Object)googleADID);
            logEvent.put("game_id", (Object)gameID);
            logEvent.put("sdk_version", (Object)bb_sdk_version);
            logEvent.put("geo", (Object)GEOCode);
            logEvent.put("engine_version", (Object)engineVersion);
            logEvent.put("version_number", (Object)buildVersion);
            logEvent.put("bundle_id", (Object)packageName);
            logEvent.put("deviceCarrier", (Object)deviceCarrier);
            logEvent.put("carrierCodes", (Object)deviceCarrierCodes);
            logEvent.put("deviceScreenSize", (Object)screenSize);
            logEvent.put("deviceCapacity", (Object)phoneCapacity);
            logEvent.put("device_maker", (Object)deviceMaker);
            logEvent.put("device_name", (Object)deviceName);
            logEvent.put("device", (Object)deviceModel);
            logEvent.put("os_version", (Object)osVersion);
            logEvent.put("platform", (Object)PLATFORM);
            logEvent.put("user_id", (Object)userID);
            logEvent.put("session_id", (Object)sessionID);
            logEvent.put("session_key", (Object)sessionKey);
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
            return;
        }
        try {
            Log.i((String)"ByteBrew: ", (String)"Creating Custom Event");
            new ByteBrewHTTPManager(executorService, gameID, DEVKEY).Send(logEvent);
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("CreateCustomEvent: " + e.getMessage()));
        }
    }

    public void ValidateIAPEvent(String items, final ByteBrewPurchaseValidationResult resultCallback) {
        if (!trackingEnabled) {
            return;
        }
        JSONObject logEvent = null;
        try {
            logEvent = new JSONObject(items);
            logEvent.getJSONObject("externalData").put("buildID", (Object)androidBuildID);
            logEvent.getJSONObject("externalData").put("userLocale", (Object)language);
            logEvent.getJSONObject("externalData").put("userTimeZone", (Object)deviceTimeZone);
            logEvent.put("user_adid", (Object)googleADID);
            logEvent.put("game_id", (Object)gameID);
            logEvent.put("sdk_version", (Object)bb_sdk_version);
            logEvent.put("geo", (Object)GEOCode);
            logEvent.put("engine_version", (Object)engineVersion);
            logEvent.put("version_number", (Object)buildVersion);
            logEvent.put("bundle_id", (Object)packageName);
            logEvent.put("deviceCarrier", (Object)deviceCarrier);
            logEvent.put("carrierCodes", (Object)deviceCarrierCodes);
            logEvent.put("deviceScreenSize", (Object)screenSize);
            logEvent.put("deviceCapacity", (Object)phoneCapacity);
            logEvent.put("device_maker", (Object)deviceMaker);
            logEvent.put("device_name", (Object)deviceName);
            logEvent.put("device", (Object)deviceModel);
            logEvent.put("os_version", (Object)osVersion);
            logEvent.put("platform", (Object)PLATFORM);
            logEvent.put("user_id", (Object)userID);
            logEvent.put("session_id", (Object)sessionID);
            logEvent.put("session_key", (Object)sessionKey);
        }
        catch (JSONException exception) {
            Log.i((String)"ByteBrew Exception", (String)exception.getMessage());
            return;
        }
        try {
            Log.i((String)"ByteBrew: ", (String)"Testing validation of purchase");
            new ByteBrewHTTPManager(executorService, gameID, DEVKEY).ValidateData(logEvent, new ByteBrewPurchaseValidationResult(){

                @Override
                public void purchaseValidated(ByteBrewPurchaseResult result) {
                    resultCallback.purchaseValidated(result);
                }
            });
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("ValidateIAPEvent: " + e.getMessage()));
        }
    }

    public static void SetSessionKey(String key) {
        sessionKey = key;
    }

    public static void SetRemoteConfigurations(JSONObject configs) {
        remoteConfigurations = configs;
    }

    public boolean IsRemoteConfigsSet() {
        return remoteConfigurations != null;
    }

    public String GetRemoteConfigForKey(String key, String defaultValue) {
        if (remoteConfigurations == null) {
            return defaultValue;
        }
        try {
            return remoteConfigurations.getString(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void StartTracking(Context context) {
        if (context == null) {
            trackingEnabled = true;
            byteBrewUtils.StartTracking(currentContext);
        } else {
            trackingEnabled = true;
            byteBrewUtils.StartTracking(context);
        }
    }

    public void StopTracking(Context context) {
        if (context == null) {
            trackingEnabled = false;
            byteBrewUtils.StopTracking(currentContext);
        } else {
            trackingEnabled = false;
            byteBrewUtils.StopTracking(context);
        }
    }

    static {
        bb_sdk_version = "0.1.5";
        executorService = Executors.newCachedThreadPool();
    }
}

