/*
 * Decompiled with CFR 0.152.
 */
package com.bytebrew.bytebrewlibrary;

import android.content.Context;
import android.util.Log;
import com.bytebrew.bytebrewlibrary.ByteBrew;
import com.bytebrew.bytebrewlibrary.ByteBrewHTTPRetrievalResponse;
import com.bytebrew.bytebrewlibrary.ByteBrewHandler;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Executor;
import org.json.JSONObject;

class ByteBrewInitializer {
    protected String key;
    protected String gameID = null;
    protected static final String _baseurl = "https://api.bytebrew.io/api/game/logs/add";
    public ByteBrewHTTPRetrievalResponse loadDelegate;
    private Executor executor;

    public ByteBrewInitializer(Executor currentExecutor, String gameID, String key) {
        this.executor = currentExecutor;
        this.gameID = gameID;
        this.key = key;
    }

    public void InitializeUser(final JSONObject data, final Context context) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (data == null) {
                    return;
                }
                try {
                    if (data.has("user_adid")) {
                        ByteBrewInitializer.this.InitializeUser(data);
                    } else {
                        String advertID = ByteBrewInitializer.this.GetUserAdvertisingID(context);
                        data.put("user_adid", (Object)advertID);
                        ByteBrewInitializer.this.InitializeUser(data);
                    }
                }
                catch (Exception e) {
                    Log.i((String)"ByteBrew Exception", (String)("Couldn't Initialize: " + e.getMessage()));
                }
            }
        });
    }

    private String GetUserAdvertisingID(Context context) {
        try {
            if (!AdvertisingIdClient.getAdvertisingIdInfo((Context)context).isLimitAdTrackingEnabled()) {
                AdvertisingIdClient.Info idInfo = null;
                try {
                    idInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                }
                catch (GooglePlayServicesNotAvailableException e) {
                    e.printStackTrace();
                }
                catch (GooglePlayServicesRepairableException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String advertId = null;
                try {
                    advertId = idInfo.getId();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                ByteBrewHandler.getInstance().SetAdID(advertId);
                return advertId;
            }
            ByteBrewHandler.getInstance().SetAdID("");
            return "";
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("Couldn't Retrieve Advertising ID: " + e.getMessage()));
            return "";
        }
    }

    private void InitializeUser(JSONObject data) {
        try {
            URL url = new URL(_baseurl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("sdk-key", this.key);
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.connect();
            OutputStream outputStream = urlConnection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            writer.write(data.toString());
            writer.close();
            outputStream.close();
            int statusCode = urlConnection.getResponseCode();
            if (statusCode == 200) {
                if (urlConnection.getHeaderField("session_key") != null) {
                    ByteBrewHandler.SetSessionKey(urlConnection.getHeaderField("session_key"));
                }
                Log.i((String)"ByteBrew: ", (String)"ByteBrew Initialized");
                ByteBrew.SetSDKInitialized();
            } else {
                Log.i((String)"ByteBrew Exception", (String)(": " + urlConnection.getResponseMessage() + " : " + urlConnection.getResponseCode()));
            }
        }
        catch (Exception e) {
            Log.i((String)"ByteBrew Exception", (String)("Couldn't Initialize: " + e.getMessage()));
        }
    }
}

