/*
 * Decompiled with CFR 0.152.
 */
package com.bytebrew.bytebrewlibrary;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.JobIntentService;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.bytebrew.bytebrewlibrary.ByteBrewApplcationCallbacks;
import com.bytebrew.bytebrewlibrary.ByteBrewDismissPushReceiver;
import com.bytebrew.bytebrewlibrary.ByteBrewUtils;
import com.bytebrew.bytebrewlibrary.ByteBundleToJson;
import com.bytebrew.bytebrewlibrary.BytePushConfigs;
import com.bytebrew.bytebrewlibrary.BytePushHTTPManager;
import org.json.JSONObject;

public class ByteBrewPushService
extends JobIntentService {
    static void enqueueWork(Context context, Intent work) {
        ByteBrewPushService.enqueueWork((Context)context, ByteBrewPushService.class, (int)1234, (Intent)work);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        Log.d((String)"ByteBrew Push", (String)"Handling Notification");
        ByteBrewUtils byteBrewUtils = new ByteBrewUtils();
        JSONObject appConfig = byteBrewUtils.GetAppConfig((Context)this);
        if (!appConfig.has("key")) {
            Log.d((String)"ByteBrew Push", (String)"Can't setup push notifications");
            return;
        }
        BytePushConfigs.getInstance().SetAppConfig(appConfig);
        if (intent.getStringExtra("pushIntent").equals("RECEIVED")) {
            this.HandleReceivedPushMessage(intent);
        } else if (intent.getStringExtra("pushIntent").equals("DISMISSED")) {
            this.HandleDismissedPushMessage(intent);
        } else {
            Log.d((String)"ByteBrew Push", (String)"Category doesn't match");
        }
    }

    public void HandleReceivedPushMessage(Intent intent) {
        try {
            Log.d((String)"ByteBrew Push", (String)"Notification was received");
            if (intent.hasExtra("byte_message_type")) {
                if (intent.getStringExtra("byte_message_type").equals("uninstall_silent")) {
                    new BytePushHTTPManager(BytePushConfigs.getInstance().GetGameID(), BytePushConfigs.getInstance().GetSDKKey(), BytePushConfigs.getInstance().GetUserID()).UpdateUninstallStats(intent);
                }
            } else {
                if (ByteBrewApplcationCallbacks.isInForeground) {
                    return;
                }
                new BytePushHTTPManager(BytePushConfigs.getInstance().GetGameID(), BytePushConfigs.getInstance().GetSDKKey(), BytePushConfigs.getInstance().GetUserID()).UpdatePushStats(intent);
                this.ShowPushMessage(this.getApplicationContext(), new JSONObject(ByteBundleToJson.getJson(intent.getExtras(), 0)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void HandleDismissedPushMessage(Intent intent) {
        try {
            Log.d((String)"ByteBrew Push", (String)"Notification was dismissed");
            new BytePushHTTPManager(BytePushConfigs.getInstance().GetGameID(), BytePushConfigs.getInstance().GetSDKKey(), BytePushConfigs.getInstance().GetUserID()).UpdatePushStats(intent);
            this.RemoveAnyPushNotificationMatching(intent.getIntExtra("push_request_id", 0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void ShowPushMessage(Context context, JSONObject pushMessage) {
        try {
            int largeid;
            int smallid;
            int requestID = (int)System.currentTimeMillis();
            this.SaveNotification(requestID, pushMessage.getString("byte_message_sent_id"));
            Intent intent = context.getApplicationContext().getPackageManager().getLaunchIntentForPackage(context.getApplicationContext().getPackageName());
            intent.setFlags(0x10008000);
            intent.putExtra("byte_message_sent_id", pushMessage.getString("byte_message_sent_id"));
            intent.putExtra("push_request_id", requestID);
            intent.putExtra("pushIntent", "OPENED");
            PendingIntent pendingIntent = ByteBrewPushService.CreatePendingIntentGetActivity(context.getApplicationContext(), requestID, intent);
            Intent dismissIntent = new Intent(context, ByteBrewDismissPushReceiver.class);
            dismissIntent.putExtra("byte_message_sent_id", pushMessage.getString("byte_message_sent_id"));
            dismissIntent.putExtra("push_request_id", requestID);
            PendingIntent pendingDismissIntent = ByteBrewPushService.CreatePendingIntentGetBroadCast(context.getApplicationContext(), requestID, dismissIntent);
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, context.getPackageName() + ".pushnotifications").setSmallIcon(context.getApplicationInfo().icon).setContentTitle((CharSequence)pushMessage.getString("gcm.notification.title")).setContentText((CharSequence)pushMessage.getString("gcm.notification.body")).setPriority(1).setContentIntent(pendingIntent).setDeleteIntent(pendingDismissIntent).setAutoCancel(true);
            if (pushMessage.has("byte_sm_icon") && (smallid = context.getResources().getIdentifier(pushMessage.getString("byte_sm_icon"), "drawable", context.getPackageName())) != 0) {
                builder.setSmallIcon(smallid);
            }
            if (pushMessage.has("byte_lg_icon") && (largeid = context.getResources().getIdentifier(pushMessage.getString("byte_lg_icon"), "drawable", context.getPackageName())) != 0) {
                Bitmap lgIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeid);
                builder.setLargeIcon(lgIcon);
            }
            NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)context);
            notificationManager.notify(pushMessage.getInt("google.sent_time"), builder.build());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static PendingIntent CreatePendingIntentGetActivity(Context context, int requestID, Intent intent) {
        if (Build.VERSION.SDK_INT >= 31) {
            return PendingIntent.getActivity((Context)context, (int)requestID, (Intent)intent, (int)0x4000000);
        }
        return PendingIntent.getActivity((Context)context, (int)requestID, (Intent)intent, (int)0);
    }

    public static PendingIntent CreatePendingIntentGetBroadCast(Context context, int requestID, Intent intent) {
        if (Build.VERSION.SDK_INT >= 31) {
            return PendingIntent.getBroadcast((Context)context, (int)requestID, (Intent)intent, (int)0x4000000);
        }
        return PendingIntent.getBroadcast((Context)context, (int)requestID, (Intent)intent, (int)0);
    }

    private void SaveNotification(int requestID, String pushID) {
        SharedPreferences sharedPreferences = this.getSharedPreferences("bytebrew_push_prefs", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("notification." + requestID, pushID);
        editor.apply();
    }

    private void RemoveAnyPushNotificationMatching(int requestID) {
        SharedPreferences sharedPreferences = this.getSharedPreferences("bytebrew_push_prefs", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("notification." + requestID);
        editor.apply();
    }
}

