/*
 * Decompiled with CFR 0.152.
 */
package io.pica.ads.utils;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import io.pica.ads.utils.Constant;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\r\u00a8\u0006\u0013"}, d2={"Lio/pica/ads/utils/Utils;", "", "()V", "convertDpToPixel", "", "dp", "context", "Landroid/content/Context;", "convertPixelsToDp", "px", "getFileFromAssets", "Ljava/io/File;", "fileName", "", "getStringAssetFile", "path", "showToastDebug", "", "text", "Ads_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nio/pica/ads/utils/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final void showToastDebug(@Nullable Context context, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Constant.INSTANCE.isDebug()) {
            Log.d((String)"Utils", (String)("showToastDebug: " + text));
        }
        if (context != null && Constant.INSTANCE.isShowToastDebug()) {
            Toast toast;
            Toast $this$showToastDebug_u24lambda_u240 = toast = Toast.makeText((Context)context, (CharSequence)("Utils: \n" + text), (int)1);
            boolean bl = false;
            $this$showToastDebug_u24lambda_u240.setGravity(48, 0, 100);
            toast.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getStringAssetFile(@NotNull String path, @NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            InputStream inputStream;
            InputStream inputStream2 = context.getAssets().open(path);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"open(...)");
            Closeable closeable = inputStream = inputStream2;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)closeable, (Charset)object2);
            int n = 8192;
            closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                object3 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            object = object3;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return object;
    }

    public final float convertDpToPixel(float dp, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return dp * ((float)context.getResources().getDisplayMetrics().densityDpi / (float)160);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File getFileFromAssets(@NotNull Context context, @NotNull String fileName) throws IOException {
        File file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File it = file = new File(context.getCacheDir(), fileName);
        boolean bl = false;
        if (!it.exists()) {
            Closeable closeable = new FileOutputStream(it);
            Throwable throwable = null;
            try {
                long l;
                FileOutputStream cache = (FileOutputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = context.getAssets().open(fileName);
                Throwable throwable2 = null;
                try {
                    InputStream inputStream = (InputStream)closeable2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)inputStream);
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)cache, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return file;
    }

    public final float convertPixelsToDp(float px, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return px / ((float)context.getResources().getDisplayMetrics().densityDpi / (float)160);
    }
}

