package io.pica.ads

import android.annotation.SuppressLint
import android.app.Activity
import android.app.Application
import android.os.Build
import android.os.Bundle
import android.util.Log
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.Lifecycle
import com.google.android.gms.ads.AdValue
import com.google.android.gms.ads.MobileAds
import com.google.android.gms.ads.RequestConfiguration
import com.google.gson.Gson
import io.pica.ads.admob.AdmobHolder
import io.pica.ads.model2.Ads
import io.pica.ads.model2.AdsChild
import io.pica.ads.model2.AdsId
import io.pica.ads.utils.AdDef
import io.pica.ads.utils.Constant
import io.pica.ads.utils.StateLoadAd
import io.pica.ads.utils.Utils
import io.pica.ads.utils.Utils.showToastDebug
import io.pica.cmp.CMPCallback
import io.pica.cmp.CMPController
import java.io.File
import java.io.FileReader
import java.io.FileWriter
import java.util.Locale


private const val TAG = "AdsController"

class AdsController private constructor(
    private var application: Application,
    var appId: String,
    var packetName: String,
    var pathJson: String,
    var isTrackAdRevenue: Boolean = true,
) {
    private var gson = Gson()

    /**
     * Map pace chứa các adsChild
     */
    private val hashMapAds = hashMapOf<String, AdsChild>()
    private val admobHolder = AdmobHolder()

    //    private var connectionLiveData: ConnectionLiveData = ConnectionLiveData(activity)
    private var isConnection: Boolean = true
    var isPremium: Boolean = false

    //Ads open resume
    private var adsOpenResume: AdsChild? = null
    private var isShowOpenAdsResumeNextTime = true
    private var isAutoShowAdsResume = false
    private var isAdsResumeOnOff = false
    private var timeDisplayAdsResume = 5000L
    private var clazzIgnoreAdResume = mutableListOf<Class<*>>()


    private var isShowAdsFullScreen = false
    private var isShowCMP = false

    private var isUseAdjust = false
    var isWaitCMP = true

    private var lastTimeClickAds: Long = 0
    private var lastTimeShowOpenAds: Long = 0
    private val listRunnable = mutableListOf<Runnable>()

    private var activity: Activity? = null
    private var adActivity: Activity? = null
    private var adCallbackAll: AdCallbackAll? = null

    var callbackChangeWaitCMP: (() -> Unit)? = null

//    var itgAdConfig: AdjustConfigApp = AdjustConfigApp(false, "")

    companion object {

        @SuppressLint("StaticFieldLeak")
        private lateinit var adsController: AdsController

        @SuppressLint("StaticFieldLeak")
        var mTopActivity: Activity? = null


        fun initSetup(
            application: Application,
            isDebug: Boolean,
            appId: String,
            packetName: String,
            pathJson: String,
            isTrackAdRevenue: Boolean = true,
            isSetupCMP: Boolean = true,
            listTestDeviceIds: List<String> = emptyList(),
        ) {
            Constant.isDebug = isDebug
            Constant.isShowToastDebug = isDebug
            val configuration =
                RequestConfiguration.Builder().setTestDeviceIds(listTestDeviceIds).build()
            MobileAds.setRequestConfiguration(configuration)
            MobileAds.initialize(application) { initializationStatus ->
                initializationStatus.adapterStatusMap.forEach {
                    Log.d(
                        TAG,
                        "Name: ${it.key}, description:  ${it.value.description}, initializationState: ${it.value.initializationState.name}"
                    )
                }
            }


            adsController =
                AdsController(
                    application,
                    appId,
                    packetName,
                    pathJson,
                    isTrackAdRevenue
                )

//            if (byteBrewConfig != null) {
//                setupByteBrew(application, byteBrewConfig)
//            }

//            adsController.itgAdConfig = adjustConfig
//            adsController.isUseAdjust = adjustConfig.isEnableAdjust
//            AdjustUtils.enableAdjustApply(adjustConfig.isEnableAdjust)

//            setupAdjust(application, adjustConfig)


            application.registerActivityLifecycleCallbacks(object :
                Application.ActivityLifecycleCallbacks {
                override fun onActivityCreated(activity: Activity, savedInstanceState: Bundle?) {
                    Log.d("AdsController", "AdsController ActivityLifecycle onActivityCreated: 1")
                    adsController.setActivity(activity)
                    Log.d("AdsController", "AdsController ActivityLifecycle onActivityCreated: 2")
                    if (isSetupCMP) {
                        Log.d(
                            "AdsController",
                            "AdsController ActivityLifecycle onActivityCreated: isSetupCMP, $isSetupCMP , isShowCMP,${adsController.isShowCMP}"
                        )
                        if (adsController.isShowCMP) return
                    }
                    adsController.isShowCMP = true
                    Log.d(
                        "AdsController",
                        "AdsController ActivityLifecycle onActivityCreated: 3 ,activity: ${activity.javaClass.name}"
                    )
                    CMPController(activity).showCMP(
                        isDebug,
                        listTestDeviceIds = listTestDeviceIds,
                        object : CMPCallback {
                            override fun onChangeScreen() {
                                Log.d(
                                    "AdsController",
                                    "AdsController: CMPController -> onChangeScreen: "
                                )
                            }

                            override fun onShowAd() {
                                Log.d("AdsController", "AdsController: CMPController -> onShowAd: ")
                            }

                        })
                    //todo
                }

                override fun onActivityStarted(activity: Activity) {
                    Log.d(TAG, "AdsController ActivityLifecycle onActivityStarted: ")
                    adsController.setActivity(activity)

                    //Check activity in packetName
                    Log.d(
                        TAG,
                        "AdsController onActivityStarted: ${activity.javaClass.name} in packetName: $packetName"
                    )
                    if (activity is AppCompatActivity || activity is ComponentActivity) {
                        Log.d(TAG, "AdsController onActivityStarted: 111")
                        adsController.showAdsResume(activity)
                    }


                }

                override fun onActivityResumed(activity: Activity) {
//                    mTopActivity = activity
                    adsController.setActivity(activity)
                }

                override fun onActivityPaused(activity: Activity) {

                }

                override fun onActivityStopped(activity: Activity) {

                }

                override fun onActivitySaveInstanceState(activity: Activity, outState: Bundle) {

                }

                override fun onActivityDestroyed(activity: Activity) {
//                    mTopActivity = null
                    adsController.setActivity(null)

                    if (adsController.checkAdActivity(activity)) {
                        adsController.adActivity = null
                    }
                }
            })
        }

//        private fun setupByteBrew(application: Application, byteBrewConfig: ByteBrewConfig) {
//            ByteBrew.InitializeByteBrew(
//                byteBrewConfig.byteBrewAppId,
//                byteBrewConfig.byteBrewAppKey,
//                getAndroidVersionName(),
//                application
//            )
//        }

        private fun getAndroidVersionName(): String {
            return Build.VERSION.SDK_INT.toString()
        }

        fun getInstance(): AdsController {
            if (!Companion::adsController.isInitialized) {
                throw Throwable("call init")
            }
            return adsController
        }

        fun checkInit() = Companion::adsController.isInitialized
    }

    init {

        readDataJson()
    }


    /**
     * Set Debug Mode
     */
    fun setDebugMode(isDebug: Boolean) {
        Constant.isDebug = isDebug
    }

    /**
     * Set Show Open Ads Next Session
     */
    fun setShowOpenAdsNextSession(showOpenAdsResumeNextTime: Boolean) {
        isShowOpenAdsResumeNextTime = showOpenAdsResumeNextTime
    }

    fun getDebugMode() = Constant.isDebug
    private fun checkAppIdPacket(ads: Ads): Boolean {
        var checkAppId = false
        var checkPacket = false
        if (ads.appId == appId) {
            checkAppId = true
        }
        if (!checkAppId) showToastDebug(activity, "wrong appId network ${ads.network}")

        if (ads.packetName != packetName) {
            showToastDebug(activity, "wrong packetName")
        } else {
            checkPacket = true
        }
        return checkAppId && checkPacket
    }


    private fun readDataJson() {
        val ads: Ads
        try {
            val stringAssetFile = Utils.getStringAssetFile(pathJson, application)
            ads = if (getFileCacheAds().exists()) {
                try {
                    val fileReader = FileReader(getFileCacheAds())
                    gson.fromJson(fileReader, Ads::class.java)
                } catch (e: Exception) {
                    gson.fromJson(stringAssetFile, Ads::class.java)
                }
            } else {
                gson.fromJson(stringAssetFile, Ads::class.java)
            }

            if (checkAppIdPacket(ads)) {
                ads.listAds.forEach { adsChild ->
                    val adsType = adsChild.adsType.lowercase(Locale.ROOT)
                    if (AdDef.ADS_TYPE.OPEN_APP_RESUME == adsType) {
                        Log.d("AdsController", "AdsController adsOpenResume: $adsChild, $adsType, Apply")
                        this.adsOpenResume = adsChild
                    }
                    this.hashMapAds[adsChild.spaceName] = adsChild
                }
            }
        } catch (e: Exception) {
            showToastDebug(activity, "no load data json ads file")
        }
    }

    private fun getFileCacheAds(): File {
        return File(application.cacheDir, "ads.json")
    }

    /**
     * Có thể load từ remote config nhưng cần check xem có thỏa mãi điều kiện không
     *
     * Todo tên fun check xem json đó có đúng chuẩn config không .
     */

    fun setAdData(adConfigString: String) {
        val configString = adConfigString.trimIndent()
        try {
            if (configString.isNotEmpty() && validateJson(configString)) {
                //todo validate json
                FileWriter(getFileCacheAds()).use {
                    it.write(configString)
                    it.close()
                }
            }

            try {
                val ads = gson.fromJson(configString, Ads::class.java)
                if (checkAppIdPacket(ads)) {
                    hashMapAds.clear()
                    ads.listAds.forEach { adsChild ->
                        val adsType = adsChild.adsType.lowercase(Locale.ROOT)
                        if (AdDef.ADS_TYPE.OPEN_APP_RESUME == adsType) {
                            this.adsOpenResume = adsChild
                        }
                        this.hashMapAds[adsChild.spaceName] = adsChild
                    }
                }
            } catch (e: Exception) {
                showToastDebug(activity, "no load data json ads file")
            }
        } catch (e: Exception) {
            showToastDebug(activity, "no load data json ads file")
        }
    }

    private fun validateJson(adConfigString: String): Boolean {
        return try {
            gson.fromJson(adConfigString, Ads::class.java)
            true
        } catch (e: Exception) {
            false
        }
    }

    fun isAllowedShow(spaceName: String): Boolean {
        if (!isPremium) {
            val adsChild = hashMapAds[spaceName]
            if ((adsChild != null) && (adsChild.adsIds.size > 0) && adsChild.status) return true
        }
        return false
    }

    fun checkAdActivity(activity: Activity?): Boolean {
        //|| (activity is com.vungle.warren.AdActivity) || (activity is AdColonyInterstitialActivity) || (activity is AdColonyAdViewActivity);
        return activity is com.google.android.gms.ads.AdActivity

    }


    fun setActivity(activity: Activity?) {
        if (checkAdActivity(activity)) {
            adActivity = activity
        } else if (activity is AppCompatActivity || activity is ComponentActivity) {
            this.activity = activity
        }
    }

    /**
     * @Deprecated
     * Set Enable Ads Resume
     */
    fun setEnableAppResume(enable: Boolean) {
        isAutoShowAdsResume = enable
    }

    /**
     * set On/Off Ads Resume
     */
    fun setAdsResumeOnOff(enable: Boolean) {
        isAdsResumeOnOff = enable
    }

    /**
     * Set Time Display Ads Resume
     * Default 5000
     */
    fun setTimeDisplayAdsResume(time: Long) {
        timeDisplayAdsResume = time
    }

    fun setIgnoreAdResume(vararg clazz: Class<*>) {
        clazzIgnoreAdResume.clear()
        clazzIgnoreAdResume.add(com.google.android.gms.ads.AdActivity::class.java)
        clazzIgnoreAdResume.addAll(clazz)
    }

    /**
     * Call show ads resume
     */
    fun showAdsResume(activity: Activity) {
        Log.d("AdsController", "AdsController showAdsResume: 1 isAdsResumeOnOff->$isAdsResumeOnOff")
        if (!isAdsResumeOnOff) return
        Log.d(
            "AdsController",
            "AdsController showAdsResume: 2 isAutoShowAdsResume: $isAutoShowAdsResume, isPremium: $isPremium, isShowAdsFullScreen: $isShowAdsFullScreen"
        )

        if (clazzIgnoreAdResume.contains(activity.javaClass)) {
            Log.d("AdsController", "AdsController showAdsResume: 8, activity: ${activity.javaClass.name}")
            return
        }
        if (!isPremium && !isShowAdsFullScreen) {
            Log.d("AdsController", "AdsController showAdsResume: 3")
            if (isShowOpenAdsResumeNextTime) {
                Log.d(
                    "AdsController",
                    "AdsController showAdsResume: 4, isShowOpenAdsResumeNextTime $isShowOpenAdsResumeNextTime" +
                            " lastTimeShowOpenAds: $lastTimeShowOpenAds, lastTimeClickAds: $lastTimeClickAds"
                )
                if (System.currentTimeMillis() - lastTimeShowOpenAds > timeDisplayAdsResume && this.activity != null && adsOpenResume != null) {
                    Log.d(
                        "AdsController",
                        "AdsController showAdsResume: 5"
                    )
                    isShowAdsFullScreen = true
                    if (admobHolder.show(
                            this.activity!!,
                            adsOpenResume!!,
                            "",
                            null,
                            null,
                            null,
                            object : AdCallback {
                                override fun onAdShow(network: String, adType: String) {
                                    Log.d(
                                        "AdsController",
                                        "AdsController showAdsResume onAdShow: $network, $adType"
                                    )


                                }

                                override fun onAdClose(adType: String) {
                                    preloadAdsResume()
//                                    isShowAdsFullScreen = false
                                }

                                override fun onAdFailToLoad(messageError: String?) {
                                    Log.d(
                                        "AdsController",
                                        "AdsController showAdsResume onAdFailToLoad: $messageError"
                                    )

                                }

                                override fun onAdFailToShow(message: String) {}

                                override fun onAdImpression(adType: String) {

                                }

                                override fun onAdOff() {

                                }

                            })
                    ) {
                        lastTimeClickAds = System.currentTimeMillis()
                        isShowOpenAdsResumeNextTime = false
                    } else {
                        isShowAdsFullScreen = false
                        preloadAdsResume()
                    }
                }
            } else {
                Log.d("AdsController", "AdsController showAdsResume: 6")
                lastTimeShowOpenAds = System.currentTimeMillis()
            }
            if (System.currentTimeMillis() - this.lastTimeClickAds > 1000) {
                Log.d("AdsController", "AdsController showAdsResume: 7")
                this.isShowOpenAdsResumeNextTime = true
            }
        }

    }

    private fun preloadAdsResume() {
        Log.d("AdsController", "AdsController preloadAdsResume: ")
        if (isPremium || activity == null) {
            Log.d("AdsController", "AdsController preloadAdsResume: 1")
            return
        }
        if (adsOpenResume == null) {
            Log.d("AdsController", "AdsController preloadAdsResume: 2")
            return
        }
        if (!isAdsResumeOnOff) {
            Log.d("AdsController", "AdsController preloadAdsResume: 3")
            return
        }
        Log.d("AdsController", "AdsController preloadAdsResume: 4")

        val runnable = Runnable {
            isAutoShowAdsResume = true
            if (adsOpenResume != null) {
                if (!adsOpenResume!!.status) return@Runnable
                val statusPreload = admobHolder.getStatusPreload(adsOpenResume!!)
                if (statusPreload == StateLoadAd.LOADING || statusPreload == StateLoadAd.NONE) {
                    return@Runnable
                }
                Log.d("AdsController", "AdsController preloadAdsResume: 5")
                admobHolder.preload(activity!!, adsOpenResume!!, null)
            }

        }
        if (isWaitCMP) {
            listRunnable.add(runnable)
        } else {
            runnable.run()
        }
    }


    private fun checkAdsNotShowOpenResume(adsChild: AdsChild): Boolean {
        val adsType = adsChild.adsType.lowercase(Locale.ROOT)
        return adsType == AdDef.ADS_TYPE.INTERSTITIAL ||
                adsType == AdDef.ADS_TYPE.REWARD_VIDEO ||
                adsType == AdDef.ADS_TYPE.OPEN_APP ||
                adsType == AdDef.ADS_TYPE.REWARD_INTERSTITIAL
    }


    private fun getAdCallback(adsChild: AdsChild, adCallback: AdCallback?): AdCallback {
        return object : AdCallback {
            override fun onAdShow(network: String, adType: String) {
                adCallback?.onAdShow(network, adType)
                adCallbackAll?.onAdShow(adsChild)
            }

            override fun onAdClose(adType: String) {
                adCallback?.onAdClose(adType)
                adCallbackAll?.onAdClose(adsChild)
                isShowAdsFullScreen = false
            }


            override fun onAdFailToLoad(messageError: String?) {
                adCallback?.onAdFailToLoad(messageError)
                adCallbackAll?.onAdFailToLoad(adsChild, messageError)
                showToastDebug(
                    activity,
                    "Fail to load ${adsChild.adsType} ${adsChild.spaceName}" + adsChild.adsIds.joinToString { ", " })
            }

            override fun onAdFailToShow(message: String) {
                adCallback?.onAdFailToShow(message)
                adCallbackAll?.onAdFailToLoad(adsChild, message)
                isShowAdsFullScreen = false
                showToastDebug(
                    activity,
                    "Fail to load ${adsChild.adsType} ${adsChild.spaceName}" + adsChild.adsIds.joinToString { ", " })
            }

            override fun onAdOff() {
                adCallback?.onAdOff()
                adCallbackAll?.onAdOff(adsChild)
            }

            override fun onAdClick() {
                adCallback?.onAdClick()
                adCallbackAll?.onAdClick(adsChild)
                isShowOpenAdsResumeNextTime = false
                lastTimeClickAds = System.currentTimeMillis()
                showToastDebug(
                    activity,
                    "Fail to load ${adsChild.adsType} ${adsChild.spaceName} ${adsChild.adsIds.joinToString { "," }}"
                )
            }

            override fun onPaidEvent(params: Bundle, adValue: AdValue) {
                adCallback?.onPaidEvent(params, adValue)
                adCallbackAll?.onPaidEvent(adsChild, params)


                Log.d("beta", "AdsController onPaidEvent: params-> $params, adValue-> $adValue")

                if (isUseAdjust) {
//                    AdjustUtils.pushTrackEventAdmob(adValue)
                }

//                val isUseAppflyer = this@AdsController.isUseAppflyer
//                if (isUseAppflyer) {
//                    AppFlyerUtils.logAdRevenue(params)
//                }


            }

            override fun onRewardShow(network: String, adType: String) {
                adCallback?.onRewardShow(network, adType)
                adCallbackAll?.onRewardShow(adsChild)
            }

            override fun onAdImpression(adType: String) {
                adCallback?.onAdImpression(adType)
                adCallbackAll?.onAdImpression(adsChild)
            }
        }
    }

    fun clearAllAds() {
        admobHolder.clearAllAd()
    }

    fun preload(
        spaceName: String,
        preloadCallback: PreloadCallback? = null,
    ) {
        if (isPremium) return
        if (activity == null) {
            return
        }
        val preloadRunnable = Runnable {
            val adsChild = hashMapAds[spaceName]
            adsChild?.let {
                if (!it.status) {
                    preloadCallback?.onLoadFail()
                    return@Runnable
                }

                if (it.adsType == AdDef.ADS_TYPE.INTERSTITIAL ||
                    it.adsType == AdDef.ADS_TYPE.OPEN_APP ||
                    it.adsType == AdDef.ADS_TYPE.REWARD_VIDEO ||
                    it.adsType == AdDef.ADS_TYPE.NATIVE
                ) {
                    showToastDebug(
                        activity,
                        "Pre load ${it.adsType} ${it.spaceName}" + it.adsIds.joinToString { "," })
                }

                // Modify the logic below based on your needs
                admobHolder.preload(activity!!, it, preloadCallback)
            }
        }
        if (isWaitCMP) {
            listRunnable.add(preloadRunnable)
        } else {
            preloadRunnable.run()
        }
    }

    /**
     * @Deprecated
     *
     */
    fun showLoadedAd(
        spaceName: String,
        loadingText: String? = null,
        layout: ViewGroup? = null,
        layoutAds: View? = null,
        lifecycle: Lifecycle? = null,
        timeMillisecond: Long = Constant.TIME_OUT_DEFAULT,
        adCallback: AdCallback? = null,
    ) {
        if (isPremium) return
        if (activity == null) return

        val showAdRunnable = Runnable {
            val adsChild = hashMapAds[spaceName]
            adsChild?.let {
                if (!it.status) {

                    adCallback?.onAdFailToLoad(Constant.ERROR_AD_OFF)
                    showToastDebug(
                        activity,
                        "Show ${it.adsType} ${it.spaceName} ${it.adsIds.joinToString { "," }}"
                    )
                    return@Runnable
                }
                if (checkAdsNotShowOpenResume(it)) {
                    isShowAdsFullScreen = true
                }
                showToastDebug(
                    activity,
                    "Show ${it.adsType} ${it.spaceName} ${it.adsIds.joinToString { "," }}"
                )
                admobHolder.showLoadedAd(
                    activity!!,
                    it,
                    loadingText,
                    layout,
                    layoutAds,
                    lifecycle,
                    timeMillisecond,
                    adCallback
                )
            } ?: showToastDebug(activity, "Không tìm thấy space: $spaceName")
        }

        if (isWaitCMP) {
            listRunnable.add(showAdRunnable)
        } else {
            showAdRunnable.run()
        }
    }


    fun show(
        spaceName: String,
        reloadLoadSpaceName: String? = null,
        textLoading: String? = null,
        layout: ViewGroup? = null,
        layoutAds: View? = null,
        lifecycle: Lifecycle? = null,
        timeMillisecond: Long = Constant.TIME_OUT_DEFAULT,
//        timeDelayShowAd: Int = 0,
        adCallback: AdCallback? = null,
    ) {
        if (isPremium) {
            layout?.visibility = View.GONE
            adCallback?.onAdShow("", "")
            return
        }
        val showAdRunnable = Runnable {
            val adsChild = hashMapAds[spaceName]

            if (activity == null) return@Runnable
            if (adsChild == null) {
                adCallback?.onAdFailToLoad("adsChild: null")
                return@Runnable
            }
            if (!adsChild.status) {
                adCallback?.onAdFailToLoad(Constant.ERROR_AD_OFF)
                showToastDebug(
                    activity,
                    "Show ${adsChild.adsType} ${adsChild.spaceName} ${adsChild.adsIds.joinToString { "," }}"
                )
                return@Runnable
            }
            if (checkAdsNotShowOpenResume(adsChild)) {
                isShowAdsFullScreen = true
            }
            if (admobHolder.show(
                    activity!!,
                    adsChild,
                    textLoading,
                    layout,
                    layoutAds,
                    lifecycle,
                    getAdCallback(adsChild, adCallback),
                )
            ) {
                lastTimeClickAds = System.currentTimeMillis()

                return@Runnable
            }

            isShowAdsFullScreen = false
        }

        if (isWaitCMP) {
            listRunnable.add(showAdRunnable)
        } else {
            showAdRunnable.run()
        }
    }

    fun loadAndShow(
        spaceName: String,
        isKeepAds: Boolean = false,
        loadingText: String? = null,
        layout: ViewGroup? = null,
        layoutAds: View? = null,
        lifecycle: Lifecycle? = null,
        delayToShow: Long? = null,
        adCallback: AdCallback? = null,
    ) {
        if (isPremium) {
            layout?.visibility = View.GONE
            adCallback?.onAdFailToLoad("premium")
            return
        }
        val loadAndShowRunnable = Runnable {
            val adsChild = hashMapAds[spaceName]
            if (adsChild == null) {
                adCallback?.onAdFailToLoad("adsChild: $spaceName null")
                Log.d("AdsController", "AdsController loadAndShow: adsChild: $spaceName null")
                return@Runnable
            }
            if (!adsChild.status) {
                adCallback?.onAdFailToLoad(Constant.ERROR_AD_OFF)
                showToastDebug(
                    activity,
                    "Show ${adsChild.adsType} ${adsChild.spaceName} ${adsChild.adsIds.joinToString { "," }}"
                )
                return@Runnable
            }
            if (checkAdsNotShowOpenResume(adsChild)) {
                isShowAdsFullScreen = true
            }
            if (adsChild.adsType == AdDef.ADS_TYPE.INTERSTITIAL ||
                adsChild.adsType == AdDef.ADS_TYPE.OPEN_APP ||
                adsChild.adsType == AdDef.ADS_TYPE.REWARD_VIDEO
            ) {
                showToastDebug("Load ${adsChild.adsType}, ${adsChild.spaceName}", adsChild.adsIds)
            }
            admobHolder.loadAndShow(
                activity!!,
                isKeepAds,
                adsChild,
                loadingText,
                layout,
                layoutAds,
                lifecycle,
                delayToShow,
                getAdCallback(adsChild, adCallback)
            )
        }

        Log.d("AdsController", "AdsController loadAndShow: isWaitCMP $isWaitCMP")
        if (isWaitCMP) {
            listRunnable.add(loadAndShowRunnable)
        } else {
            loadAndShowRunnable.run()
        }

    }

    fun showToastDebug(text: String, list: List<AdsId>) {
        if (Constant.isDebug || Constant.isShowToastDebug) {
            try {
                val inflate = LayoutInflater.from(activity).inflate(R.layout.pop_up_toast, null)
                val textView1 = inflate.findViewById<TextView>(R.id.tv1)
                val textView2 = inflate.findViewById<TextView>(R.id.tv2)
                val textView3 = inflate.findViewById<TextView>(R.id.tv3)
                inflate.findViewById<TextView>(R.id.tvTitle).text = text

                val sortedList = list.sortedBy { it.priority }

                when (list.size) {
                    1 -> {
                        textView1.visibility = View.VISIBLE
                        textView1.text = sortedList[0].id
                    }

                    2 -> {
                        textView1.visibility = View.VISIBLE
                        textView3.visibility = View.VISIBLE
                        textView1.text = sortedList[0].id
                        textView3.text = sortedList[1].id
                    }

                    3 -> {
                        textView1.visibility = View.VISIBLE
                        textView2.visibility = View.VISIBLE
                        textView3.visibility = View.VISIBLE
                        textView1.text = sortedList[0].id
                        textView2.text = sortedList[1].id
                        textView3.text = sortedList[2].id
                    }
                }

                val toast = Toast(activity)
                toast.view = inflate
                toast.duration = Toast.LENGTH_SHORT
                toast.setGravity(Gravity.TOP or Gravity.CENTER_HORIZONTAL, 0, 120)
                toast.show()
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    fun getStatusPreload(spaceName: String): StateLoadAd {
        val adsChild = hashMapAds[spaceName]
        if (adsChild != null) {
            return admobHolder.getStatusPreload(adsChild)
        }
        return StateLoadAd.NONE
    }

    fun destroy(spaceName: String?) {
        val adsChild = hashMapAds[spaceName?.lowercase(Locale.getDefault())]
        adsChild?.let {
            admobHolder.destroy(it)
        }
    }

    fun destroyAll() {
        val listAll = hashMapAds.values
        listAll.forEach { adsChild ->
            admobHolder.destroy(adsChild)
        }
    }

    fun cmpComplete() {
        Log.d(TAG, "AdsController cmpComplete: $isWaitCMP")
        isWaitCMP = false
        callbackChangeWaitCMP?.invoke()
        for (runnable in listRunnable) {
            runnable.run()
        }
        listRunnable.clear()
    }

}
