package io.pica.ads.admob

import android.app.Activity
import android.os.Bundle
import android.util.Log
import android.view.View
import android.view.ViewGroup
import androidx.lifecycle.Lifecycle
import com.google.android.gms.ads.AdValue
import io.pica.ads.AdCallback
import io.pica.ads.PreloadCallback
import io.pica.ads.StateADCallback
import io.pica.ads.admob.ads.AdmobAdaptiveBanner
import io.pica.ads.admob.ads.AdmobAds
import io.pica.ads.admob.ads.AdmobBanner
import io.pica.ads.admob.ads.AdmobCollapsibleBanner
import io.pica.ads.admob.ads.AdmobInlineBanner
import io.pica.ads.admob.ads.AdmobInterstitial
import io.pica.ads.admob.ads.AdmobNative
import io.pica.ads.admob.ads.AdmobOpenAds
import io.pica.ads.admob.ads.AdmobOpenAdsResume
import io.pica.ads.admob.ads.AdmobReward
import io.pica.ads.admob.ads.AdmobRewardInterstitial
import io.pica.ads.model2.AdsChild
import io.pica.ads.model2.AdsId
import io.pica.ads.utils.AdDef
import io.pica.ads.utils.StateLoadAd
import io.pica.ads.utils.Utils
import java.util.Locale

private const val TAG = "AdmobHolder"

class AdmobHolder {
    private var hashMap: HashMap<String, AdmobAds> = HashMap()


    fun clearAllAd() {
        hashMap.clear()
    }

    fun loadAndShow(
        activity: Activity,
        isKeepAds: Boolean,
        adsChild: AdsChild,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle?,
        timeMillisecond: Long?,
        adCallback: AdCallback?
    ) {
        Log.d("beta", "AdmobHolder loadAndShow: 1 ${adsChild.adsType} ${adsChild.spaceName} ${adsChild.adsIds.joinToString(", "){ it.id }}")
        loadAndShow(
            activity,
            adsChild,
            loadingText,
            layout,
            layoutAds,
            lifecycle,
            timeMillisecond,
            adCallback,
            position = 0
        )
    }

    private fun loadAndShow(
        activity: Activity,
        adsChild: AdsChild,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle?,
        timeMillisecond: Long?,
        adCallback: AdCallback?,
        position: Int = 0
    ) {
        Log.d("beta", "AdmobHolder loadAndShow: 2 ${adsChild.adsType} ${adsChild.spaceName} ${adsChild.adsIds.joinToString(", "){ it.id }}")
        var ads: AdmobAds? = null
//        val key = (adsChild.adsType + adsChild.spaceName).lowercase(Locale.ROOT)
        val currentTimeMillis = System.currentTimeMillis()
        val adsId: AdsId = adsChild.adsIds.sortedWith(compareBy { it.priority })[position]
        when (adsChild.adsType.lowercase(Locale.ROOT)) {
            AdDef.ADS_TYPE.NATIVE -> {
                ads = AdmobNative()
            }

            AdDef.ADS_TYPE.INTERSTITIAL -> {
                Log.d("AdmobInterstitial", "loadAndShow: zzz")
                ads = AdmobInterstitial()
            }

            AdDef.ADS_TYPE.BANNER -> {
                ads = AdmobBanner()
            }

            AdDef.ADS_TYPE.BANNER_ADAPTIVE -> {
                Log.d("beta", "AdmobHolder loadAndShow: BANNER_ADAPTIVE")
                ads = AdmobAdaptiveBanner()
            }

            AdDef.ADS_TYPE.BANNER_INLINE -> ads = AdmobInlineBanner()

            AdDef.ADS_TYPE.BANNER_COLLAPSIBLE -> ads = AdmobCollapsibleBanner(isShowBottom = true)

            AdDef.ADS_TYPE.BANNER_COLLAPSIBLE_TOP -> ads = AdmobCollapsibleBanner(isShowBottom = false)

            AdDef.ADS_TYPE.REWARD_VIDEO -> {
                ads = AdmobReward()
            }

            AdDef.ADS_TYPE.OPEN_APP -> {
                ads = AdmobOpenAds()
            }

            AdDef.ADS_TYPE.OPEN_APP_RESUME -> {
                ads = AdmobOpenAdsResume()
            }

            AdDef.ADS_TYPE.REWARD_INTERSTITIAL -> {
                ads = AdmobRewardInterstitial()
            }

            else -> {
                Log.d("AdsController", "AdmobHolder loadAndShow: not support adType ${adsChild.adsType} check file json")
                Utils.showToastDebug(
                    activity,
                    "not support adType ${adsChild.adsType} check file json"
                )
                adCallback?.onAdFailToLoad("")
            }
        }
        Log.d(TAG, "loadAndShow: ${adCallback == null}")

        ads?.loadAndShow(
            activity,
            adsId.id,
            loadingText,
            layout,
            layoutAds,
            lifecycle,
            timeMillisecond,
            object : AdCallback {
                override fun onAdShow(network: String, adType: String) {
                    Log.d(TAG, "onAdShow: ")
                    adCallback?.onAdShow(network, adType)
                }

                override fun onAdClose(adType: String) {
                    Log.d(TAG, "onAdClose: ")
                    adCallback?.onAdClose(adType)
                }

                override fun onAdFailToLoad(messageError: String?) {
                    Log.d(TAG, "onAdFailToLoad: unit id, ${adsId.id} adsChild.adsIds.size:${adsChild.adsIds.size} $messageError")
                    if (position < adsChild.adsIds.size - 1) {
                        Log.d(TAG, "onAdFailToLoad: case 1")
                        val time = System.currentTimeMillis() - currentTimeMillis
                        if (timeMillisecond == null) {
                            loadAndShow(
                                activity,
                                adsChild,
                                loadingText,
                                layout,
                                layoutAds,
                                lifecycle,
                                null,
                                adCallback,
                                position + 1
                            )
                        } else if (time > 3000) {
                            loadAndShow(
                                activity,
                                adsChild,
                                loadingText,
                                layout,
                                layoutAds,
                                lifecycle,
                                time,
                                adCallback,
                                position + 1
                            )
                        }else{
                            adCallback?.onAdFailToLoad("TimeOut")
                        }
                    }else{
                        adCallback?.onAdFailToLoad(messageError)
                    }
                }

                override fun onAdFailToShow(message: String) {
                    Log.d(TAG, "onAdFailToShow: $message")
                    adCallback?.onAdFailToShow(message)
                }

                override fun onAdImpression(adType: String) {
                    Log.d(TAG, "onAdImpression: ")
                    adCallback?.onAdImpression(adType)
                }

                override fun onAdOff() {
                    Log.d(TAG, "onAdOff: ")
                    adCallback?.onAdOff()
                }

                override fun onAdClick() {
                    adCallback?.onAdClick()
                }

                override fun onRewardShow(network: String, adType: String) {
                    adCallback?.onRewardShow(network, adType)
                }

                override fun onPaidEvent(params: Bundle, adValue: AdValue) {
                    adCallback?.onPaidEvent(params, adValue)
                }

            }
        )
        val key = (adsChild.adsType + adsChild.spaceName + adsId.priority).lowercase(Locale.ROOT)
        if (ads != null) hashMap[key] = ads

    }

    fun preload(
        activity: Activity,
        adsChild: AdsChild,
        preloadCallback: PreloadCallback? = null
    ) {
        Log.d("preload", "preload: " + adsChild.adsType +", " + adsChild.spaceName +" ," + adsChild.adsIds.joinToString(", "){ it.id })
        if (adsChild.adsIds.isNotEmpty()) {
            preload(activity = activity, adsChild = adsChild, position = 0, preloadCallback)
        }else{
            preloadCallback?.onLoadFail()

        }
//
    }

    /**
     * preload ads
     */
    private fun preload(
        activity: Activity,
        adsChild: AdsChild,
        position: Int,
        preloadCallback: PreloadCallback? = null
    ) {

        Log.d("preload", "Admob holder: preload: ${adsChild.adsType} ${adsChild.spaceName} ${adsChild.adsIds[position]} ")
        var ads: AdmobAds? = null
        val adsId: AdsId = adsChild.adsIds.sortedWith(compareBy { it.priority })[position]
        when (adsChild.adsType.lowercase(Locale.getDefault())) {
            AdDef.ADS_TYPE.NATIVE -> {
                ads = AdmobNative()
            }

            AdDef.ADS_TYPE.INTERSTITIAL -> {
                ads = AdmobInterstitial()
            }

            AdDef.ADS_TYPE.BANNER -> ads = AdmobBanner()
            AdDef.ADS_TYPE.BANNER_INLINE -> ads = AdmobInlineBanner()
            AdDef.ADS_TYPE.BANNER_ADAPTIVE -> ads = AdmobAdaptiveBanner()

            AdDef.ADS_TYPE.BANNER_COLLAPSIBLE -> {
                ads = AdmobCollapsibleBanner(isShowBottom = true)
            }

            AdDef.ADS_TYPE.BANNER_COLLAPSIBLE_TOP -> {
                ads = AdmobCollapsibleBanner(isShowBottom = false)
            }

            AdDef.ADS_TYPE.REWARD_VIDEO -> {
                ads = AdmobReward()
            }

            AdDef.ADS_TYPE.OPEN_APP -> {
                ads = AdmobOpenAds()
            }

            AdDef.ADS_TYPE.OPEN_APP_RESUME -> {
                ads = AdmobOpenAdsResume()
            }

            AdDef.ADS_TYPE.REWARD_INTERSTITIAL -> {
                ads = AdmobRewardInterstitial()
            }

            else -> {
                Log.d("AdsController", "AdmobHolder preload: not support adType ${adsChild.adsType} check file json")
                Utils.showToastDebug(
                    activity,
                    "not support adType ${adsChild.adsType} check file json"
                )

            }
        }
        ads?.setPreloadCallback(object : PreloadCallback {
            override fun onLoadDone() {
                preloadCallback?.onLoadDone()
            }

            override fun onLoadFail() {
                super.onLoadFail()
                if (position < adsChild.adsIds.size - 1) {
                    preload(
                        activity,
                        adsChild,
                        position + 1,
                        preloadCallback
                    )
                } else {
                    preloadCallback?.onLoadFail()
                }
            }
        })
        val key = (adsChild.adsType + adsChild.spaceName + adsId.priority).lowercase(Locale.ROOT)
        if (ads != null) {
            ads.preload(activity, adsId.id)
            hashMap[key] = ads
        }
    }

    fun checkStateAD(
        activity: Activity,
        adsChild: AdsChild,
        stateADCallback: StateADCallback? = null
    ) {
//        var ads: AdmobAds? = null
        val key = (adsChild.adsType + adsChild.spaceName).lowercase(Locale.getDefault())
        val ads: AdmobAds? = hashMap[key]

        if (ads != null && ads is AdmobInterstitial) {
            try {
                ads.setStateAdCallback(stateADCallback)
            } catch (_: Exception) {
            }
        } else if (ads != null && ads is AdmobReward) {
            try {
                ads.setStateAdCallback(stateADCallback)
            } catch (_: Exception) {
            }
        } else {
            stateADCallback?.onState(StateLoadAd.NONE)
        }
    }


    fun show(
        activity: Activity,
        adsChild: AdsChild,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle? = null,
        adCallback: AdCallback?
    ): Boolean {
        val adsIds = adsChild.adsIds.sortedWith(compareBy { it.priority })

        adsIds.forEach { adsId ->
            val key =
                (adsChild.adsType + adsChild.spaceName + adsId.priority).lowercase(Locale.ROOT)
            val ads: AdmobAds? = hashMap[key]
            if (ads != null && !ads.isDestroy() && ads.isLoaded() && ads.wasLoadTimeLessThanNHoursAgo(1)) {
                val checkShow = when (adsChild.adsType.lowercase(Locale.getDefault())) {
                    AdDef.ADS_TYPE.NATIVE,
                    AdDef.ADS_TYPE.BANNER,
                    AdDef.ADS_TYPE.BANNER_ADAPTIVE,
                    AdDef.ADS_TYPE.BANNER_INLINE,
                    AdDef.ADS_TYPE.BANNER_COLLAPSIBLE,
                    AdDef.ADS_TYPE.BANNER_COLLAPSIBLE_TOP,
                    AdDef.ADS_TYPE.OPEN_APP,
                    AdDef.ADS_TYPE.REWARD_VIDEO,
                    AdDef.ADS_TYPE.REWARD_INTERSTITIAL,
                    AdDef.ADS_TYPE.INTERSTITIAL -> {
                        ads.show(
                            activity,
                            adsId.id,
                            loadingText,
                            layout,
                            layoutAds,
                            lifecycle,
                            adCallback
                        )
                        hashMap.remove(key)
                        true
                    }
                    AdDef.ADS_TYPE.OPEN_APP_RESUME -> {
                        ads.show(
                            activity,
                            adsId.id,
                            loadingText,
                            layout,
                            layoutAds,
                            lifecycle,
                            adCallback
                        )
                        true
                    }

                    else -> {
                        Log.d("AdsController", "AdmobHolder show: not support adType ${adsChild.adsType} check file json")
                        Utils.showToastDebug(
                            activity,
                            "not support adType ${adsChild.adsType} check file json"
                        )
                        false
                    }
                }
                return checkShow
            }
            adCallback?.onAdFailToLoad("more than one hour")
            return false
        }
        return false
    }


//    fun show(
//        activity: Activity,
//        adsChild: AdsChild,
//        loadingText: String?,
//        layout: ViewGroup?,
//        layoutAds: View?,
//        lifecycle: Lifecycle?,
//        adCallback: AdCallback?,
//        timeDelayShowAd: Int = 0,
//    ): Boolean {
//        return show(activity, adsChild, loadingText, layout, layoutAds, lifecycle, adCallback)
//    }

    fun showLoadedAd(
        activity: Activity,
        adsChild: AdsChild,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle?,
        timeMillisecond: Long?,
        adCallback: AdCallback?
    ) {
//        val key = (adsChild.adsType + adsChild.spaceName).lowercase(Locale.getDefault())
        val adsIds = adsChild.adsIds.sortedWith(compareBy { it.priority })
        var ads: AdmobAds? = null
        var adUnitId = ""
        adsIds.forEach {
            Log.d(TAG, "showLoadedAd: ${it.id},  ${it.priority}")
            val key = (adsChild.adsType + adsChild.spaceName + it.priority).lowercase(Locale.ROOT)
            val admobAds = hashMap[key]
            if (admobAds != null) {
                if (admobAds.getStateLoadAd() == StateLoadAd.SUCCESS || admobAds.getStateLoadAd() == StateLoadAd.LOADING){
                    adUnitId = it.id
                    ads = admobAds
                }
            }
        }
        Log.d(
            TAG,
            "showLoadedAd: ${ads != null} ${ads?.isDestroy()} ${ads?.wasLoadTimeLessThanNHoursAgo(1)}"
        )
        if (ads != null) {
            if (!ads!!.isDestroy() && ads!!.wasLoadTimeLessThanNHoursAgo(1)) {
                if (ads!!.getStateLoadAd() == StateLoadAd.SUCCESS) {
                    Log.d(TAG, "showLoadedAd: showed 4")
                    ads?.show(
                        activity,
                        adUnitId,
                        loadingText,
                        layout,
                        layoutAds,
                        lifecycle,
                        adCallback
                    )
                } else {
                    Log.d(TAG, "showLoadedAd: 2")
                    if (ads?.getStateLoadAd() == StateLoadAd.LOADING) {
                        ads!!.setPreloadCallback(object : PreloadCallback {
                            override fun onLoadDone() {
                                ads!!.show(
                                    activity,
                                    adUnitId,
                                    loadingText,
                                    layout,
                                    layoutAds,
                                    lifecycle,
                                    adCallback
                                )
                            }

                            override fun onLoadFail() {
                                adCallback?.onAdFailToLoad("")
                            }
                        })
                    } else {
                        Log.d(TAG, "showLoadedAd: 6")
                        loadAndShow(
                            activity,
                            adsChild,
                            loadingText,
                            layout,
                            layoutAds,
                            lifecycle,
                            timeMillisecond,
                            adCallback
                        )
                    }
                }
            } else {
                Log.d(TAG, "showLoadedAd: 3")

                loadAndShow(
                    activity,
                    adsChild,
                    loadingText,
                    layout,
                    layoutAds,
                    lifecycle,
                    timeMillisecond,
                    adCallback
                )
            }
        }
    }

    fun destroy(adsChild: AdsChild) {
        val adsIds = adsChild.adsIds.sortedBy { it.priority }
        adsIds.forEach { adsId ->
            val key =
                (adsChild.adsType + adsChild.spaceName + adsId.priority).lowercase(Locale.ROOT)
            val admobAds: AdmobAds? = hashMap[key]
            admobAds?.destroy()
            this.hashMap.remove(key)
        }
    }

    fun remove(adsChild: AdsChild) {
        val adsIds = adsChild.adsIds.sortedBy { it.priority }
        adsIds.forEach { adsId ->
            val key =
                (adsChild.adsType + adsChild.spaceName + adsId.priority).lowercase(Locale.ROOT)
            this.hashMap.remove(key)
        }
    }

    fun getStatusPreload(adsChild: AdsChild): StateLoadAd {
        var stateLoadAd:StateLoadAd = StateLoadAd.NULL
        val adsIds = adsChild.adsIds.sortedBy { it.priority }
        adsIds.forEach { adsId ->
            val key =
                (adsChild.adsType + adsChild.spaceName + adsId.priority).lowercase(Locale.ROOT)
            hashMap[key]?.let {
                Log.d(TAG, "getStatusPreload: ${it.getStateLoadAd()}")
                if (it.getStateLoadAd() == StateLoadAd.LOADING || it.getStateLoadAd() == StateLoadAd.SUCCESS || it.getStateLoadAd() == StateLoadAd.HAS_BEEN_OPENED) {
                    return it.getStateLoadAd()
                }
                stateLoadAd = it.getStateLoadAd()
            }
        }
        return stateLoadAd
    }
}
