package io.pica.ads.admob.ads

import android.app.Activity
import android.graphics.Color
import android.util.DisplayMetrics
import android.util.Log
import android.view.View
import android.view.ViewGroup
import androidx.core.os.bundleOf
import androidx.lifecycle.Lifecycle
import com.google.android.gms.ads.*
import io.pica.ads.AdCallback
import io.pica.ads.PreloadCallback
import io.pica.ads.utils.AdDef
import io.pica.ads.utils.Constant
import io.pica.ads.utils.StateLoadAd
import io.pica.ads.utils.Utils
import java.util.*


class AdmobAdaptiveBanner : AdmobAds() {
    private var isLoadSuccess = false
    private var adView: AdView? = null
    private var callback: AdCallback? = null
    private var callbackPreload:PreloadCallback? = null
    private var stateLoadAd:StateLoadAd = StateLoadAd.NONE
    override fun loadAndShow(
        activity: Activity,
        idAds:String,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle?,
        timeMillisecond: Long?,
        adCallback: AdCallback?
    ) {

        Log.d("beta", "AdmobAdaptiveBanner loadAndShow: $idAds")
        callback = adCallback
        load(activity, idAds, layout, callback, loadSuccess = {
            Log.d("beta", "AdmobAdaptiveBanner loadAndShow: loadSuccess $idAds")
            show(activity, idAds, loadingText, layout, layoutAds,lifecycle ,callback)
        })
    }

    override fun show(
        activity: Activity,
        idAds:String,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle?,
        adCallback: AdCallback?
    ): Boolean {
        callback = adCallback
        if (adView != null && layout != null) {
            Log.d("beta", "AdmobAdaptiveBanner show: $idAds")
            try {
                adView?.adListener = object : AdListener() {

                    override fun onAdOpened() {
                        super.onAdOpened()
                        Utils.showToastDebug(activity, "Admob AdaptBanner: $idAds")
                        callback?.onAdClick()
                    }

                    override fun onAdClosed() {
                        super.onAdClosed()
                        callback?.onAdClose(AdDef.NETWORK.GOOGLE)
                    }

                    override fun onAdFailedToLoad(p0: LoadAdError) {
                        super.onAdFailedToLoad(p0)
                        Utils.showToastDebug(activity, "Admob AdaptBanner: ${p0.message}")
                        callback?.onAdFailToLoad(p0.message)
                    }

                    override fun onAdImpression() {
                        super.onAdImpression()
                        callback?.onAdImpression(AdDef.ADS_TYPE.BANNER_ADAPTIVE)
                    }

                    override fun onAdLoaded() {
                        super.onAdLoaded()
                        isLoadSuccess = true
                        timeLoader = Date().time
                    }

                    override fun onAdSwipeGestureClicked() {
                        super.onAdSwipeGestureClicked()
                    }

                    override fun onAdClicked() {
                        super.onAdClicked()
                        callback?.onAdClick()
                    }
                }
                callback?.onAdShow(AdDef.NETWORK.GOOGLE, AdDef.ADS_TYPE.BANNER)
                layout.removeAllViews()
                if (adView?.parent != null) {
                    (adView?.parent as ViewGroup).removeView(adView) // <- fix
                }
                Log.d("beta", "AdmobAdaptiveBanner show: add view")
                layout.addView(adView)
            } catch (_: Exception) {
            }

            return true
        } else {
            Log.d("beta", "AdmobAdaptiveBanner show: layout ad native null")
            Utils.showToastDebug(activity, "layout ad native not null")
        }
        return false
    }

    override fun setPreloadCallback(preloadCallback: PreloadCallback?) {
        callbackPreload = preloadCallback
    }

    override fun preload(activity: Activity, idAds:String) {
        Log.d("beta", "preload: $idAds")
        load(activity, idAds, null,null, loadSuccess = {})
    }

    private fun load(
        activity: Activity,
        idAds:String,
        layout: ViewGroup?,
        adCallback: AdCallback?,
        loadSuccess: () -> Unit
    ) {
        Log.d("beta", "AdmobAdaptiveBanner load: $idAds")
        callback = adCallback
        val id: String = if (Constant.isDebug) Constant.ID_ADMOB_BANNER_TEST else idAds
        stateLoadAd = StateLoadAd.LOADING
        isLoadSuccess = false
        adView = AdView(activity)
        adView?.setBackgroundColor(Color.WHITE)
        adView?.adUnitId = id

        val widthContainer = layout?.width ?: 320
        val adSize = getAnchoredAdaptiveAdSize(activity, widthContainer)
        adSize.let {
            adView?.setAdSize(it)
        }

        layout?.let { viewG ->
            val lp = viewG.layoutParams
            lp.width = adSize.getWidthInPixels(viewG.context) ?: 0
            lp.height = adSize.getHeightInPixels(viewG.context) ?: 0
            viewG.layoutParams = lp
        }


        adView?.loadAd(
            AdRequest.Builder().build()
        )
        adView?.onPaidEventListener = OnPaidEventListener { adValue ->
            try {
                val bundle = bundleOf(
                    "revenue_micros" to adValue.valueMicros.toString(),
                    "precision_type" to adValue.precisionType.toString(),
                    "currency_code" to adValue.currencyCode,
                    "ad_unit_id" to id,
                    "ad_source_id" to adView?.responseInfo?.loadedAdapterResponseInfo?.adSourceId,
                    "ad_source_name" to adView?.responseInfo?.loadedAdapterResponseInfo?.adSourceName
                )
                adCallback?.onPaidEvent(bundle,adValue)
            }catch (_: Exception) {
            }

        }
        adView?.adListener = object : AdListener() {

            override fun onAdOpened() {
                super.onAdOpened()
                Utils.showToastDebug(activity, "Admob AdapBanner: onAdOpened $idAds")
                callback?.onAdClick()
            }

            override fun onAdClosed() {
                super.onAdClosed()
                callback?.onAdClose(AdDef.NETWORK.GOOGLE)
            }


            override fun onAdFailedToLoad(p0: LoadAdError) {
                super.onAdFailedToLoad(p0)
                Utils.showToastDebug(activity, "Admob AdapBanner: onAdFailedToLoad ${p0.message}")
                callback?.onAdFailToLoad(p0.message)
                stateLoadAd = StateLoadAd.FAILED
                callbackPreload?.onLoadFail()
            }

            override fun onAdLoaded() {
                super.onAdLoaded()
                stateLoadAd = StateLoadAd.SUCCESS
                isLoadSuccess = true
                callbackPreload?.onLoadDone()
                Log.d("beta", "AdmobAdaptiveBanner loaded: $idAds")
                loadSuccess()

                timeLoader = Date().time
            }

            override fun onAdImpression() {
                super.onAdImpression()
                callback?.onAdImpression(AdDef.ADS_TYPE.BANNER_ADAPTIVE)
                Log.d("beta", "AdmobAdaptiveBanner onAdImpression: ")
            }
        }

    }

    private fun getAnchoredAdaptiveAdSize(activity: Activity, width: Int =320): AdSize {
        val display = activity.windowManager.defaultDisplay
        val outMetrics = DisplayMetrics()
        display.getMetrics(outMetrics)
        val widthPixels = outMetrics.widthPixels.toFloat()
        val density = outMetrics.density
        val adWidth = if (width==0) (widthPixels / density).toInt() else width
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize(activity, if (width==0) adWidth else width)
    }

    override fun destroy() {
        adView = null
        isLoadSuccess = false
    }

    override fun isDestroy(): Boolean {
        return adView == null
    }

    override fun isLoaded(): Boolean {
        return isLoadSuccess
    }

    override fun getStateLoadAd(): StateLoadAd {
        return stateLoadAd
    }

}