package io.pica.ads.admob.ads

import android.app.Activity
import android.graphics.Color
import android.os.Bundle
import android.util.DisplayMetrics
import android.util.Log
import android.view.View
import android.view.ViewGroup
import androidx.core.os.bundleOf
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.lifecycle.LifecycleOwner
import com.google.ads.mediation.admob.AdMobAdapter
import com.google.android.gms.ads.*
import io.pica.ads.AdCallback
import io.pica.ads.PreloadCallback
import io.pica.ads.utils.AdDef
import io.pica.ads.utils.Constant
import io.pica.ads.utils.StateLoadAd
import io.pica.ads.utils.Utils
import java.util.*


class AdmobCollapsibleBanner(val isShowBottom: Boolean) : AdmobAds() {
    private var isLoadSuccess = false
    private var adView: AdView? = null
    private var callback: AdCallback? = null
    private var callbackPreload:PreloadCallback? = null
    private var stateLoadAd:StateLoadAd = StateLoadAd.NONE
    override fun loadAndShow(
        activity: Activity,
        idAds:String,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle?,
        timeMillisecond: Long?,
        adCallback: AdCallback?
    ) {
        callback = adCallback
        load(activity, idAds, layout, callback, loadSuccess = {
            show(activity, idAds, loadingText, layout, layoutAds,lifecycle ,callback)
        })
    }

    override fun show(
        activity: Activity,
        idAds:String,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle?,
        adCallback: AdCallback?
    ): Boolean {
        callback = adCallback
        if (adView != null && layout != null) {
            try {
                adView?.adListener = object : AdListener() {

                    override fun onAdOpened() {
                        super.onAdOpened()
                        Utils.showToastDebug(activity, "Admob CollapsibleBanner: $idAds")
                        callback?.onAdClick()
                    }

                    override fun onAdClosed() {
                        super.onAdClosed()
                        callback?.onAdClose(AdDef.NETWORK.GOOGLE)
                    }

                    override fun onAdFailedToLoad(p0: LoadAdError) {
                        super.onAdFailedToLoad(p0)
                        Utils.showToastDebug(activity, "Admob CollapsibleBanner: ${p0.message}")
                        callback?.onAdFailToLoad(p0.message)
                    }

                    override fun onAdImpression() {
                        super.onAdImpression()
                        callback?.onAdImpression(AdDef.ADS_TYPE.BANNER_COLLAPSIBLE)
                    }

                    override fun onAdLoaded() {
                        super.onAdLoaded()
                        isLoadSuccess = true
                        timeLoader = Date().time
                    }

                    override fun onAdClicked() {
                        super.onAdClicked()
                        callback?.onAdClick()
                    }
                }
                callback?.onAdShow(AdDef.NETWORK.GOOGLE, AdDef.ADS_TYPE.BANNER_COLLAPSIBLE)
                layout.removeAllViews()
                if (adView?.parent != null) {
                    (adView?.parent as ViewGroup).removeView(adView) // <- fix
                }
                layout.addView(adView)
                lifecycle?.addObserver(object :LifecycleEventObserver{
                    override fun onStateChanged(source: LifecycleOwner, event: Lifecycle.Event) {
                        if (event == Lifecycle.Event.ON_DESTROY) {
                            adView?.destroy()
                        }
                    }
                })
            } catch (_: Exception) {
            }

            return true
        } else {
            Utils.showToastDebug(activity, "layout ad native not null")
        }
        return false
    }

    override fun setPreloadCallback(preloadCallback: PreloadCallback?) {
        callbackPreload = preloadCallback
    }

    override fun preload(activity: Activity, idAds:String) {
        Log.d("preload", "preload: $idAds")
        load(activity, idAds, null,null, loadSuccess = {

        })
    }

    private fun load(
        activity: Activity,
        idAds:String,
        layout: ViewGroup?,
        adCallback: AdCallback?,
        loadSuccess: () -> Unit
    ) {
        callback = adCallback
        val id: String = if (Constant.isDebug) Constant.ID_ADMOB_BANNER_COLLAPSIVE_TEST else idAds
        stateLoadAd = StateLoadAd.LOADING
        isLoadSuccess = false
        adView = AdView(activity)
        adView?.setBackgroundColor(Color.WHITE)
        adView?.adUnitId = id


        val adSize = getAdsize(activity)
        adSize.let {
            adView?.setAdSize(it)
        }

        layout?.let { viewG ->
            val lp = viewG.layoutParams
            lp.width = adSize.getWidthInPixels(viewG.context)
            lp.height = adSize.getHeightInPixels(viewG.context)
            viewG.layoutParams = lp
        }

        val extras = Bundle()
        extras.putString("collapsible", if (isShowBottom) "bottom" else "top")
        extras.putString("collapsible_request_id", UUID.randomUUID().toString())

        adView?.loadAd(
            AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter::class.java, extras).build()
        )
        adView?.onPaidEventListener = OnPaidEventListener { adValue ->
            try {
                val bundle = bundleOf(
                    "revenue_micros" to adValue.valueMicros.toString(),
                    "precision_type" to adValue.precisionType.toString(),
                    "currency_code" to adValue.currencyCode,
                    "ad_unit_id" to id,
                    "ad_source_id" to adView?.responseInfo?.loadedAdapterResponseInfo?.adSourceId,
                    "ad_source_name" to adView?.responseInfo?.loadedAdapterResponseInfo?.adSourceName
                )
                adCallback?.onPaidEvent(bundle,adValue)
            }catch (_: Exception) {
            }

        }
        adView?.adListener = object : AdListener() {

            override fun onAdOpened() {
                super.onAdOpened()
                Utils.showToastDebug(activity, "Admob AdapBanner: $idAds")
                callback?.onAdClick()
            }

            override fun onAdClosed() {
                super.onAdClosed()
                callback?.onAdClose(AdDef.NETWORK.GOOGLE)
            }


            override fun onAdFailedToLoad(p0: LoadAdError) {
                super.onAdFailedToLoad(p0)
                Utils.showToastDebug(activity, "Admob AdapBanner: ${p0.message}")
                callback?.onAdFailToLoad(p0.message)
                stateLoadAd = StateLoadAd.FAILED
                callbackPreload?.onLoadFail()
            }

            override fun onAdLoaded() {
                super.onAdLoaded()
                stateLoadAd = StateLoadAd.SUCCESS
                isLoadSuccess = true
                callbackPreload?.onLoadDone()
                loadSuccess()
                timeLoader = Date().time
            }

            override fun onAdImpression() {
                super.onAdImpression()
                callback?.onAdImpression(AdDef.ADS_TYPE.BANNER_COLLAPSIBLE)
                Log.d("beta", "AdmobAdaptiveBanner onAdImpression: ")
            }
        }

    }

    private fun getAdsize(activity: Activity): AdSize {
        val display = activity.windowManager.defaultDisplay
        val outMetrics = DisplayMetrics()
        display.getMetrics(outMetrics)
        val widthPixels = outMetrics.widthPixels.toFloat()
        val density = outMetrics.density
        val adWidth = (widthPixels / density).toInt()
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize(
            activity,
            adWidth
        )
    }

    override fun destroy() {
        adView = null
        isLoadSuccess = false
    }

    override fun isDestroy(): Boolean {
        return adView == null
    }

    override fun isLoaded(): Boolean {
        return isLoadSuccess
    }

    override fun getStateLoadAd(): StateLoadAd {
        return stateLoadAd
    }

}