package io.pica.ads.admob.ads

import android.app.Activity
import android.app.Dialog
import android.os.Handler
import android.os.Looper
import android.util.Log
import android.view.View
import android.view.ViewGroup
import androidx.core.os.bundleOf
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.lifecycle.LifecycleOwner
import com.google.android.gms.ads.AdActivity
import com.google.android.gms.ads.AdError
import com.google.android.gms.ads.AdRequest
import com.google.android.gms.ads.FullScreenContentCallback
import com.google.android.gms.ads.LoadAdError
import com.google.android.gms.ads.appopen.AppOpenAd
import com.google.android.gms.ads.appopen.AppOpenAd.AppOpenAdLoadCallback
import io.pica.ads.AdCallback
import io.pica.ads.AdsController
import io.pica.ads.PreloadCallback
import io.pica.ads.R
import io.pica.ads.utils.AdDef
import io.pica.ads.utils.Constant
import io.pica.ads.utils.StateLoadAd
import io.pica.ads.utils.Utils
import java.util.Date

class AdmobOpenAdsResume : AdmobAds() {
    private var callback: AdCallback? = null
    private var callbackPreload: PreloadCallback? = null

    private var timeClick = 0L
    private var error: String? = null
    private var isTimeOut = false
    private var handler = Handler(Looper.getMainLooper())
    private var loadFailed = false
    private var loaded: Boolean = false

    private var preload: Boolean = false

    private var eventLifecycle: Lifecycle.Event = Lifecycle.Event.ON_RESUME
    private var appOpenAd: AppOpenAd? = null
    private var currentActivity: Activity? = null

    private var lifecycle: Lifecycle? = null
    private var stateLoadAd:StateLoadAd = StateLoadAd.NONE
    val TAG = "AdmobOpenAdsResume"

    private var dialogLoading: Dialog? = null

    private fun showDialogLoading(activity: Activity) {
        dismissDialog()
        dialogLoading = Dialog(activity, android.R.style.Theme_Black_NoTitleBar_Fullscreen)
        dialogLoading?.setCancelable(true)
        dialogLoading?.requestWindowFeature(android.view.Window.FEATURE_NO_TITLE)
        dialogLoading?.setContentView(R.layout.dialog_text_loading)
        dialogLoading?.show()
    }

    private fun dismissDialog() {
        Log.d(TAG, "dismissDialog: ")
        kotlin.runCatching {
            if (dialogLoading?.isShowing==true){
                dialogLoading?.dismiss()
            }
        }.onFailure { it.printStackTrace() }


//        try {
//            if (dialogLoading?.isShowing?.not() == true) {
//                dialogLoading?.dismiss()
//            }
//        } catch (_: Exception) {
//            Log.d(TAG, "dismissDialog: remove dialog error")
//        }
    }

    override fun loadAndShow(
        activity: Activity,
        idAds: String,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle?,
        timeMillisecond: Long?,
        adCallback: AdCallback?
    ) {
        Log.d(TAG, "loadAndShow: ")
        this.callback = adCallback
        currentActivity = activity
        preload = false
        load(
            activity,
            idAds,
            lifecycle,
            timeMillisecond ?: Constant.TIME_OUT_DEFAULT,
            adCallback
        )
    }

    override fun preload(activity: Activity, idAds: String) {
        Log.d(TAG, "preload: $idAds")
        preload = true
        load(activity, idAds)
    }

    override fun show(
        activity: Activity,
        idAds: String,
        loadingText: String?,
        layout: ViewGroup?,
        layoutAds: View?,
        lifecycle: Lifecycle?,
        adCallback: AdCallback?
    ): Boolean {
        this.callback = adCallback
        currentActivity = activity
//        showDialogLoading(activity)
//        dismissDialog()
        if (loaded && appOpenAd != null) {
            showDialogLoading(activity)
            appOpenAd?.show(activity)
            return true
        }
        return false
    }

    private val timeOutCallBack = Runnable {
        if (!loaded && !loadFailed) {
            isTimeOut = true
            if (eventLifecycle == Lifecycle.Event.ON_RESUME) {
                callback?.onAdFailToLoad("TimeOut")
                lifecycle?.removeObserver(lifecycleObserver)
                dismissDialog()
            }
        }
    }

    private fun load(
        activity: Activity,
        idAds: String,
        lifecycle: Lifecycle? = null,
        timeOut: Long = Constant.TIME_OUT_DEFAULT,
        adCallback: AdCallback? = null
    ) {
        this.lifecycle = lifecycle
        this.callback = adCallback
        stateLoadAd = StateLoadAd.LOADING
        timeClick = System.currentTimeMillis()
        val adUnitID = if (Constant.isDebug) Constant.ID_ADMOB_OPEN_APP_TEST else idAds
        if (!preload) {
            showDialogLoading(activity)
            lifecycle?.addObserver(lifecycleObserver)
            handler.removeCallbacks(timeOutCallBack)
            handler.postDelayed(timeOutCallBack, timeOut)
        }
        Log.d(TAG, "load: $preload")
        resetValue()
        val openAdLoadCallback = object : AppOpenAdLoadCallback() {
            override fun onAdLoaded(p0: AppOpenAd) {
                Log.d(TAG, "onAdLoaded: 1")
                appOpenAd = p0
                appOpenAd?.setOnPaidEventListener { adValue ->
                    kotlin.runCatching {
                        val bundle = bundleOf(
                            "revenue_micros" to adValue.valueMicros.toString(),
                            "precision_type" to adValue.precisionType.toString(),
                            "currency_code" to adValue.currencyCode,
                            "ad_unit_id" to adUnitID,
                            "ad_source_id" to appOpenAd?.responseInfo?.loadedAdapterResponseInfo?.adSourceId,
                            "ad_source_name" to appOpenAd?.responseInfo?.loadedAdapterResponseInfo?.adSourceName
                        )
                        adCallback?.onPaidEvent(bundle,adValue)
                    }
                }
                appOpenAd?.fullScreenContentCallback =
                    object : FullScreenContentCallback() {

                        override fun onAdImpression() {
                            super.onAdImpression()
                            Log.d(TAG, "onAdImpression: ")
                            adCallback?.onAdImpression(AdDef.ADS_TYPE.OPEN_APP)
                        }

                        override fun onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent()
                            Log.d(TAG, "onAdDismissedFullScreenContent: ")
                            callback?.onAdClose(AdDef.ADS_TYPE.OPEN_APP)
                            appOpenAd = null
                            dismissDialog()

                            //// perform your code that you wants to do after ad dismissed or closed
                        }

                        override fun onAdFailedToShowFullScreenContent(adError: AdError) {
                            super.onAdFailedToShowFullScreenContent(adError)
                            Log.d(TAG, "onAdFailedToShowFullScreenContent: ${adError.message}")
                            appOpenAd = null
                            loadFailed = true
                            error = adError.message
                            callback?.onAdFailToShow(adError.message)
                            lifecycle?.removeObserver(lifecycleObserver)
                            dismissDialog()

                            /// perform your action here when ad will not load
                        }

                        override fun onAdClicked() {
                            super.onAdClicked()
                            callback?.onAdClick()
                            when {
                                AdsController.mTopActivity != null && AdsController.mTopActivity is AdActivity -> {
                                    AdsController.mTopActivity?.finish()
                                }
                            }
                        }

                        override fun onAdShowedFullScreenContent() {
                            super.onAdShowedFullScreenContent()
                            Log.d(TAG, "onAdShowedFullScreenContent: ")
                            appOpenAd = null
                            Utils.showToastDebug(
                                activity,
                                "Admob OpenAds id: $adUnitID"
                            )
                            stateLoadAd = StateLoadAd.HAS_BEEN_OPENED
                            callback?.onAdShow(
                                AdDef.NETWORK.GOOGLE,
                                AdDef.ADS_TYPE.OPEN_APP
                            )
                        }
                    }
                if (!isTimeOut && eventLifecycle == Lifecycle.Event.ON_RESUME && !preload) {
                    currentActivity?.let { appOpenAd?.show(it) }
                    lifecycle?.removeObserver(lifecycleObserver)
                }
                loaded = true
                timeLoader = Date().time
                Log.d(TAG, "onAdLoaded: 2")
                stateLoadAd = StateLoadAd.SUCCESS
                callbackPreload?.onLoadDone()
            }

            override fun onAdFailedToLoad(p0: LoadAdError) {
                super.onAdFailedToLoad(p0)
                loadFailed = true
                error = p0.message
                if (eventLifecycle == Lifecycle.Event.ON_RESUME && !preload) {
                    lifecycle?.removeObserver(lifecycleObserver)
                    if (!isTimeOut) {
                        callback?.onAdFailToLoad(p0.message)
                        dismissDialog()
                    }
                }
                stateLoadAd = StateLoadAd.FAILED
                callbackPreload?.onLoadFail()
                dismissDialog()
            }
        }
        val request: AdRequest = AdRequest.Builder()
            .build()
        AppOpenAd.load(
            activity,
            adUnitID,
            request,
            openAdLoadCallback
        )

    }

    private val lifecycleObserver = object : LifecycleEventObserver {
        override fun onStateChanged(source: LifecycleOwner, event: Lifecycle.Event) {
            eventLifecycle = event
            if (event == Lifecycle.Event.ON_RESUME) {
                if (isTimeOut) {
                    callback?.onAdFailToLoad("TimeOut")
                    lifecycle?.removeObserver(this)
                    dismissDialog()
                } else if (loadFailed || loaded) {
                    if (loaded) {
                        currentActivity?.let { appOpenAd?.show(it) }
                    } else {
                        callback?.onAdFailToLoad(error)
                        dismissDialog()
                        Log.d(TAG, "dismissDialog: ")
                    }
                    lifecycle?.removeObserver(this)
                }
            }
        }
    }

    private fun resetValue() {
        loaded = false
        loadFailed = false
        error = null
    }


    override fun isDestroy(): Boolean {
        return appOpenAd == null
    }

    override fun isLoaded(): Boolean {
        return loaded
    }

    override fun destroy() {
        appOpenAd = null
    }

    override fun getStateLoadAd(): StateLoadAd {
        return stateLoadAd
    }

    override fun setPreloadCallback(preloadCallback: PreloadCallback?) {
        callbackPreload = preloadCallback
    }
}