package io.pica.ads.utils

import android.app.ProgressDialog
import android.content.Context
import android.util.Log
import android.view.View
import android.view.animation.LinearInterpolator
import android.view.animation.RotateAnimation
import android.widget.ImageView
import android.widget.TextView
import com.afollestad.materialdialogs.MaterialDialog
import com.afollestad.materialdialogs.customview.customView
import com.afollestad.materialdialogs.customview.getCustomView
import io.pica.ads.R

class AdDialog {
    companion object{
        private var mSelf: AdDialog? = null
        private var mProgressDialog: ProgressDialog? = null
        private var dialogLoading: MaterialDialog? = null
        fun getInstance(): AdDialog {
            if (mSelf == null) {
                mSelf = AdDialog()
            }
            return mSelf!!
        }

    }


    fun showLoadingWithMessage(
        context: Context?,
        message: String?
    ) {
        try {
            if (context != null&&message != null) {
                Log.i("1111111111","vao0")
                if (dialogLoading == null) {
                    Log.i("1111111111","vao1")
                    dialogLoading = MaterialDialog(context).apply {
                        cancelable(false)
                        customView(R.layout.dialog_loading_ads)
                        getCustomView().findViewById<TextView>(R.id.tvLoading).text = message
                        val viewRotate = getCustomView().findViewById<ImageView>(R.id.imvLoading)
                        animRotation(viewRotate)
                    }
                    dialogLoading!!.show {
                        cornerRadius(10f)
                    }
                }
            }
        } catch (_: Exception) {
        }
    }

    fun hideLoading() {
        try {
            if (dialogLoading != null ) {
                dialogLoading?.dismiss()
                dialogLoading = null
            }
        } catch (_: Exception) {
        }
    }

    private fun animRotation(view: View) {
        val rotateAnimation = RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f)
        rotateAnimation.interpolator = LinearInterpolator()
        rotateAnimation.duration = 1500
        rotateAnimation.isFillEnabled = true
        rotateAnimation.repeatCount = -1
        rotateAnimation.fillAfter = true
        view.startAnimation(rotateAnimation)
    }
}