/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicators;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.wang.avi.Indicator;
import java.util.ArrayList;

public class AudioEqualizerIndicator
extends Indicator {
    private static final int BAR_COUNT = 4;
    private float[] scaleFloats = new float[4];

    public AudioEqualizerIndicator() {
        for (int i = 0; i < 4; ++i) {
            this.scaleFloats[i] = 0.5f;
        }
    }

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float barWidth = (float)this.getWidth() / 9.0f;
        float spacing = barWidth / 2.0f;
        float totalBarsWidth = 4.0f * barWidth + 3.0f * spacing;
        float startX = ((float)this.getWidth() - totalBarsWidth) / 2.0f;
        float maxBarHeight = (float)this.getHeight() * 0.8f;
        float bottom = (float)this.getHeight() - (float)this.getHeight() * 0.1f;
        for (int i = 0; i < 4; ++i) {
            float x = startX + (float)i * (barWidth + spacing);
            float barHeight = maxBarHeight * this.scaleFloats[i];
            float top = bottom - barHeight;
            canvas.drawRect(x, top, x + barWidth, bottom, paint);
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        int[] durations = new int[]{4300, 2500, 1700, 3100};
        float[] values = new float[]{0.0f, 0.7f, 0.4f, 0.05f, 0.95f, 0.3f, 0.9f, 0.4f, 0.15f, 0.18f, 0.75f, 0.01f};
        for (int i = 0; i < 4; ++i) {
            final int index = i;
            ValueAnimator heightAnim = ValueAnimator.ofFloat((float[])values);
            heightAnim.setDuration((long)durations[i]);
            heightAnim.setRepeatCount(-1);
            this.addUpdateListener(heightAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((AudioEqualizerIndicator)AudioEqualizerIndicator.this).scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    AudioEqualizerIndicator.this.postInvalidate();
                }
            });
            animators.add(heightAnim);
        }
        return animators;
    }
}

