/*
 * Decompiled with CFR 0.152.
 */
package com.liang.nansheng.common.utils;

import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CommonUtils {
    public static List<String> stringToList(String str, String separator) {
        return StringUtils.isBlank((CharSequence)str) ? Collections.emptyList() : Arrays.asList(str.split(separator));
    }

    public static List<Integer> stringListToIntegerList(List<String> stringList) {
        return stringList.stream().map(str -> Integer.valueOf(str.trim())).collect(Collectors.toList());
    }

    public static List<Long> stringListToLongList(List<String> stringList) {
        return stringList.stream().map(str -> Long.parseLong(str.trim())).collect(Collectors.toList());
    }

    public static String byteConversion(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + units[digitGroups];
    }

    public static String html2Text(String html) {
        String htmlStr = html;
        String textStr = "";
        try {
            String regExScript = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
            String regExStyle = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
            String regExHtml = "<[^>]+>";
            Pattern pScript = Pattern.compile(regExScript, 2);
            Matcher mScript = pScript.matcher(htmlStr);
            htmlStr = mScript.replaceAll("");
            Pattern pStyle = Pattern.compile(regExStyle, 2);
            Matcher mStyle = pStyle.matcher(htmlStr);
            htmlStr = mStyle.replaceAll("");
            Pattern pHtml = Pattern.compile(regExHtml, 2);
            Matcher mHtml = pHtml.matcher(htmlStr);
            textStr = htmlStr = mHtml.replaceAll("");
        }
        catch (Exception e) {
            System.err.println("Html2Text: " + e.getMessage());
        }
        textStr = textStr.replaceAll("[ ]+", " ");
        textStr = textStr.replaceAll("(?m)^\\s*$(\\n|\\r\\n)", "");
        return textStr;
    }

    public static LocalDateTime getCurrentStartTime() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(11, 0);
        currentDate.set(12, 0);
        currentDate.set(13, 0);
        return currentDate.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime getYesterdayStartTime() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(11, -24);
        currentDate.set(12, 0);
        currentDate.set(13, 0);
        return currentDate.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime getCurrentEndTime() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(11, 23);
        currentDate.set(12, 59);
        currentDate.set(13, 59);
        return currentDate.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

