/*
 * Decompiled with CFR 0.152.
 */
package com.liang.nansheng.common.web.basic;

import com.liang.nansheng.common.enums.ResponseCode;

public class ResponseResult<T> {
    private Integer code;
    private String desc;
    private T data;

    public static <T> ResponseResult<T> success(T data) {
        return ResponseResult.builder().code(ResponseCode.SUCCESS.getCode()).desc(ResponseCode.SUCCESS.getDesc()).data(data).build();
    }

    public static <T> ResponseResult<T> build(ResponseCode responseCode, T data) {
        return ResponseResult.builder().code(responseCode.getCode()).desc(responseCode.getDesc()).data(data).build();
    }

    public static <T> ResponseResultBuilder<T> builder() {
        return new ResponseResultBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseResult)) {
            return false;
        }
        ResponseResult other = (ResponseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseResult(code=" + this.getCode() + ", desc=" + this.getDesc() + ", data=" + this.getData() + ")";
    }

    public ResponseResult() {
    }

    public ResponseResult(Integer code, String desc, T data) {
        this.code = code;
        this.desc = desc;
        this.data = data;
    }

    public static class ResponseResultBuilder<T> {
        private Integer code;
        private String desc;
        private T data;

        ResponseResultBuilder() {
        }

        public ResponseResultBuilder<T> code(Integer code) {
            this.code = code;
            return this;
        }

        public ResponseResultBuilder<T> desc(String desc) {
            this.desc = desc;
            return this;
        }

        public ResponseResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ResponseResult<T> build() {
            return new ResponseResult<T>(this.code, this.desc, this.data);
        }

        public String toString() {
            return "ResponseResult.ResponseResultBuilder(code=" + this.code + ", desc=" + this.desc + ", data=" + this.data + ")";
        }
    }
}

