/*
 * Decompiled with CFR 0.152.
 */
package io.github.manoelcampos.accessors;

import io.github.manoelcampos.accessors.GetterMatcher;
import io.github.manoelcampos.accessors.SetterMatcher;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

class InstanceFieldMatcher
extends ElementMatcher.Junction.AbstractBase<FieldDescription> {
    private final AccessorLookup accessorLookup;
    private FieldDescription fieldDescription;
    private final TypeDescription typeDescription;

    InstanceFieldMatcher(AccessorLookup accessorLookup, TypeDescription typeDescription) {
        this.accessorLookup = accessorLookup;
        this.typeDescription = typeDescription;
    }

    public boolean matches(FieldDescription field) {
        boolean matches;
        boolean isFieldAccessOutsideDeclaringClass = !field.getDeclaringType().equals((Object)this.typeDescription);
        boolean bl = matches = isFieldAccessOutsideDeclaringClass && InstanceFieldMatcher.isPublicInstanceField(field) && this.isAccessorMethodFound(field);
        if (matches) {
            this.fieldDescription = field;
        }
        return matches;
    }

    private static boolean isPublicInstanceField(FieldDescription fieldDescription) {
        return ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic())).matches((Object)fieldDescription);
    }

    private boolean isAccessorMethodFound(FieldDescription field) {
        return field.getDeclaringType().getDeclaredMethods().stream().anyMatch(m -> this.isAccessorForField(field, (MethodDescription)m));
    }

    private boolean isAccessorForField(FieldDescription field, MethodDescription method) {
        boolean accessorNameMatchesField = method.getName().equals(this.accessorLookup.forGetter() ? GetterMatcher.getterName(field) : SetterMatcher.setterName(field));
        return accessorNameMatchesField && (this.accessorLookup.forGetter() ? ElementMatchers.isGetter().matches((Object)method) : ElementMatchers.isSetter().matches((Object)method));
    }

    public FieldDescription getFieldDescription() {
        return this.fieldDescription;
    }

    static enum AccessorLookup {
        GETTER,
        SETTER;


        boolean forGetter() {
            return this == GETTER;
        }
    }
}

