/*
 * Decompiled with CFR 0.152.
 */
package nl.jworks.markdown_to_asciidoc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nl.jworks.markdown_to_asciidoc.code.Linguist;
import nl.jworks.markdown_to_asciidoc.html.TableToAsciiDoc;
import nl.jworks.markdown_to_asciidoc.util.Joiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.pegdown.LinkRenderer;
import org.pegdown.Printer;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.AbstractNode;
import org.pegdown.ast.AnchorLinkNode;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.BlockQuoteNode;
import org.pegdown.ast.BulletListNode;
import org.pegdown.ast.CodeNode;
import org.pegdown.ast.DefinitionListNode;
import org.pegdown.ast.DefinitionNode;
import org.pegdown.ast.DefinitionTermNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.HtmlBlockNode;
import org.pegdown.ast.InlineHtmlNode;
import org.pegdown.ast.ListItemNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.OrderedListNode;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.QuotedNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SimpleNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.StrikeNode;
import org.pegdown.ast.StrongEmphSuperNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TableBodyNode;
import org.pegdown.ast.TableCaptionNode;
import org.pegdown.ast.TableCellNode;
import org.pegdown.ast.TableColumnNode;
import org.pegdown.ast.TableHeaderNode;
import org.pegdown.ast.TableNode;
import org.pegdown.ast.TableRowNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.VerbatimNode;
import org.pegdown.ast.Visitor;
import org.pegdown.ast.WikiLinkNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u008a\u00012\u00020\u0001:\u0002\u008a\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0004J\u001a\u0010C\u001a\u0004\u0018\u00010B2\u0006\u0010D\u001a\u00020B2\u0006\u0010E\u001a\u00020BH\u0004J\u0016\u0010F\u001a\u00020\u00052\f\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HH\u0002J\u0016\u0010J\u001a\u00020\f2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HH\u0002J\u0018\u0010K\u001a\u00020\f2\u0006\u0010L\u001a\u00020B2\u0006\u0010M\u001a\u00020BH\u0004J\u0010\u0010N\u001a\u00020\f2\u0006\u0010A\u001a\u00020BH\u0004J\u0010\u0010O\u001a\u00020\u00052\u0006\u0010P\u001a\u00020\u0005H\u0004J\u0010\u0010Q\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u0005H\u0004J\u0010\u0010S\u001a\u00020\u00052\u0006\u0010A\u001a\u00020TH\u0004J\u0010\u0010U\u001a\u00020@2\u0006\u0010V\u001a\u00020WH\u0004J\u0018\u0010X\u001a\u00020@2\u0006\u0010Y\u001a\u00020W2\u0006\u0010Z\u001a\u00020WH\u0004J\u0010\u0010[\u001a\u00020@2\u0006\u0010V\u001a\u00020WH\u0004J\u0018\u0010\\\u001a\u00020@2\u0006\u0010A\u001a\u00020]2\u0006\u0010^\u001a\u00020\u0005H\u0004J\u001a\u0010_\u001a\u00020@2\u0006\u0010`\u001a\u0002072\b\u0010R\u001a\u0004\u0018\u00010\u0005H\u0004J\u0010\u0010a\u001a\u00020@2\u0006\u0010P\u001a\u00020\u0005H\u0004J\u0018\u0010b\u001a\u00020@2\u0006\u0010c\u001a\u0002012\u0006\u0010d\u001a\u00020\u0012H\u0002J\u0006\u0010e\u001a\u00020\u0005J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020gH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020hH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020iH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020jH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020kH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020lH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020mH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020nH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020oH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020pH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020qH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020rH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020sH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020tH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020uH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020vH\u0016J\u0010\u0010f\u001a\u00020w2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020xH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020yH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020zH\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020{H\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020|H\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020=H\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0003H\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020}H\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020~H\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020\u007fH\u0016J\u0011\u0010f\u001a\u00020@2\u0007\u0010A\u001a\u00030\u0080\u0001H\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020TH\u0016J\u0011\u0010f\u001a\u00020@2\u0007\u0010A\u001a\u00030\u0081\u0001H\u0016J\u0011\u0010f\u001a\u00020@2\u0007\u0010A\u001a\u00030\u0082\u0001H\u0016J\u0011\u0010f\u001a\u00020@2\u0007\u0010A\u001a\u00030\u0083\u0001H\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020IH\u0016J\u0011\u0010f\u001a\u00020@2\u0007\u0010A\u001a\u00030\u0084\u0001H\u0016J\u0010\u0010f\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001bH\u0016J\u0011\u0010f\u001a\u00020@2\u0007\u0010A\u001a\u00030\u0085\u0001H\u0016J\u0011\u0010f\u001a\u00020@2\u0007\u0010A\u001a\u00030\u0086\u0001H\u0016J\u0011\u0010f\u001a\u00020@2\u0007\u0010A\u001a\u00030\u0087\u0001H\u0016J\u0011\u0010f\u001a\u00020@2\u0007\u0010A\u001a\u00030\u0088\u0001H\u0016J\u0011\u0010\u0089\u0001\u001a\u00020@2\u0006\u0010A\u001a\u00020]H\u0004R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000e\"\u0004\b\"\u0010\u0010R\u001a\u0010#\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0014\"\u0004\b/\u0010\u0016R\u001a\u00100\u001a\u000201X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R \u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020=0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008b\u0001"}, d2={"Lnl/jworks/markdown_to_asciidoc/ToAsciiDocSerializerKt;", "Lorg/pegdown/ast/Visitor;", "rootNode", "Lorg/pegdown/ast/RootNode;", "source", "", "(Lorg/pegdown/ast/RootNode;Ljava/lang/String;)V", "abbreviations", "", "getAbbreviations", "()Ljava/util/Map;", "autoDetectLanguageType", "", "getAutoDetectLanguageType", "()Z", "setAutoDetectLanguageType", "(Z)V", "blockQuoteLevel", "", "getBlockQuoteLevel", "()I", "setBlockQuoteLevel", "(I)V", "currentTableColumn", "getCurrentTableColumn", "setCurrentTableColumn", "currentTableNode", "Lorg/pegdown/ast/TableNode;", "getCurrentTableNode", "()Lorg/pegdown/ast/TableNode;", "setCurrentTableNode", "(Lorg/pegdown/ast/TableNode;)V", "inTableHeader", "getInTableHeader", "setInTableHeader", "linguist", "Lnl/jworks/markdown_to_asciidoc/code/Linguist;", "getLinguist", "()Lnl/jworks/markdown_to_asciidoc/code/Linguist;", "setLinguist", "(Lnl/jworks/markdown_to_asciidoc/code/Linguist;)V", "linkRenderer", "Lorg/pegdown/LinkRenderer;", "getLinkRenderer", "()Lorg/pegdown/LinkRenderer;", "listLevel", "getListLevel", "setListLevel", "listMarker", "", "getListMarker", "()C", "setListMarker", "(C)V", "printer", "Lorg/pegdown/Printer;", "getPrinter", "()Lorg/pegdown/Printer;", "setPrinter", "(Lorg/pegdown/Printer;)V", "references", "Lorg/pegdown/ast/ReferenceNode;", "getReferences", "cleanAst", "", "node", "Lorg/pegdown/ast/Node;", "findParentNode", "target", "from", "getColumnAlignment", "columns", "", "Lorg/pegdown/ast/TableColumnNode;", "ifColumnsHaveAlignmentSpecified", "isFirstChild", "parent", "child", "isListItemText", "normalize", "string", "normalizeWhitelines", "text", "printChildrenToString", "Lorg/pegdown/ast/SuperNode;", "printImageTag", "rendering", "Lorg/pegdown/LinkRenderer$Rendering;", "printImageTagWithLink", "image", "link", "printLink", "printNodeSurroundedBy", "Lorg/pegdown/ast/AbstractNode;", "token", "printTextWithQuotesIfNeeded", "p", "printWithAbbreviations", "repeat", "c", "times", "toAsciiDoc", "visit", "Lorg/pegdown/ast/AbbreviationNode;", "Lorg/pegdown/ast/AnchorLinkNode;", "Lorg/pegdown/ast/AutoLinkNode;", "Lorg/pegdown/ast/BlockQuoteNode;", "Lorg/pegdown/ast/BulletListNode;", "Lorg/pegdown/ast/CodeNode;", "Lorg/pegdown/ast/DefinitionListNode;", "Lorg/pegdown/ast/DefinitionNode;", "Lorg/pegdown/ast/DefinitionTermNode;", "Lorg/pegdown/ast/ExpImageNode;", "Lorg/pegdown/ast/ExpLinkNode;", "Lorg/pegdown/ast/HeaderNode;", "Lorg/pegdown/ast/HtmlBlockNode;", "Lorg/pegdown/ast/InlineHtmlNode;", "Lorg/pegdown/ast/ListItemNode;", "Lorg/pegdown/ast/MailLinkNode;", "", "Lorg/pegdown/ast/OrderedListNode;", "Lorg/pegdown/ast/ParaNode;", "Lorg/pegdown/ast/QuotedNode;", "Lorg/pegdown/ast/RefImageNode;", "Lorg/pegdown/ast/RefLinkNode;", "Lorg/pegdown/ast/SimpleNode;", "Lorg/pegdown/ast/SpecialTextNode;", "Lorg/pegdown/ast/StrikeNode;", "Lorg/pegdown/ast/StrongEmphSuperNode;", "Lorg/pegdown/ast/TableBodyNode;", "Lorg/pegdown/ast/TableCaptionNode;", "Lorg/pegdown/ast/TableCellNode;", "Lorg/pegdown/ast/TableHeaderNode;", "Lorg/pegdown/ast/TableRowNode;", "Lorg/pegdown/ast/TextNode;", "Lorg/pegdown/ast/VerbatimNode;", "Lorg/pegdown/ast/WikiLinkNode;", "visitChildren", "Companion", "markdown-to-asciidoc"})
@SourceDebugExtension(value={"SMAP\nKotlinSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSerializer.kt\nnl/jworks/markdown_to_asciidoc/ToAsciiDocSerializerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,628:1\n1747#2,3:629\n1855#2,2:632\n107#3:634\n79#3,22:635\n*S KotlinDebug\n*F\n+ 1 KotlinSerializer.kt\nnl/jworks/markdown_to_asciidoc/ToAsciiDocSerializerKt\n*L\n346#1:629,3\n440#1:632,2\n528#1:634\n528#1:635,22\n*E\n"})
public final class ToAsciiDocSerializerKt
implements Visitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private RootNode rootNode;
    @NotNull
    private String source;
    @NotNull
    private Printer printer;
    @NotNull
    private final Map<String, ReferenceNode> references;
    @NotNull
    private final Map<String, String> abbreviations;
    @NotNull
    private final LinkRenderer linkRenderer;
    @Nullable
    private TableNode currentTableNode;
    private int currentTableColumn;
    private boolean inTableHeader;
    private char listMarker;
    private int listLevel;
    private int blockQuoteLevel;
    private boolean autoDetectLanguageType;
    @NotNull
    private Linguist linguist;
    @NotNull
    private static final String HARD_LINE_BREAK_MARKDOWN = "  \n";

    @JvmOverloads
    public ToAsciiDocSerializerKt(@NotNull RootNode rootNode, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.rootNode = rootNode;
        this.source = source;
        this.printer = new Printer();
        this.references = new HashMap();
        this.abbreviations = new HashMap();
        this.linkRenderer = new LinkRenderer();
        this.listMarker = (char)32;
        this.linguist = new Linguist();
        this.printer = new Printer();
        this.linguist = new Linguist();
        this.autoDetectLanguageType = false;
        Preconditions.checkArgNotNull((Object)this.rootNode, (String)"rootNode");
    }

    @NotNull
    protected final Printer getPrinter() {
        return this.printer;
    }

    protected final void setPrinter(@NotNull Printer printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"<set-?>");
        this.printer = printer;
    }

    @NotNull
    protected final Map<String, ReferenceNode> getReferences() {
        return this.references;
    }

    @NotNull
    protected final Map<String, String> getAbbreviations() {
        return this.abbreviations;
    }

    @NotNull
    protected final LinkRenderer getLinkRenderer() {
        return this.linkRenderer;
    }

    @Nullable
    protected final TableNode getCurrentTableNode() {
        return this.currentTableNode;
    }

    protected final void setCurrentTableNode(@Nullable TableNode tableNode) {
        this.currentTableNode = tableNode;
    }

    protected final int getCurrentTableColumn() {
        return this.currentTableColumn;
    }

    protected final void setCurrentTableColumn(int n) {
        this.currentTableColumn = n;
    }

    protected final boolean getInTableHeader() {
        return this.inTableHeader;
    }

    protected final void setInTableHeader(boolean bl) {
        this.inTableHeader = bl;
    }

    protected final char getListMarker() {
        return this.listMarker;
    }

    protected final void setListMarker(char c) {
        this.listMarker = c;
    }

    protected final int getListLevel() {
        return this.listLevel;
    }

    protected final void setListLevel(int n) {
        this.listLevel = n;
    }

    protected final int getBlockQuoteLevel() {
        return this.blockQuoteLevel;
    }

    protected final void setBlockQuoteLevel(int n) {
        this.blockQuoteLevel = n;
    }

    protected final boolean getAutoDetectLanguageType() {
        return this.autoDetectLanguageType;
    }

    protected final void setAutoDetectLanguageType(boolean bl) {
        this.autoDetectLanguageType = bl;
    }

    @NotNull
    protected final Linguist getLinguist() {
        return this.linguist;
    }

    protected final void setLinguist(@NotNull Linguist linguist) {
        Intrinsics.checkNotNullParameter((Object)linguist, (String)"<set-?>");
        this.linguist = linguist;
    }

    @NotNull
    public final String toAsciiDoc() {
        this.cleanAst((Node)this.rootNode);
        this.rootNode.accept((Visitor)this);
        String string = this.printer.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String result = this.normalizeWhitelines(string);
        this.printer.clear();
        return result;
    }

    public void visit(@NotNull RootNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (ReferenceNode refNode : node.getReferences()) {
            Intrinsics.checkNotNull((Object)refNode);
            this.visitChildren((AbstractNode)refNode);
            String string = this.printer.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.references.put(this.normalize(string), refNode);
            this.printer.clear();
        }
        for (AbbreviationNode abbrNode : node.getAbbreviations()) {
            Intrinsics.checkNotNull((Object)abbrNode);
            this.visitChildren((AbstractNode)abbrNode);
            String abbr = this.printer.getString();
            this.printer.clear();
            abbrNode.getExpansion().accept((Visitor)this);
            String expansion = this.printer.getString();
            Intrinsics.checkNotNull((Object)abbr);
            Intrinsics.checkNotNull((Object)expansion);
            this.abbreviations.put(abbr, expansion);
            this.printer.clear();
        }
        this.visitChildren((AbstractNode)node);
    }

    public void visit(@NotNull AbbreviationNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
    }

    public void visit(@NotNull AnchorLinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.print(node.getText());
    }

    public void visit(@NotNull AutoLinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LinkRenderer.Rendering rendering = this.linkRenderer.render(node);
        Intrinsics.checkNotNullExpressionValue((Object)rendering, (String)"render(...)");
        this.printLink(rendering);
    }

    public void visit(@NotNull BlockQuoteNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.println().println();
        this.blockQuoteLevel += 4;
        this.repeat('_', this.blockQuoteLevel);
        this.printer.println();
        this.visitChildren((AbstractNode)node);
        this.printer.println().println();
        this.repeat('_', this.blockQuoteLevel);
        this.blockQuoteLevel -= 4;
        this.printer.println();
    }

    public void visit(@NotNull BulletListNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        char prevListMarker = this.listMarker;
        this.listMarker = (char)42;
        ++this.listLevel;
        this.visitChildren((AbstractNode)node);
        --this.listLevel;
        this.listMarker = prevListMarker;
    }

    public void visit(@NotNull CodeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.print('`');
        this.printer.printEncoded(node.getText());
        this.printer.print('`');
    }

    public void visit(@NotNull DefinitionListNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.println();
        this.visitChildren((AbstractNode)node);
    }

    public void visit(@NotNull DefinitionTermNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.visitChildren((AbstractNode)node);
        this.printer.indent(2);
        this.printer.print("::").println();
    }

    public void visit(@NotNull DefinitionNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.visitChildren((AbstractNode)node);
        if (this.printer.indent > 0) {
            this.printer.indent(-2);
        }
        this.printer.println();
    }

    public void visit(@NotNull ExpImageNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String text = this.printChildrenToString((SuperNode)node);
        LinkRenderer.Rendering imageRenderer = this.linkRenderer.render(node, text);
        Node linkNode = this.findParentNode((Node)node, (Node)this.rootNode);
        if (linkNode instanceof ExpLinkNode) {
            Intrinsics.checkNotNull((Object)imageRenderer);
            LinkRenderer.Rendering rendering = this.linkRenderer.render((ExpLinkNode)linkNode, null);
            Intrinsics.checkNotNullExpressionValue((Object)rendering, (String)"render(...)");
            this.printImageTagWithLink(imageRenderer, rendering);
        } else {
            LinkRenderer.Rendering rendering = this.linkRenderer.render(node, text);
            Intrinsics.checkNotNullExpressionValue((Object)rendering, (String)"render(...)");
            this.printImageTag(rendering);
        }
    }

    public void visit(@NotNull ExpLinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String text = this.printChildrenToString((SuperNode)node);
        if (StringsKt.startsWith$default((String)text, (String)"image:", (boolean)false, (int)2, null)) {
            this.printer.print(text);
        } else {
            LinkRenderer.Rendering rendering = this.linkRenderer.render(node, text);
            Intrinsics.checkNotNullExpressionValue((Object)rendering, (String)"render(...)");
            this.printLink(rendering);
        }
    }

    public void visit(@NotNull HeaderNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.println().println();
        this.repeat('=', node.getLevel());
        this.printer.print(' ');
        this.visitChildren((AbstractNode)node);
        this.printer.println().println();
    }

    private final void repeat(char c, int times) {
        for (int i = 0; i < times; ++i) {
            this.printer.print(c);
        }
    }

    public void visit(@NotNull HtmlBlockNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        if (((CharSequence)text).length() > 0) {
            this.printer.println();
        }
        if (StringsKt.startsWith$default((String)text, (String)"<table", (boolean)false, (int)2, null)) {
            this.printer.print(TableToAsciiDoc.convert(text));
            this.printer.println();
        }
    }

    public void visit(@NotNull InlineHtmlNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.print(node.getText());
    }

    public void visit(@NotNull ListItemNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.println();
        this.repeat(this.listMarker, this.listLevel);
        this.printer.print(" ");
        this.visitChildren((AbstractNode)node);
    }

    public void visit(@NotNull MailLinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LinkRenderer.Rendering rendering = this.linkRenderer.render(node);
        Intrinsics.checkNotNullExpressionValue((Object)rendering, (String)"render(...)");
        this.printLink(rendering);
    }

    public void visit(@NotNull OrderedListNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        char prevListMarker = this.listMarker;
        this.listMarker = (char)46;
        ++this.listLevel;
        this.visitChildren((AbstractNode)node);
        --this.listLevel;
        this.listMarker = prevListMarker;
    }

    public void visit(@NotNull ParaNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!this.isListItemText((Node)node)) {
            this.printer.println().println();
        }
        this.visitChildren((AbstractNode)node);
        this.printer.println().println();
    }

    public void visit(@NotNull QuotedNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        QuotedNode.Type type = node.getType();
        Intrinsics.checkNotNull((Object)type);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                this.printer.print("\u00ab");
                this.visitChildren((AbstractNode)node);
                this.printer.print("\u00bb");
                break;
            }
            case 2: {
                this.printer.print("\"");
                this.visitChildren((AbstractNode)node);
                this.printer.print("\"");
                break;
            }
            case 3: {
                this.printer.print("'");
                this.visitChildren((AbstractNode)node);
                this.printer.print("'");
            }
        }
    }

    public void visit(@NotNull ReferenceNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
    }

    public void visit(@NotNull RefImageNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String text = this.printChildrenToString((SuperNode)node);
        if (node.referenceKey != null) {
            SuperNode superNode = node.referenceKey;
            Intrinsics.checkNotNullExpressionValue((Object)superNode, (String)"referenceKey");
            string = this.printChildrenToString(superNode);
        } else {
            string = text;
        }
        String key = string;
        ReferenceNode refNode = this.references.get(this.normalize(key));
        if (refNode == null) {
            this.printer.print("![").print(text).print(']');
            if (node.separatorSpace != null) {
                this.printer.print(node.separatorSpace).print('[');
                if (node.referenceKey != null) {
                    this.printer.print(key);
                }
                this.printer.print(']');
            }
        } else {
            LinkRenderer.Rendering rendering = this.linkRenderer.render(node, refNode.getUrl(), refNode.getTitle(), text);
            Intrinsics.checkNotNullExpressionValue((Object)rendering, (String)"render(...)");
            this.printImageTag(rendering);
        }
    }

    public void visit(@NotNull RefLinkNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String text = this.printChildrenToString((SuperNode)node);
        if (node.referenceKey != null) {
            SuperNode superNode = node.referenceKey;
            Intrinsics.checkNotNullExpressionValue((Object)superNode, (String)"referenceKey");
            string = this.printChildrenToString(superNode);
        } else {
            string = text;
        }
        String key = string;
        ReferenceNode refNode = this.references.get(this.normalize(key));
        if (refNode == null) {
            this.printer.print('[').print(text).print(']');
            if (node.separatorSpace != null) {
                this.printer.print(node.separatorSpace).print('[');
                if (node.referenceKey != null) {
                    this.printer.print(key);
                }
                this.printer.print(']');
            }
        } else {
            LinkRenderer.Rendering rendering = this.linkRenderer.render(node, refNode.getUrl(), refNode.getTitle(), text);
            Intrinsics.checkNotNullExpressionValue((Object)rendering, (String)"render(...)");
            this.printLink(rendering);
        }
    }

    public void visit(@NotNull SimpleNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        SimpleNode.Type type = node.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                this.printer.print("'");
                break;
            }
            case 2: {
                this.printer.print("\u2026");
                break;
            }
            case 3: {
                this.printer.print("\u2014");
                break;
            }
            case 4: {
                this.printer.print("\u2013");
                break;
            }
            case 5: {
                this.printer.println().print("'''");
                break;
            }
            case 6: {
                String string = this.source.substring(node.getStartIndex(), node.getEndIndex());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                if (StringsKt.startsWith$default((String)string, (String)HARD_LINE_BREAK_MARKDOWN, (boolean)false, (int)2, null)) {
                    this.printer.print(" +").println();
                    break;
                }
                this.printer.println();
                break;
            }
            case 7: {
                this.printer.print("{nbsp}");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void visit(@NotNull StrongEmphSuperNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.isClosed()) {
            if (node.isStrong()) {
                this.printNodeSurroundedBy((AbstractNode)node, "*");
            } else {
                this.printNodeSurroundedBy((AbstractNode)node, "_");
            }
        } else {
            this.printer.print(node.getChars());
            this.visitChildren((AbstractNode)node);
        }
    }

    public void visit(@NotNull StrikeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.print("[line-through]").print('#');
        this.visitChildren((AbstractNode)node);
        this.printer.print('#');
    }

    public void visit(@NotNull TableBodyNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.visitChildren((AbstractNode)node);
    }

    public void visit(@NotNull TableCaptionNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.println().print("<caption>");
        this.visitChildren((AbstractNode)node);
        this.printer.print("</caption>");
    }

    public void visit(@NotNull TableCellNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        TableNode tableNode = this.currentTableNode;
        Intrinsics.checkNotNull((Object)tableNode);
        List columns = tableNode.getColumns();
        TableColumnNode column = (TableColumnNode)columns.get(Math.min(this.currentTableColumn, columns.size() - 1));
        String pstr = this.printer.getString();
        Intrinsics.checkNotNull((Object)pstr);
        if (((CharSequence)pstr).length() > 0) {
            if (StringsKt.endsWith$default((String)pstr, (String)"\n", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)pstr, (String)" ", (boolean)false, (int)2, null)) {
                this.printer.print("|");
            } else {
                this.printer.print(" |");
            }
        } else {
            this.printer.print("|");
        }
        column.accept((Visitor)this);
        if (node.getColSpan() > 1) {
            this.printer.print(" colspan=\"").print(Integer.toString(node.getColSpan())).print('\"');
        }
        this.visitChildren((AbstractNode)node);
        this.currentTableColumn += node.getColSpan();
    }

    public void visit(@NotNull TableColumnNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
    }

    public void visit(@NotNull TableHeaderNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.inTableHeader = true;
        this.visitChildren((AbstractNode)node);
        this.inTableHeader = false;
    }

    private final boolean ifColumnsHaveAlignmentSpecified(List<? extends TableColumnNode> columns) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = columns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TableColumnNode it = (TableColumnNode)element$iv;
                    boolean bl2 = false;
                    if (!(it.getAlignment() != TableColumnNode.Alignment.None)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String getColumnAlignment(List<? extends TableColumnNode> columns) {
        ArrayList<String> result = new ArrayList<String>();
        block5: for (TableColumnNode tableColumnNode : columns) {
            TableColumnNode.Alignment alignment = tableColumnNode.getAlignment();
            switch (alignment == null ? -1 : WhenMappings.$EnumSwitchMapping$2[alignment.ordinal()]) {
                case 1: 
                case 2: {
                    result.add("<");
                    continue block5;
                }
                case 3: {
                    result.add(">");
                    continue block5;
                }
                case 4: {
                    result.add("^");
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        String string = Joiner.join((List)result, ",");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }

    public void visit(@NotNull TableNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.currentTableNode = node;
        List columns = node.getColumns();
        Intrinsics.checkNotNull((Object)columns);
        if (this.ifColumnsHaveAlignmentSpecified(columns)) {
            this.printer.println();
            this.printer.print("[cols=\"");
            this.printer.print(this.getColumnAlignment(columns));
            this.printer.print("\"]");
            this.printer.println();
        } else {
            this.printer.println();
        }
        this.printer.print("|===");
        this.visitChildren((AbstractNode)node);
        this.printer.println();
        this.printer.print("|===");
        this.printer.println();
        this.currentTableNode = null;
    }

    public void visit(@NotNull TableRowNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.currentTableColumn = 0;
        this.printer.println();
        this.visitChildren((AbstractNode)node);
        if (this.inTableHeader) {
            this.printer.println();
        }
    }

    public void visit(@NotNull VerbatimNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.println();
        String type = node.getType();
        String text = node.getText();
        if (this.autoDetectLanguageType) {
            type = this.linguist.detectLanguage(text);
        }
        String string = type;
        Intrinsics.checkNotNull((Object)string);
        if (!(((CharSequence)string).length() == 0)) {
            this.printer.print("[source," + type + ']');
        }
        this.printer.println();
        this.repeat('-', 4);
        this.printer.println();
        this.printer.print(text);
        this.repeat('-', 4);
        this.printer.println().println();
    }

    public void visit(@NotNull WikiLinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LinkRenderer.Rendering rendering = this.linkRenderer.render(node);
        Intrinsics.checkNotNullExpressionValue((Object)rendering, (String)"render(...)");
        this.printLink(rendering);
    }

    public void visit(@NotNull TextNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.abbreviations.isEmpty()) {
            this.printer.print(node.getText());
        } else {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.printWithAbbreviations(string);
        }
    }

    public void visit(@NotNull SpecialTextNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.printer.printEncoded(node.getText());
    }

    public void visit(@NotNull SuperNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.visitChildren((AbstractNode)node);
    }

    @NotNull
    public Void visit(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        throw new RuntimeException("Don't know how to handle node " + node);
    }

    protected final void visitChildren(@NotNull AbstractNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List list = node.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.accept((Visitor)this);
        }
    }

    protected final void cleanAst(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List children = node.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Node c = (Node)children.get(i);
            if (c instanceof RootNode && ((RootNode)c).getChildren().size() == 1) {
                children.set(i, ((RootNode)c).getChildren().get(0));
            } else if (Intrinsics.areEqual(c.getClass(), SuperNode.class) && c.getChildren().size() == 1) {
                children.set(i, c.getChildren().get(0));
            }
            Intrinsics.checkNotNull((Object)c);
            this.cleanAst(c);
        }
    }

    protected final void printNodeSurroundedBy(@NotNull AbstractNode node, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.printer.print(token);
        this.visitChildren(node);
        this.printer.print(token);
    }

    protected final void printImageTag(@NotNull LinkRenderer.Rendering rendering) {
        Intrinsics.checkNotNullParameter((Object)rendering, (String)"rendering");
        this.printer.print("image:");
        this.printer.print(rendering.href);
        this.printer.print('[');
        this.printTextWithQuotesIfNeeded(this.printer, rendering.text);
        this.printer.print(']');
    }

    protected final void printImageTagWithLink(@NotNull LinkRenderer.Rendering image, @NotNull LinkRenderer.Rendering link) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.printer.print("image:").print(image.href).print('[');
        if (image.text != null) {
            String string = image.text;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            if (!(((CharSequence)string).length() == 0)) {
                this.printTextWithQuotesIfNeeded(this.printer, image.text);
                this.printer.print(',');
            }
        }
        this.printer.print("link=").print(link.href).print(']');
    }

    protected final void printLink(@NotNull LinkRenderer.Rendering rendering) {
        Intrinsics.checkNotNullParameter((Object)rendering, (String)"rendering");
        String uri = rendering.href;
        String text = rendering.text;
        String string = uri;
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.startsWith$default((String)string, (String)"#", (boolean)false, (int)2, null)) {
            Printer printer = this.printer.print("<<");
            string = uri;
            Intrinsics.checkNotNull((Object)string);
            int n = 1;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            printer.print(string2).print(',').print(text).print(">>");
        } else {
            string = uri;
            Intrinsics.checkNotNull((Object)string);
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"://", (boolean)false, (int)2, null)) {
                uri = "link:" + uri;
            }
            this.printer.print(uri);
            if (!Intrinsics.areEqual((Object)uri, (Object)text)) {
                this.printer.print('[');
                this.printTextWithQuotesIfNeeded(this.printer, rendering.text);
                this.printer.print(']');
            }
        }
    }

    @NotNull
    protected final String printChildrenToString(@NotNull SuperNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Printer priorPrinter = this.printer;
        this.printer = new Printer();
        this.visitChildren((AbstractNode)node);
        String result = this.printer.getString();
        this.printer = priorPrinter;
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    @NotNull
    protected final String normalize(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        StringBuilder sb = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            char c2 = c;
            if ((c2 == ' ' ? true : c2 == '\n') ? true : c2 == '\t') continue;
            sb.append(Character.toLowerCase(c));
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    protected final String normalizeWhitelines(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        Regex regex = new Regex("(?m)^[ \t]*\r?\n{2,}");
        String string = "\n";
        String $this$trim$iv = regex.replace(charSequence, string);
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    protected final void printTextWithQuotesIfNeeded(@NotNull Printer p, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (text != null && !(((CharSequence)text).length() == 0)) {
            if (StringsKt.contains$default((CharSequence)text, (CharSequence)",", (boolean)false, (int)2, null)) {
                p.print('\"').print(text).print('\"');
            } else {
                p.print(text);
            }
        }
    }

    protected final void printWithAbbreviations(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Map expansions = null;
        for (Map.Entry<String, String> entry : this.abbreviations.entrySet()) {
            int sx;
            String abbr = entry.getKey();
            int ix = 0;
            while ((sx = StringsKt.indexOf$default((CharSequence)string, (String)abbr, (int)ix, (boolean)false, (int)4, null)) != -1) {
                ix = sx + abbr.length();
                if (sx > 0 && Character.isLetterOrDigit(string.charAt(sx - 1)) || ix < string.length() && Character.isLetterOrDigit(string.charAt(ix))) continue;
                if (expansions == null) {
                    expansions = new TreeMap();
                }
                expansions.put(sx, entry);
            }
        }
        if (expansions != null) {
            int ix = 0;
            for (Map.Entry entry : expansions.entrySet()) {
                int sx = ((Number)entry.getKey()).intValue();
                Map.Entry value = (Map.Entry)entry.getValue();
                String abbr = (String)value.getKey();
                String expansion = (String)value.getValue();
                String string2 = string.substring(ix, sx);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                this.printer.printEncoded(string2);
                this.printer.print("<abbr");
                if (StringUtils.isNotEmpty((String)expansion)) {
                    this.printer.print(" title=\"");
                    this.printer.printEncoded(expansion);
                    this.printer.print('\"');
                }
                this.printer.print('>');
                this.printer.printEncoded(abbr);
                this.printer.print("</abbr>");
                ix = sx + abbr.length();
            }
            String string3 = string.substring(ix);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            this.printer.print(string3);
        } else {
            this.printer.print(string);
        }
    }

    @Nullable
    protected final Node findParentNode(@NotNull Node target, @NotNull Node from) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (Intrinsics.areEqual((Object)target, (Object)this.rootNode)) {
            return null;
        }
        for (Node c : from.getChildren()) {
            Intrinsics.checkNotNull((Object)c);
            Node candidate = this.findParentNode(target, c);
            if (Intrinsics.areEqual((Object)target, (Object)c)) {
                return from;
            }
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    protected final boolean isFirstChild(@NotNull Node parent, @NotNull Node child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return Intrinsics.areEqual((Object)child, parent.getChildren().get(0));
    }

    protected final boolean isListItemText(@NotNull Node node) {
        Node parent;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.listLevel == 0 ? false : (parent = this.findParentNode(node, (Node)this.rootNode)) instanceof ListItemNode && this.isFirstChild(parent, node);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnl/jworks/markdown_to_asciidoc/ToAsciiDocSerializerKt$Companion;", "", "()V", "HARD_LINE_BREAK_MARKDOWN", "", "getHARD_LINE_BREAK_MARKDOWN", "()Ljava/lang/String;", "markdown-to-asciidoc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getHARD_LINE_BREAK_MARKDOWN() {
            return HARD_LINE_BREAK_MARKDOWN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[QuotedNode.Type.values().length];
            try {
                nArray[QuotedNode.Type.DoubleAngle.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuotedNode.Type.Double.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuotedNode.Type.Single.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SimpleNode.Type.values().length];
            try {
                nArray[SimpleNode.Type.Apostrophe.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleNode.Type.Ellipsis.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleNode.Type.Emdash.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleNode.Type.Endash.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleNode.Type.HRule.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleNode.Type.Linebreak.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleNode.Type.Nbsp.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TableColumnNode.Alignment.values().length];
            try {
                nArray[TableColumnNode.Alignment.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableColumnNode.Alignment.Left.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableColumnNode.Alignment.Right.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableColumnNode.Alignment.Center.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

