/*
 * Decompiled with CFR 0.152.
 */
package nl.pojoquery;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import nl.pojoquery.DbContext;
import nl.pojoquery.SqlExpression;
import nl.pojoquery.util.Strings;

public interface DB {
    public static final /* synthetic */ int[] $SWITCH_TABLE$nl$pojoquery$DB$QueryType;

    public static List<Map<String, Object>> queryRows(Connection connection, SqlExpression queryStatement) {
        return DB.execute(connection, QueryType.SELECT, queryStatement.getSql(), queryStatement.getParameters(), new RowProcessor());
    }

    public static List<Map<String, Object>> queryRows(DataSource db, SqlExpression queryStatement) {
        return DB.execute(db, QueryType.SELECT, queryStatement.getSql(), queryStatement.getParameters(), new RowProcessor());
    }

    public static List<Map<String, Object>> queryRows(Connection connection, String sql, Object ... params) {
        return DB.execute(connection, QueryType.SELECT, sql, Arrays.asList(params), new RowProcessor());
    }

    public static List<Map<String, Object>> queryRows(DataSource db, String sql, Object ... params) {
        return DB.execute(db, QueryType.SELECT, sql, Arrays.asList(params), new RowProcessor());
    }

    public static void queryRowsStreaming(Connection conn, SqlExpression queryStatement, Consumer<Map<String, Object>> rowCallback) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PreparedStatement stmt = conn.prepareStatement(queryStatement.getSql());){
                DB.applyParameters(queryStatement.getParameters(), stmt);
                stmt.setFetchSize(Integer.MIN_VALUE);
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (ResultSet rs = stmt.executeQuery();){
                    List<String> fieldNames = DB.extractResultSetFieldNames(rs);
                    while (rs.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>(fieldNames.size());
                        for (String fieldName : fieldNames) {
                            row.put(fieldName, rs.getObject(fieldName));
                        }
                        rowCallback.accept(row);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public static void queryRowsStreaming(DataSource db, SqlExpression queryStatement, Consumer<Map<String, Object>> rowCallback) {
        Connection connection = null;
        try {
            try {
                connection = db.getConnection();
                DB.queryRowsStreaming(connection, queryStatement, rowCallback);
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static Columns queryColumns(Connection conn, String sql, Object ... params) {
        return new Columns(DB.execute(conn, QueryType.SELECT, sql, Arrays.asList(params), new ColumnProcessor()));
    }

    public static Columns queryColumns(DataSource db, String sql, Object ... params) {
        return new Columns(DB.execute(db, QueryType.SELECT, sql, Arrays.asList(params), new ColumnProcessor()));
    }

    public static int update(DataSource db, String schemaName, String tableName, Map<String, Object> values, Map<String, Object> ids) {
        SqlExpression updateSql = DB.buildUpdate(DbContext.getDefault(), schemaName, tableName, values, ids);
        return (Integer)DB.execute(db, QueryType.UPDATE, updateSql.getSql(), updateSql.getParameters(), null);
    }

    public static int update(DataSource db, String tableName, Map<String, Object> values, Map<String, Object> ids) {
        SqlExpression updateSql = DB.buildUpdate(DbContext.getDefault(), null, tableName, values, ids);
        return (Integer)DB.execute(db, QueryType.UPDATE, updateSql.getSql(), updateSql.getParameters(), null);
    }

    public static int update(Connection connection, String tableName, Map<String, Object> values, Map<String, Object> ids) {
        SqlExpression updateSql = DB.buildUpdate(DbContext.getDefault(), null, tableName, values, ids);
        return (Integer)DB.execute(connection, QueryType.UPDATE, updateSql.getSql(), updateSql.getParameters(), null);
    }

    public static int update(Connection connection, String schemaName, String tableName, Map<String, Object> values, Map<String, Object> ids) {
        SqlExpression updateSql = DB.buildUpdate(DbContext.getDefault(), schemaName, tableName, values, ids);
        return (Integer)DB.execute(connection, QueryType.UPDATE, updateSql.getSql(), updateSql.getParameters(), null);
    }

    public static int update(DataSource db, SqlExpression update) {
        return (Integer)DB.execute(db, QueryType.UPDATE, update.getSql(), update.getParameters(), null);
    }

    public static int update(Connection conn, SqlExpression update) {
        return (Integer)DB.execute(conn, QueryType.UPDATE, update.getSql(), update.getParameters(), null);
    }

    public static <PK> PK insert(DataSource db, String schemaName, String tableName, Map<String, ? extends Object> values) {
        SqlExpression insertSql = DB.buildInsertOrUpdate(DbContext.getDefault(), schemaName, tableName, values, false);
        return (PK)DB.execute(db, QueryType.INSERT, insertSql.getSql(), insertSql.getParameters(), null);
    }

    public static <PK> PK insert(DataSource db, String tableName, Map<String, ? extends Object> values) {
        SqlExpression insertSql = DB.buildInsertOrUpdate(DbContext.getDefault(), null, tableName, values, false);
        return (PK)DB.execute(db, QueryType.INSERT, insertSql.getSql(), insertSql.getParameters(), null);
    }

    public static <PK> PK insert(Connection connection, String schemaName, String tableName, Map<String, ? extends Object> values) {
        SqlExpression insertSql = DB.buildInsertOrUpdate(DbContext.getDefault(), schemaName, tableName, values, false);
        return (PK)DB.execute(connection, QueryType.INSERT, insertSql.getSql(), insertSql.getParameters(), null);
    }

    public static <PK> PK insert(Connection connection, String tableName, Map<String, ? extends Object> values) {
        SqlExpression insertSql = DB.buildInsertOrUpdate(DbContext.getDefault(), null, tableName, values, false);
        return (PK)DB.execute(connection, QueryType.INSERT, insertSql.getSql(), insertSql.getParameters(), null);
    }

    public static <PK> PK insertOrUpdate(DataSource db, String tableName, Map<String, ? extends Object> values) {
        SqlExpression insertSql = DB.buildInsertOrUpdate(DbContext.getDefault(), null, tableName, values, true);
        return (PK)DB.execute(db, QueryType.INSERT, insertSql.getSql(), insertSql.getParameters(), null);
    }

    public static <PK> PK insertOrUpdate(DataSource db, String schemaName, String tableName, Map<String, ? extends Object> values) {
        SqlExpression insertSql = DB.buildInsertOrUpdate(DbContext.getDefault(), schemaName, tableName, values, true);
        return (PK)DB.execute(db, QueryType.INSERT, insertSql.getSql(), insertSql.getParameters(), null);
    }

    public static <PK> PK insertOrUpdate(Connection connection, String tableName, Map<String, ? extends Object> values) {
        SqlExpression insertSql = DB.buildInsertOrUpdate(DbContext.getDefault(), null, tableName, values, true);
        return (PK)DB.execute(connection, QueryType.INSERT, insertSql.getSql(), insertSql.getParameters(), null);
    }

    public static <PK> PK insertOrUpdate(Connection connection, String schemaName, String tableName, Map<String, ? extends Object> values) {
        SqlExpression insertSql = DB.buildInsertOrUpdate(DbContext.getDefault(), schemaName, tableName, values, true);
        return (PK)DB.execute(connection, QueryType.INSERT, insertSql.getSql(), insertSql.getParameters(), null);
    }

    private static SqlExpression buildInsertOrUpdate(DbContext context, String schemaName, String tableName, Map<String, ? extends Object> values, boolean addOnDuplicateKeyClause) {
        ArrayList<String> qmarks = new ArrayList<String>();
        ArrayList<String> quotedFields = new ArrayList<String>();
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> updateList = new ArrayList<String>();
        for (String f : values.keySet()) {
            String quotedField = context.quoteObjectNames(f);
            qmarks.add("?");
            quotedFields.add(quotedField);
            params.add(values.get(f));
            updateList.add(quotedField + "=?");
        }
        if (addOnDuplicateKeyClause) {
            params.addAll(new ArrayList(params));
        }
        String sql = "INSERT INTO " + DB.prefixAndQuoteTableName(context, schemaName, tableName) + " (" + Strings.implode(",", quotedFields) + ") VALUES (" + Strings.implode(",", qmarks) + ")";
        if (addOnDuplicateKeyClause) {
            sql = sql + " ON DUPLICATE KEY UPDATE " + Strings.implode(",", updateList);
        }
        return new SqlExpression(sql, params);
    }

    public static String prefixAndQuoteTableName(DbContext context, String schemaName, String tableName) {
        if (schemaName == null) {
            return context.quoteObjectNames(tableName);
        }
        return context.quoteObjectNames(schemaName, tableName);
    }

    private static SqlExpression buildUpdate(DbContext context, String schemaName, String tableName, Map<String, ? extends Object> values, Map<String, ? extends Object> ids) {
        ArrayList<String> qmarks = new ArrayList<String>();
        ArrayList<String> assignments = new ArrayList<String>();
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> wheres = new ArrayList<String>();
        for (String f : values.keySet()) {
            qmarks.add("?");
            assignments.add(String.format("%s=?", context.quoteObjectNames(f)));
            params.add(values.get(f));
        }
        for (String idField : ids.keySet()) {
            qmarks.add("?");
            wheres.add(String.format("%s=?", context.quoteObjectNames(idField)));
            params.add(ids.get(idField));
        }
        String sql = "UPDATE " + DB.prefixAndQuoteTableName(context, schemaName, tableName) + " SET " + Strings.implode(", ", assignments) + " WHERE " + Strings.implode(" AND ", wheres);
        return new SqlExpression(sql, params);
    }

    public static void executeDDL(DataSource db, String ddl) {
        DB.execute(db, QueryType.DDL, ddl, null, null);
    }

    public static void executeDDL(Connection connection, String ddl) {
        DB.execute(connection, QueryType.DDL, ddl, null, null);
    }

    public static <T> T execute(DataSource db, QueryType type, String sql, Iterable<Object> params, ResultSetProcessor<T> processor) {
        Connection connection = null;
        try {
            connection = db.getConnection();
            T t = DB.execute(connection, type, sql, params, processor);
            return t;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T execute(Connection connection, QueryType type, String sql, Iterable<Object> params, ResultSetProcessor<T> processor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 2[TRYBLOCK]], but top level block is 26[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void applyParameters(Iterable<Object> params, PreparedStatement stmt) throws SQLException {
        int index = 1;
        for (Object val : params) {
            if (val != null && val instanceof LocalDate) {
                LocalDate localDate = (LocalDate)val;
                String dateAsString = localDate.getYear() + "-" + localDate.getMonthValue() + "-" + localDate.getDayOfMonth();
                stmt.setObject(index++, dateAsString);
                continue;
            }
            if (val != null && val.getClass().isEnum()) {
                stmt.setObject(index++, ((Enum)val).name());
                continue;
            }
            stmt.setObject(index++, val);
        }
    }

    private static List<String> extractResultSetFieldNames(ResultSet result) throws SQLException {
        ResultSetMetaData metaData = result.getMetaData();
        ArrayList<String> fieldNames = new ArrayList<String>();
        int i = 0;
        while (i < metaData.getColumnCount()) {
            fieldNames.add(metaData.getColumnLabel(i + 1));
            ++i;
        }
        return fieldNames;
    }

    public static <T> T runInTransaction(Connection connection, Transaction<T> transaction) {
        boolean success = false;
        try {
            connection.setAutoCommit(false);
            T result = transaction.run(connection);
            connection.commit();
            success = true;
            T t = result;
            return t;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (!success) {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static <T> T runInTransaction(DataSource dataSource, Transaction<T> transaction) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            T t = DB.runInTransaction(connection, transaction);
            return t;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static /* synthetic */ int[] $SWITCH_TABLE$nl$pojoquery$DB$QueryType() {
        if ($SWITCH_TABLE$nl$pojoquery$DB$QueryType != null) {
            return $SWITCH_TABLE$nl$pojoquery$DB$QueryType;
        }
        int[] nArray = new int[QueryType.values().length];
        try {
            nArray[QueryType.DDL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QueryType.INSERT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QueryType.SELECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QueryType.UPDATE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        return nArray;
    }

    public static class ColumnProcessor
    implements ResultSetProcessor<List<List<Object>>> {
        @Override
        public List<List<Object>> process(ResultSet rs) {
            ArrayList<List<Object>> result = new ArrayList<List<Object>>();
            try {
                int columnCount = rs.getMetaData().getColumnCount();
                int i = 0;
                while (i < columnCount) {
                    result.add(new ArrayList());
                    ++i;
                }
                while (rs.next()) {
                    i = 0;
                    while (i < columnCount) {
                        ((List)result.get(i)).add(rs.getObject(i + 1));
                        ++i;
                    }
                }
                return result;
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
    }

    public static class Columns {
        private List<List<Object>> data;

        public Columns(List<List<Object>> data) {
            this.data = data;
        }

        public <T> List<T> get(int index) {
            return this.data.get(index);
        }
    }

    public static final class DatabaseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DatabaseException(SQLException e) {
            super(e);
        }
    }

    public static enum QueryType {
        DDL,
        SELECT,
        UPDATE,
        INSERT;

    }

    public static interface ResultSetProcessor<T> {
        public T process(ResultSet var1);
    }

    public static class RowProcessor
    implements ResultSetProcessor<List<Map<String, Object>>> {
        @Override
        public List<Map<String, Object>> process(ResultSet rs) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            try {
                List<String> fieldNames = DB.extractResultSetFieldNames(rs);
                while (rs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>(fieldNames.size());
                    for (String fieldName : fieldNames) {
                        row.put(fieldName, rs.getObject(fieldName));
                    }
                    result.add(row);
                }
                return result;
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
    }

    public static interface Transaction<T> {
        public T run(Connection var1);
    }
}

