/*
 * Decompiled with CFR 0.152.
 */
package nl.pojoquery;

public interface DbContext {
    public static final DbContext DEFAULT = new DefaultDbContext();

    public String quoteObjectNames(String ... var1);

    public void setQuoteStyle(QuoteStyle var1);

    public QuoteStyle getQuoteStyle();

    public void setQuoteObjectNames(boolean var1);

    public String quoteAlias(String var1);

    public static DbContext getDefault() {
        return DEFAULT;
    }

    public static class DefaultDbContext
    implements DbContext {
        private QuoteStyle quoteStyle = QuoteStyle.MYSQL;
        private boolean quoteObjects = true;

        @Override
        public void setQuoteStyle(QuoteStyle style) {
            this.quoteStyle = style;
        }

        @Override
        public String quoteObjectNames(String ... names) {
            Object ret = "";
            int i = 0;
            int nl = names.length;
            while (i < nl) {
                String name = names[i];
                if (i > 0) {
                    ret = (String)ret + ".";
                }
                ret = (String)ret + (this.quoteObjects ? this.quoteStyle.quote(name) : name);
                ++i;
            }
            return ret;
        }

        @Override
        public QuoteStyle getQuoteStyle() {
            return this.quoteStyle;
        }

        @Override
        public String quoteAlias(String alias) {
            return this.quoteStyle.quote(alias);
        }

        @Override
        public void setQuoteObjectNames(boolean addQuotes) {
            this.quoteObjects = addQuotes;
        }
    }

    public static enum QuoteStyle {
        ANSI("\""),
        MYSQL("`");

        private final String quote;

        private QuoteStyle(String quote) {
            this.quote = quote;
        }

        public String quote(String name) {
            return this.quote + name + this.quote;
        }
    }
}

