/*
 * Decompiled with CFR 0.152.
 */
package nl.pojoquery;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import nl.pojoquery.DB;
import nl.pojoquery.DbContext;
import nl.pojoquery.HasVersion;
import nl.pojoquery.SqlExpression;
import nl.pojoquery.StaleObjectException;
import nl.pojoquery.annotations.Embedded;
import nl.pojoquery.annotations.Link;
import nl.pojoquery.annotations.NoUpdate;
import nl.pojoquery.annotations.Other;
import nl.pojoquery.internal.MappingException;
import nl.pojoquery.internal.TableMapping;
import nl.pojoquery.pipeline.QueryBuilder;
import nl.pojoquery.pipeline.SqlQuery;

public class PojoQuery<T> {
    private final QueryBuilder<T> queryBuilder;
    private final SqlQuery query;
    private Class<T> resultClass;
    private DbContext dbContext;

    private PojoQuery(DbContext context, Class<T> clz) {
        this.dbContext = context;
        this.resultClass = clz;
        this.queryBuilder = QueryBuilder.from(clz);
        this.query = this.queryBuilder.getQuery();
    }

    public static <T> PojoQuery<T> build(Class<T> clz) {
        return PojoQuery.build(DbContext.getDefault(), clz);
    }

    public static <T> PojoQuery<T> build(DbContext context, Class<T> clz) {
        return new PojoQuery<T>(context, clz);
    }

    public SqlQuery getQuery() {
        return this.query;
    }

    public List<SqlQuery.SqlField> getFields() {
        return this.query.getFields();
    }

    public void setFields(List<SqlQuery.SqlField> fields) {
        this.query.setFields(fields);
    }

    public List<SqlQuery.SqlJoin> getJoins() {
        return this.query.getJoins();
    }

    public PojoQuery<T> setJoins(List<SqlQuery.SqlJoin> joins) {
        this.query.setJoins(joins);
        return this;
    }

    public List<SqlExpression> getWheres() {
        return this.query.getWheres();
    }

    public PojoQuery<T> setWheres(List<SqlExpression> wheres) {
        this.query.setWheres(wheres);
        return this;
    }

    public List<String> getGroupBy() {
        return this.query.getGroupBy();
    }

    public PojoQuery<T> setGroupBy(List<String> groupBy) {
        this.query.setGroupBy(groupBy);
        return this;
    }

    public List<String> getOrderBy() {
        return this.query.getOrderBy();
    }

    public PojoQuery<T> setOrderBy(List<String> orderBy) {
        this.query.setOrderBy(orderBy);
        return this;
    }

    public PojoQuery<T> addField(SqlExpression expression) {
        this.query.addField(expression);
        return this;
    }

    public PojoQuery<T> addField(SqlExpression expression, String alias) {
        this.query.addField(expression, alias);
        return this;
    }

    public PojoQuery<T> addGroupBy(String group) {
        this.query.addGroupBy(group);
        return this;
    }

    public PojoQuery<T> addWhere(SqlExpression where) {
        this.query.addWhere(where);
        return this;
    }

    public PojoQuery<T> addWhere(String sql, Object ... params) {
        this.query.addWhere(sql, params);
        return this;
    }

    public PojoQuery<T> addOrderBy(String order) {
        this.query.addOrderBy(order);
        return this;
    }

    public PojoQuery<T> setLimit(int rowCount) {
        this.query.setLimit(rowCount);
        return this;
    }

    public PojoQuery<T> setLimit(int offset, int rowCount) {
        this.query.setLimit(offset, rowCount);
        return this;
    }

    public SqlExpression toStatement() {
        return this.query.toStatement();
    }

    public PojoQuery<T> addJoin(SqlQuery.JoinType type, String tableName, String alias, SqlExpression joinCondition) {
        this.query.addJoin(type, tableName, alias, joinCondition);
        return this;
    }

    public String getTable() {
        return this.query.getTable();
    }

    public List<T> execute(DataSource db) {
        return this.queryBuilder.processRows(DB.queryRows(db, this.query.toStatement()));
    }

    public List<T> execute(Connection connection) {
        return this.queryBuilder.processRows(DB.queryRows(connection, this.query.toStatement()));
    }

    public List<T> executeStreaming(DataSource db) {
        ArrayList result = new ArrayList();
        HashMap allEntities = new HashMap();
        DB.queryRowsStreaming(db, this.query.toStatement(), row -> this.queryBuilder.processRow(result, allEntities, (Map<String, Object>)row));
        return result;
    }

    public static <PK> PK insert(Connection conn, Class<?> type, Object o) {
        return PojoQuery.insert(conn, null, type, o);
    }

    public static <PK> PK insert(DataSource db, Class<?> type, Object o) {
        return PojoQuery.insert(null, db, type, o);
    }

    public static <PK> PK insert(DataSource db, Object o) {
        return PojoQuery.insert(db, o.getClass(), o);
    }

    public static <PK> PK insert(Connection connection, Object o) {
        return PojoQuery.insert(connection, o.getClass(), o);
    }

    private static <PK> PK insert(Connection conn, DataSource db, Class<?> type, Object o) {
        List<Field> idFields;
        List<TableMapping> tables = QueryBuilder.determineTableMapping(type);
        if (tables.size() == 0) {
            throw new MappingException("Missing @Table annotation on class " + type.getName() + " or any of its superclasses");
        }
        if (tables.size() == 1) {
            Object ids = conn != null ? DB.insert(conn, tables.get((int)0).tableName, PojoQuery.extractValues(type, o)) : DB.insert(db, tables.get((int)0).tableName, PojoQuery.extractValues(type, o));
            if (ids != null) {
                PojoQuery.applyGeneratedId(o, ids);
            }
            return ids;
        }
        TableMapping topType = tables.remove(0);
        Map<String, Object> values = PojoQuery.extractValues(topType.clazz, o);
        Object ids = conn != null ? DB.insert(conn, topType.tableName, values) : DB.insert(db, topType.tableName, values);
        if (ids != null) {
            PojoQuery.applyGeneratedId(o, ids);
        }
        if ((idFields = QueryBuilder.determineIdFields(type)).size() != 1) {
            throw new MappingException("Need single ID field annotated with @Id for inserting joined subclasses");
        }
        String idField = idFields.get(0).getName();
        while (tables.size() > 0) {
            TableMapping supertype = tables.remove(0);
            Map<String, Object> subvals = PojoQuery.extractValues(tables.size() > 0 ? supertype.clazz : type, o, topType.clazz);
            subvals.put(idField, ids);
            if (conn != null) {
                DB.insert(conn, supertype.tableName, subvals);
            } else {
                DB.insert(db, supertype.tableName, subvals);
            }
            topType = supertype;
        }
        return ids;
    }

    public static int update(DataSource db, Object object) {
        return PojoQuery.update(null, db, object.getClass(), object);
    }

    public static int update(Connection connection, Object object) {
        return PojoQuery.update(connection, null, object.getClass(), object);
    }

    public static int update(DataSource db, Class<?> type, Object object) {
        return PojoQuery.update(null, db, type, object);
    }

    public static int update(Connection connection, Class<?> type, Object object) {
        return PojoQuery.update(connection, null, type, object);
    }

    /*
     * Unable to fully structure code
     */
    private static int update(Connection conn, DataSource db, Class<?> type, Object o) {
        tables = QueryBuilder.determineTableMapping(type);
        currentVersion = null;
        if (o instanceof HasVersion) {
            currentVersion = ((HasVersion)o).getVersion();
            if (currentVersion == null) {
                currentVersion = 0L;
            }
            ((HasVersion)o).setVersion(currentVersion + 1L);
        }
        if (tables.size() == 1) {
            values = PojoQuery.extractValues(type, o);
            ids = PojoQuery.splitIdFields(o, values);
            if (o instanceof HasVersion) {
                ids.put("version", currentVersion);
            }
            affectedRows = conn != null ? DB.update(conn, tables.get((int)0).tableName, values, ids) : DB.update(db, tables.get((int)0).tableName, values, ids);
            if (o instanceof HasVersion && affectedRows == 0) {
                throw new StaleObjectException();
            }
            return affectedRows;
        }
        affectedRows = 0;
        topType = tables.remove(0);
        values = PojoQuery.extractValues(topType.clazz, o);
        ids = PojoQuery.splitIdFields(o, values);
        topIds = new HashMap<String, Object>(ids);
        if (o instanceof HasVersion) {
            topIds.put("version", currentVersion);
        }
        if ((affectedRows = conn != null ? DB.update(conn, topType.tableName, values, topIds) : DB.update(db, topType.tableName, values, topIds)) != 0) ** GOTO lbl37
        throw new StaleObjectException();
lbl-1000:
        // 1 sources

        {
            supertype = tables.remove(0);
            subvals = PojoQuery.extractValues(tables.size() > 0 ? supertype.clazz : type, o, topType.clazz);
            if (conn != null) {
                DB.update(conn, supertype.tableName, subvals, ids);
            } else {
                DB.update(db, supertype.tableName, subvals, ids);
            }
            topType = supertype;
lbl37:
            // 2 sources

            ** while (tables.size() > 0)
        }
lbl38:
        // 1 sources

        return affectedRows;
    }

    public static Map<String, Object> extractValues(Class<?> type, Object o) {
        return PojoQuery.extractValues(type, o, null);
    }

    private static Map<String, Object> extractValues(Class<?> type, Object o, Class<?> stopAtSuperclass) {
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (Field f : QueryBuilder.collectFieldsOfClass(type, stopAtSuperclass)) {
                f.setAccessible(true);
                Other otherAnn = f.getAnnotation(Other.class);
                if (otherAnn != null) {
                    Map otherMap = (Map)f.get(o);
                    if (otherMap == null) continue;
                    for (String fieldName : otherMap.keySet()) {
                        values.put(otherAnn.prefix() + fieldName, otherMap.get(fieldName));
                    }
                    continue;
                }
                Object val = f.get(o);
                if (f.getAnnotation(Embedded.class) != null) {
                    if (val == null) continue;
                    Map<String, Object> embeddedVals = PojoQuery.extractValues(f.getType(), val);
                    String prefix = QueryBuilder.determinePrefix(f);
                    for (String embeddedField : embeddedVals.keySet()) {
                        values.put(prefix + embeddedField, embeddedVals.get(embeddedField));
                    }
                    continue;
                }
                if (f.getAnnotation(NoUpdate.class) != null || f.getAnnotation(Link.class) != null && !f.getAnnotation(Link.class).linktable().equals("--NONE--")) continue;
                if (f.getType().isArray()) {
                    if (!f.getType().getComponentType().isPrimitive()) continue;
                    values.put(QueryBuilder.determineSqlFieldName(f), val);
                    continue;
                }
                if (Collection.class.isAssignableFrom(f.getType())) continue;
                if (QueryBuilder.isLinkedClass(f.getType())) {
                    Object linkfieldName = f.getName() + "_id";
                    if (f.getAnnotation(Link.class) != null && !"--NONE--".equals(f.getAnnotation(Link.class).linkfield())) {
                        linkfieldName = f.getAnnotation(Link.class).linkfield();
                    }
                    if (val == null) {
                        values.put((String)linkfieldName, null);
                        continue;
                    }
                    Field idField = QueryBuilder.determineIdField(f.getType());
                    idField.setAccessible(true);
                    Object idValue = idField.get(val);
                    values.put((String)linkfieldName, idValue);
                    continue;
                }
                values.put(QueryBuilder.determineSqlFieldName(f), val);
            }
            return values;
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
    }

    private static <PK> void applyGeneratedId(Object o, PK ids) {
        List<Field> idFields = QueryBuilder.determineIdFields(o.getClass());
        if (ids != null && idFields.size() == 1) {
            Field idField = idFields.get(0);
            idField.setAccessible(true);
            try {
                if (ids instanceof BigInteger && idField.getType().isAssignableFrom(Long.class)) {
                    idField.set(o, ((BigInteger)ids).longValue());
                } else {
                    idField.set(o, ids);
                }
            }
            catch (IllegalArgumentException e) {
                throw new MappingException("Could not set Id field value " + String.valueOf(idField), e);
            }
            catch (IllegalAccessException e) {
                throw new MappingException("Could not set Id field value " + String.valueOf(idField), e);
            }
        }
    }

    private static Map<String, Object> splitIdFields(Object object, Map<String, Object> values) {
        List<Field> idFields = QueryBuilder.determineIdFields(object.getClass());
        if (idFields.size() == 0) {
            throw new RuntimeException("No @Id annotations found on fields of class " + object.getClass().getName());
        }
        HashMap<String, Object> ids = new HashMap<String, Object>();
        for (Field f : idFields) {
            ids.put(f.getName(), values.get(f.getName()));
            values.remove(f.getName());
        }
        return ids;
    }

    public String toSql() {
        return this.query.toStatement().getSql();
    }

    public T findById(Connection connection, Object id) {
        this.query.getWheres().addAll(QueryBuilder.buildIdCondition(this.dbContext, this.resultClass, id));
        return this.returnSingleRow(this.execute(connection));
    }

    public T findById(DataSource db, Object id) {
        this.query.getWheres().addAll(QueryBuilder.buildIdCondition(this.dbContext, this.resultClass, id));
        return this.returnSingleRow(this.executeStreaming(db));
    }

    public static void delete(Connection conn, Object entity) {
        PojoQuery.delete(DbContext.getDefault(), conn, null, entity);
    }

    public static void delete(DbContext context, Connection conn, Object entity) {
        PojoQuery.delete(context, conn, null, entity);
    }

    public static void delete(DataSource db, Object entity) {
        PojoQuery.delete(DbContext.getDefault(), db, entity);
    }

    public static void delete(DbContext context, DataSource db, Object entity) {
        PojoQuery.delete(context, null, db, entity);
    }

    private static void delete(DbContext context, Connection conn, DataSource db, Object entity) {
        try {
            List<TableMapping> mapping = QueryBuilder.determineTableMapping(entity.getClass());
            List<Field> idFields = QueryBuilder.determineIdFields(entity.getClass());
            Collections.reverse(mapping);
            for (TableMapping table : mapping) {
                ArrayList<SqlExpression> whereCondition = new ArrayList<SqlExpression>();
                for (Field field : idFields) {
                    field.setAccessible(true);
                    Object idvalue = field.get(entity);
                    if (idvalue == null) {
                        throw new MappingException("Cannot create wherecondition for entity with null value in idfield " + field.getName());
                    }
                    whereCondition.add(new SqlExpression(context.quoteObjectNames(table.tableName, field.getName()) + "=?", Arrays.asList(idvalue)));
                }
                if (db != null) {
                    PojoQuery.executeDelete(context, null, db, table.tableName, whereCondition);
                    continue;
                }
                PojoQuery.executeDelete(context, conn, null, table.tableName, whereCondition);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MappingException(e);
        }
    }

    public static void deleteById(DbContext context, DataSource db, Class<?> clz, Object id) {
        for (TableMapping table : QueryBuilder.determineTableMapping(clz)) {
            List<SqlExpression> wheres = QueryBuilder.buildIdCondition(context, table.clazz, id);
            PojoQuery.executeDelete(context, null, db, table.tableName, wheres);
        }
    }

    private static void executeDelete(DbContext context, Connection conn, DataSource db, String tableName, List<SqlExpression> where) {
        SqlExpression wheres = SqlExpression.implode(" AND ", where);
        SqlExpression deleteStatement = new SqlExpression("DELETE FROM " + context.quoteObjectNames(tableName) + " WHERE " + wheres.getSql(), wheres.getParameters());
        if (db != null) {
            DB.update(db, deleteStatement);
        } else {
            DB.update(conn, deleteStatement);
        }
    }

    private T returnSingleRow(List<T> resultList) {
        if (resultList.size() == 1) {
            return resultList.get(0);
        }
        if (resultList.size() > 1) {
            throw new RuntimeException("More than one result found in findById on class " + this.resultClass.getName());
        }
        return null;
    }

    public List<T> processRows(List<Map<String, Object>> rows) {
        return this.queryBuilder.processRows(rows);
    }

    public <PK> List<PK> listIds(DataSource db) {
        List<Field> idFields = QueryBuilder.determineIdFields(this.resultClass);
        SqlExpression stmt = this.queryBuilder.buildListIdsStatement(idFields);
        List<Map<String, Object>> rows = DB.queryRows(db, stmt);
        if (idFields.size() > 1) {
            return rows;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map<String, Object> r : rows) {
            result.add(r.values().iterator().next());
        }
        return result;
    }

    public int countTotal(DataSource db) {
        SqlExpression stmt = this.queryBuilder.buildCountStatement();
        List<Map<String, Object>> rows = DB.queryRows(db, stmt);
        return ((Long)rows.get(0).values().iterator().next()).intValue();
    }
}

