/*
 * Decompiled with CFR 0.152.
 */
package nl.pojoquery.parser;

public class StatementParameterMatcher {
    private State state = State.IDENTIFIERS;
    private final char[] sql;
    private int index = 0;
    private int tailStart = -1;
    private int parameterNameStart = -1;

    public StatementParameterMatcher(String sql) {
        this.sql = sql.toCharArray();
    }

    public boolean find() {
        this.parameterNameStart = -1;
        this.tailStart = this.index;
        while (this.index < this.sql.length) {
            char c = this.sql[this.index];
            switch (this.state) {
                case PARAMETERNAME: {
                    if (Character.isUnicodeIdentifierPart(c)) break;
                    this.state = State.IDENTIFIERS;
                    return true;
                }
                case QUOTED_STRING: {
                    if (c == '\\') {
                        ++this.index;
                        break;
                    }
                    if (c != '\'') break;
                    this.state = State.IDENTIFIERS;
                    break;
                }
                default: {
                    if (c == '\'') {
                        this.state = State.QUOTED_STRING;
                    }
                    if (c == '?') {
                        this.parameterNameStart = this.index++;
                        return true;
                    }
                    if (c != ':' || this.index + 1 >= this.sql.length || !Character.isUnicodeIdentifierStart(this.sql[this.index + 1])) break;
                    this.state = State.PARAMETERNAME;
                    this.parameterNameStart = this.index;
                }
            }
            ++this.index;
        }
        switch (this.state) {
            case PARAMETERNAME: {
                this.state = State.IDENTIFIERS;
                return true;
            }
            case QUOTED_STRING: {
                throw new RuntimeException("Syntax error: Unclosed quoted string at end of expression");
            }
        }
        return false;
    }

    public String getParameterName() {
        return new String(this.sql, this.parameterNameStart, this.index - this.parameterNameStart);
    }

    public void appendReplacement(StringBuilder target, String string) {
        target.append(this.sql, this.tailStart, this.parameterNameStart - this.tailStart);
        target.append(string);
    }

    public void appendTail(StringBuilder target) {
        target.append(this.sql, this.tailStart, this.index - this.tailStart);
    }

    private static enum State {
        IDENTIFIERS,
        QUOTED_STRING,
        PARAMETERNAME;

    }
}

