/*
 * Decompiled with CFR 0.152.
 */
package nl.pojoquery.pipeline;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import nl.pojoquery.DbContext;
import nl.pojoquery.FieldMapping;
import nl.pojoquery.SqlExpression;
import nl.pojoquery.annotations.Embedded;
import nl.pojoquery.annotations.FieldName;
import nl.pojoquery.annotations.GroupBy;
import nl.pojoquery.annotations.Id;
import nl.pojoquery.annotations.Join;
import nl.pojoquery.annotations.JoinCondition;
import nl.pojoquery.annotations.Joins;
import nl.pojoquery.annotations.Link;
import nl.pojoquery.annotations.OrderBy;
import nl.pojoquery.annotations.Other;
import nl.pojoquery.annotations.Select;
import nl.pojoquery.annotations.SubClasses;
import nl.pojoquery.annotations.Table;
import nl.pojoquery.annotations.Transient;
import nl.pojoquery.internal.MappingException;
import nl.pojoquery.internal.TableMapping;
import nl.pojoquery.pipeline.Alias;
import nl.pojoquery.pipeline.SimpleFieldMapping;
import nl.pojoquery.pipeline.SqlQuery;
import nl.pojoquery.util.Strings;
import nl.pojoquery.util.Types;

public class QueryBuilder<T> {
    private LinkedHashMap<String, Alias> subClasses = new LinkedHashMap();
    private LinkedHashMap<String, Alias> aliases = new LinkedHashMap();
    private Map<String, List<String>> keysByAlias = new HashMap<String, List<String>>();
    private Map<String, FieldMapping> fieldMappings = new LinkedHashMap<String, FieldMapping>();
    private final Class<T> resultClass;
    private final SqlQuery query;
    private final String rootAlias;
    private final DbContext dbContext;

    private QueryBuilder(DbContext context, Class<T> clz) {
        OrderBy orderByAnn;
        int n;
        this.dbContext = context;
        this.resultClass = clz;
        this.query = new SqlQuery(context);
        TableMapping tableMapping = QueryBuilder.lookupTableMapping(clz);
        this.query.setTable(tableMapping.schemaName, tableMapping.tableName);
        List<Join> joinAnns = this.getJoinAnnotations(clz);
        for (Join joinAnn : joinAnns) {
            this.query.addJoin(joinAnn.type(), joinAnn.schemaName(), joinAnn.tableName(), joinAnn.alias(), SqlExpression.sql(joinAnn.joinCondition(), new Object[0]));
        }
        GroupBy groupByAnn = clz.getAnnotation(GroupBy.class);
        if (groupByAnn != null) {
            String[] stringArray = groupByAnn.value();
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String groupBy = stringArray[n2];
                this.query.addGroupBy(groupBy);
                ++n2;
            }
        }
        if ((orderByAnn = clz.getAnnotation(OrderBy.class)) != null) {
            String[] stringArray = orderByAnn.value();
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String orderBy = stringArray[n];
                this.query.addOrderBy(orderBy);
                ++n;
            }
        }
        this.rootAlias = this.query.getTable();
        this.addClass(clz, this.rootAlias, null, null);
    }

    private List<Join> getJoinAnnotations(Class<T> clz) {
        Joins multipleJoins = clz.getAnnotation(Joins.class);
        if (multipleJoins != null) {
            return Arrays.asList(multipleJoins.value());
        }
        Join singleJoin = clz.getAnnotation(Join.class);
        if (singleJoin != null) {
            return List.of(singleJoin);
        }
        return List.of();
    }

    public static <R> QueryBuilder<R> from(Class<R> clz) {
        return QueryBuilder.from(DbContext.getDefault(), clz);
    }

    public static <R> QueryBuilder<R> from(DbContext context, Class<R> clz) {
        return new QueryBuilder<R>(context, clz);
    }

    public SqlExpression toStatement() {
        return this.query.toStatement();
    }

    public SqlExpression buildListIdsStatement(List<Field> idFields) {
        return this.query.toStatement(new SqlExpression("SELECT DISTINCT " + Strings.implode("\n , ", QueryBuilder.getFieldNames(this.query.getTable(), idFields))), this.query.getSchema(), this.query.getTable(), this.query.getJoins(), this.query.getWheres(), null, this.query.getOrderBy(), this.query.getOffset(), this.query.getRowCount());
    }

    public SqlExpression buildCountStatement() {
        List<Field> idFields = QueryBuilder.determineIdFields(this.resultClass);
        String selectClause = "SELECT COUNT(DISTINCT " + Strings.implode(", ", QueryBuilder.getFieldNames(this.query.getTable(), idFields)) + ") ";
        return this.query.toStatement(new SqlExpression(selectClause), this.query.getSchema(), this.query.getTable(), this.query.getJoins(), this.query.getWheres(), null, null, -1, -1);
    }

    public SqlQuery getQuery() {
        return this.query;
    }

    private static TableMapping lookupTableMapping(Class<?> clz) {
        if (clz == null) {
            throw new NullPointerException("clz");
        }
        List<TableMapping> tableMappings = QueryBuilder.determineTableMapping(clz);
        if (tableMappings.size() == 0) {
            throw new MappingException("Missing @Table annotation on class " + clz.getName() + " or any of its superclasses");
        }
        return tableMappings.get(tableMappings.size() - 1);
    }

    private void addClass(Class<?> clz, String alias, String parentAlias, Field linkField) {
        if (parentAlias != null) {
            this.checkForCyclicMapping(clz, parentAlias);
        }
        List<TableMapping> tableMappings = QueryBuilder.determineTableMapping(clz);
        Alias previousAlias = null;
        int i = tableMappings.size() - 1;
        while (i >= 0) {
            String combinedAlias;
            TableMapping mapping = tableMappings.get(i);
            TableMapping superMapping = i > 0 ? tableMappings.get(i - 1) : null;
            String string = combinedAlias = mapping.clazz.equals(clz) ? alias : alias + "." + mapping.tableName;
            if (alias.equals(this.rootAlias)) {
                combinedAlias = mapping.tableName;
            }
            if (superMapping != null) {
                Object linkAlias = alias + "." + superMapping.tableName;
                SqlQuery.JoinType joinType = SqlQuery.JoinType.LEFT;
                if (alias.equals(this.rootAlias)) {
                    linkAlias = superMapping.tableName;
                    joinType = SqlQuery.JoinType.INNER;
                }
                String idField = QueryBuilder.determineIdField(superMapping.clazz).getName();
                this.query.addJoin(joinType, superMapping.schemaName, superMapping.tableName, (String)linkAlias, new SqlExpression("{" + (String)linkAlias + "}." + idField + " = {" + combinedAlias + "}." + idField));
            }
            Alias newAlias = new Alias(combinedAlias, mapping.clazz, parentAlias, linkField, QueryBuilder.determineIdFields(mapping.clazz));
            if (previousAlias != null) {
                newAlias.setSubClassAliases(Arrays.asList(previousAlias.getAlias()));
                newAlias.setParentAlias(previousAlias.getAlias());
            }
            previousAlias = newAlias;
            this.aliases.put(combinedAlias, newAlias);
            this.addFields(combinedAlias, alias, mapping.clazz, superMapping != null ? superMapping.clazz : null, null);
            --i;
        }
        SubClasses subClassesAnn = clz.getAnnotation(SubClasses.class);
        if (subClassesAnn != null) {
            TableMapping thisMapping = tableMappings.get(tableMappings.size() - 1);
            Field thisIdField = QueryBuilder.determineIdField(thisMapping.clazz);
            ArrayList<String> subClassesAdded = new ArrayList<String>();
            Class<?>[] classArray = subClassesAnn.value();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> subClass = classArray[n2];
                List<TableMapping> mappings = QueryBuilder.determineTableMapping(subClass);
                TableMapping mapping = mappings.get(mappings.size() - 1);
                String linkAlias = alias + "." + mapping.tableName;
                String idField = QueryBuilder.determineIdField(mapping.clazz).getName();
                this.query.addJoin(SqlQuery.JoinType.LEFT, mapping.schemaName, mapping.tableName, linkAlias, new SqlExpression("{" + linkAlias + "}." + idField + " = {" + alias + "}." + idField));
                Alias subClassAlias = new Alias(linkAlias, mapping.clazz, alias, thisIdField, QueryBuilder.determineIdFields(mapping.clazz));
                subClassAlias.setIsASubClass(true);
                this.aliases.put(linkAlias, subClassAlias);
                this.subClasses.put(linkAlias, subClassAlias);
                this.addField(new SqlExpression("{" + linkAlias + "}." + idField), linkAlias + "." + idField, thisIdField);
                this.addFields(linkAlias, mapping.clazz, thisMapping.clazz);
                subClassesAdded.add(linkAlias);
                ++n2;
            }
            this.aliases.get(alias).setSubClassAliases(subClassesAdded);
        }
    }

    private void checkForCyclicMapping(Class<?> clz, String parentAlias) {
        Alias alias;
        String parent = parentAlias;
        ArrayList parentClasses = new ArrayList();
        parentClasses.add(clz);
        while ((alias = this.aliases.get(parent)) != null) {
            parentClasses.add(alias.getResultClass());
            if (alias.getResultClass().equals(clz)) {
                String message = parentClasses.stream().map(it -> it.getSimpleName()).collect(Collectors.joining(" -> "));
                throw new MappingException("Mapping cycle detected: " + message);
            }
            parent = alias.getParentAlias();
        }
    }

    private void addFields(String alias, Class<?> clz, Class<?> superClass) {
        this.addFields(alias, alias, clz, superClass, null);
    }

    private void addFields(String alias, String fieldsAlias, Class<?> clz, Class<?> superClass, String fieldNamePrefix) {
        for (Field f : QueryBuilder.collectFieldsOfClass(clz, superClass)) {
            SqlExpression selectExpression;
            f.setAccessible(true);
            Class<?> type = f.getType();
            boolean isRoot = this.isRootOrSuperClassOfRoot(alias);
            if (QueryBuilder.isListOrArray(type)) {
                String linkAlias;
                Class<?> componentType = type.isArray() ? type.getComponentType() : Types.getComponentType(f.getGenericType());
                Link linkAnn = f.getAnnotation(Link.class);
                if (linkAnn != null) {
                    Object linkAlias2;
                    if (!"--NONE--".equals(linkAnn.fetchColumn())) {
                        String foreignlinkfieldname = f.getAnnotation(Link.class).foreignlinkfield();
                        if ("--NONE--".equals(foreignlinkfieldname)) {
                            foreignlinkfieldname = QueryBuilder.linkFieldName(clz);
                        }
                        linkAlias2 = alias.equals(this.rootAlias) ? f.getName() : alias + "." + f.getName();
                        SqlExpression joinCondition = null;
                        String idField = null;
                        if (f.getAnnotation(JoinCondition.class) != null) {
                            joinCondition = SqlQuery.resolveAliases(this.dbContext, new SqlExpression(f.getAnnotation(JoinCondition.class).value()), alias, isRoot ? "" : alias, (String)linkAlias2);
                        } else {
                            idField = QueryBuilder.determineIdField(clz).getName();
                        }
                        this.joinMany(this.query, alias, f.getName(), linkAnn.linkschema(), linkAnn.linktable(), idField, foreignlinkfieldname, joinCondition);
                        Alias a = new Alias((String)linkAlias2, componentType, alias, f, QueryBuilder.determineIdFields(componentType));
                        a.setIsLinkedValue(true);
                        this.aliases.put((String)linkAlias2, a);
                        this.addField(new SqlExpression("{" + (String)linkAlias2 + "}." + linkAnn.fetchColumn()), (String)linkAlias2 + ".value", f);
                        continue;
                    }
                    if (linkAnn.linktable().equals("--NONE--")) {
                        linkAlias = this.joinMany(alias, this.query, f, componentType);
                        this.addClass(componentType, linkAlias, alias, f);
                        continue;
                    }
                    String linkTableAlias = alias + "_" + f.getName();
                    linkAlias2 = isRoot ? linkTableAlias : alias + "." + linkTableAlias;
                    String idField = QueryBuilder.determineIdField(clz).getName();
                    String linkfieldname = linkAnn.linkfield();
                    if ("--NONE--".equals(linkfieldname)) {
                        linkfieldname = QueryBuilder.linkFieldName(clz);
                    }
                    SqlExpression joinCondition = new SqlExpression("{" + alias + "}." + idField + " = {" + (String)linkAlias2 + "}." + linkfieldname);
                    if (f.getAnnotation(JoinCondition.class) != null) {
                        joinCondition = SqlQuery.resolveAliases(this.dbContext, new SqlExpression(f.getAnnotation(JoinCondition.class).value()), alias, isRoot ? "" : alias, (String)linkAlias2);
                    }
                    this.query.addJoin(SqlQuery.JoinType.LEFT, linkAnn.linkschema(), linkAnn.linktable(), (String)linkAlias2, joinCondition);
                    String foreignLinkAlias = isRoot ? f.getName() : alias + "." + f.getName();
                    String foreignIdField = QueryBuilder.determineIdField(componentType).getName();
                    String foreignlinkfieldname = linkAnn.foreignlinkfield();
                    if ("--NONE--".equals(foreignlinkfieldname)) {
                        foreignlinkfieldname = QueryBuilder.linkFieldName(componentType);
                    }
                    SqlExpression foreignJoinCondition = new SqlExpression("{" + (String)linkAlias2 + "}." + foreignlinkfieldname + " = {" + foreignLinkAlias + "}." + foreignIdField);
                    this.query.addJoin(SqlQuery.JoinType.LEFT, QueryBuilder.determineTableMapping(componentType).get((int)0).schemaName, QueryBuilder.determineTableMapping(componentType).get((int)0).tableName, foreignLinkAlias, foreignJoinCondition);
                    this.addClass(componentType, foreignLinkAlias, alias, f);
                    continue;
                }
                if (QueryBuilder.determineTableMapping(componentType).size() <= 0) continue;
                linkAlias = this.joinMany(alias, this.query, f, componentType);
                this.addClass(componentType, linkAlias, alias, f);
                continue;
            }
            if (QueryBuilder.isLinkedClass(type)) {
                String parent = fieldNamePrefix == null ? alias : fieldsAlias;
                String linkAlias = this.joinOne(parent, this.query, f, type, fieldNamePrefix);
                this.addClass(type, linkAlias, parent, f);
                continue;
            }
            if (f.getAnnotation(Embedded.class) != null) {
                String prefix = QueryBuilder.determinePrefix(f);
                Object embedAlias = isRoot && fieldNamePrefix == null ? f.getName() : fieldsAlias + "." + f.getName();
                Alias newAlias = new Alias((String)embedAlias, f.getType(), fieldsAlias, f, Collections.emptyList());
                newAlias.setIsEmbedded(true);
                this.aliases.put((String)embedAlias, newAlias);
                this.addFields(alias, (String)embedAlias, f.getType(), null, (fieldNamePrefix == null ? "" : fieldNamePrefix) + prefix);
                continue;
            }
            if (f.getAnnotation(Other.class) != null) {
                this.aliases.get(alias).setOtherField(f);
                List<String> subClassAliases = this.aliases.get(alias).getSubClassAliases();
                if (subClassAliases == null) continue;
                for (String subClassAlias : subClassAliases) {
                    this.aliases.get(subClassAlias).setOtherField(f);
                }
                continue;
            }
            if (f.getAnnotation(Select.class) != null) {
                selectExpression = SqlQuery.resolveAliases(this.dbContext, new SqlExpression(f.getAnnotation(Select.class).value()), alias, alias.equals(this.rootAlias) ? "" : alias, null);
            } else {
                String fieldName = QueryBuilder.determineSqlFieldName(f);
                selectExpression = new SqlExpression("{" + alias + "}." + (fieldNamePrefix == null ? "" : fieldNamePrefix) + fieldName);
            }
            this.addField(selectExpression, fieldsAlias + "." + f.getName(), f);
        }
    }

    public static String determineSqlFieldName(Field f) {
        String fieldName = f.getName();
        if (f.getAnnotation(FieldName.class) != null) {
            fieldName = f.getAnnotation(FieldName.class).value();
        }
        return fieldName;
    }

    private String joinMany(String alias, SqlQuery result, Field f, Class<?> componentType) {
        TableMapping tableMapping = QueryBuilder.lookupTableMapping(componentType);
        String idField = QueryBuilder.determineIdField(f.getDeclaringClass()).getName();
        String linkField = QueryBuilder.linkFieldName(f.getDeclaringClass());
        Link linkAnn = f.getAnnotation(Link.class);
        if (linkAnn != null && !"--NONE--".equals(linkAnn.foreignlinkfield())) {
            linkField = linkAnn.foreignlinkfield();
        }
        SqlExpression joinCondition = null;
        if (f.getAnnotation(JoinCondition.class) != null) {
            joinCondition = SqlQuery.resolveAliases(this.dbContext, new SqlExpression(f.getAnnotation(JoinCondition.class).value()), alias, this.isRootOrSuperClassOfRoot(alias) ? "" : alias, null);
        }
        return this.joinMany(result, alias, f.getName(), tableMapping.schemaName, tableMapping.tableName, idField, linkField, joinCondition);
    }

    private boolean isRootOrSuperClassOfRoot(String alias) {
        if (alias.equals(this.rootAlias)) {
            return true;
        }
        List<String> subs = this.aliases.get(alias).getSubClassAliases();
        return subs != null && subs.contains(this.rootAlias);
    }

    private String joinMany(SqlQuery result, String alias, String fieldName, String schemaName, String tableName, String idField, String linkField, SqlExpression joinCondition) {
        Object linkAlias = alias.equals(this.rootAlias) ? fieldName : alias + "." + fieldName;
        Alias parentAlias = this.aliases.get(alias);
        while (parentAlias.getSubClassAliases() != null && parentAlias.getSubClassAliases().size() == 1) {
            String parentAliasStr = parentAlias.getParentAlias();
            if (this.rootAlias.equals(parentAliasStr)) {
                linkAlias = fieldName;
                break;
            }
            linkAlias = parentAliasStr + "." + fieldName;
            parentAlias = this.aliases.get(parentAliasStr);
        }
        if (joinCondition == null) {
            joinCondition = new SqlExpression("{" + alias + "}." + idField + " = {" + (String)linkAlias + "}." + linkField);
        }
        result.addJoin(SqlQuery.JoinType.LEFT, schemaName, tableName, (String)linkAlias, joinCondition);
        return linkAlias;
    }

    private String joinOne(String alias, SqlQuery result, Field f, Class<?> type, String linkFieldPrefix) {
        TableMapping table = QueryBuilder.lookupTableMapping(type);
        boolean isEmbeddedLinkfield = linkFieldPrefix != null;
        Object linkAlias = alias.equals(this.rootAlias) ? f.getName() : alias + "." + f.getName();
        Alias parentAlias = this.aliases.get(alias);
        while (parentAlias.getSubClassAliases() != null && parentAlias.getSubClassAliases().size() == 1) {
            String parentAliasStr = parentAlias.getParentAlias();
            if (this.rootAlias.equals(parentAliasStr)) {
                linkAlias = f.getName();
                break;
            }
            linkAlias = parentAliasStr + "." + f.getName();
            parentAlias = this.aliases.get(parentAliasStr);
        }
        SqlExpression joinCondition = null;
        if (f.getAnnotation(JoinCondition.class) != null) {
            joinCondition = SqlQuery.resolveAliases(this.dbContext, new SqlExpression(f.getAnnotation(JoinCondition.class).value()), parentAlias.getAlias(), alias.equals(this.rootAlias) ? "" : alias, alias.equals(this.rootAlias) ? "" : alias);
        } else {
            Field idField = QueryBuilder.determineIdField(type);
            String linkField = (isEmbeddedLinkfield ? linkFieldPrefix : "") + QueryBuilder.linkFieldName(f);
            while (parentAlias.getParentAlias() != null && this.aliases.get(parentAlias.getParentAlias()).getIsEmbedded()) {
                parentAlias = this.aliases.get(parentAlias.getParentAlias());
            }
            String linkFieldAlias = isEmbeddedLinkfield ? parentAlias.getParentAlias() : alias;
            joinCondition = new SqlExpression("{" + linkFieldAlias + "}." + linkField + " = {" + (String)linkAlias + "}." + idField.getName());
        }
        result.addJoin(SqlQuery.JoinType.LEFT, table.schemaName, table.tableName, (String)linkAlias, joinCondition);
        return linkAlias;
    }

    private void addField(SqlExpression expression, String fieldAlias, Field f) {
        this.fieldMappings.put(fieldAlias, new SimpleFieldMapping(f));
        this.query.addField(expression, fieldAlias);
    }

    private static String linkFieldName(Class<?> clz) {
        return QueryBuilder.lookupTableMapping(clz).tableName + "_id";
    }

    private static String linkFieldName(Field f) {
        if (f.getAnnotation(FieldName.class) != null) {
            return f.getAnnotation(FieldName.class).value();
        }
        if (f.getAnnotation(Link.class) != null) {
            return f.getAnnotation(Link.class).linkfield();
        }
        return f.getName() + "_id";
    }

    private static boolean isListOrArray(Class<?> type) {
        return type.isArray() && !type.getComponentType().isPrimitive() || Iterable.class.isAssignableFrom(type);
    }

    public static boolean isLinkedClass(Class<?> type) {
        return !type.isPrimitive() && QueryBuilder.determineTableMapping(type).size() > 0;
    }

    public List<T> processRowsStreaming(Callable<Map<String, Object>> rowProvider) {
        return new ArrayList();
    }

    public List<T> processRows(List<Map<String, Object>> rows) {
        try {
            ArrayList result = new ArrayList(rows.size());
            HashMap<Object, Object> allEntities = new HashMap<Object, Object>();
            if (rows.size() > 0) {
                Set<String> allKeys = rows.get(0).keySet();
                this.keysByAlias = QueryBuilder.groupKeysByAlias(allKeys);
            }
            for (Map<String, Object> row : rows) {
                this.processRow(result, allEntities, row);
            }
            return result;
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    public static Map<String, List<String>> groupKeysByAlias(Set<String> allKeys) {
        HashMap<String, List<String>> keysByAlias = new HashMap<String, List<String>>();
        for (String key : allKeys) {
            int dotPos;
            String alias = key.substring(0, dotPos = key.lastIndexOf("."));
            if (!keysByAlias.containsKey(alias)) {
                keysByAlias.put(alias, new ArrayList());
            }
            ((List)keysByAlias.get(alias)).add(key);
        }
        return keysByAlias;
    }

    public void processRow(List<T> result, Map<Object, Object> allEntities, Map<String, Object> row) {
        if (this.keysByAlias.size() == 0) {
            this.keysByAlias = QueryBuilder.groupKeysByAlias(row.keySet());
        }
        Map<String, Values> onThisRow = this.collectValuesByAlias(row, this.keysByAlias);
        onThisRow = this.remapSubClasses(onThisRow);
        for (Alias a : this.aliases.values()) {
            Object entity;
            Alias parentAliasObject;
            List<String> subs;
            Values values = onThisRow.get(a.getAlias());
            if (values == null || QueryBuilder.allNulls(values)) continue;
            Object id = this.createId(a.getAlias(), values, a.getIdFields());
            Object subClassId = null;
            if (a.getParentAlias() == null) {
                if (allEntities.containsKey(id)) continue;
                Values merged = new Values(values);
                Class<Object> entityClass = this.resultClass;
                if (a.getSubClassAliases() != null) {
                    for (String subClassAlias : a.getSubClassAliases()) {
                        Values subClassValues = onThisRow.get(subClassAlias);
                        if (subClassValues == null || QueryBuilder.allNulls(subClassValues)) continue;
                        merged.putAll(onThisRow.get(subClassAlias));
                        subClassId = this.createId(subClassAlias, merged, a.getIdFields());
                        entityClass = this.aliases.get(subClassAlias).getResultClass();
                    }
                }
                T entity2 = this.buildEntity(entityClass, merged, a.getOtherField());
                allEntities.put(id, entity2);
                allEntities.put(subClassId, entity2);
                result.add(entity2);
                continue;
            }
            if (a.getIsASubClass()) continue;
            Values parentValues = onThisRow.get(a.getParentAlias());
            String parentAlias = a.getParentAlias();
            Object parentId = null;
            Object parent = null;
            if (parentValues != null && parentValues.size() != 0) {
                parentId = this.createId(parentAlias, parentValues, this.aliases.get(parentAlias).getIdFields());
                parent = allEntities.get(parentId);
            }
            if (parent == null && (subs = (parentAliasObject = this.aliases.get(a.getParentAlias())).getSubClassAliases()) != null && subs.size() > 0) {
                for (String sub : subs) {
                    parentValues = onThisRow.get(sub);
                    if (parentValues == null || parentValues.size() <= 0) continue;
                    parentAlias = sub;
                    parentId = this.createId(parentAlias, parentValues, this.aliases.get(parentAlias).getIdFields());
                    parent = allEntities.get(parentId);
                    break;
                }
            }
            if (a.isLinkedValue()) {
                Object value = values.values().iterator().next();
                if (a.getResultClass().isEnum()) {
                    value = QueryBuilder.enumValueOf(a.getResultClass(), (String)value);
                }
                this.putValueIntoField(parent, a.getLinkField(), value);
                continue;
            }
            Class<?> entityClass = a.getResultClass();
            if (a.getSubClassAliases() != null) {
                Values merged = new Values();
                merged.putAll(onThisRow.get(a.getAlias()));
                for (String subClassAlias : a.getSubClassAliases()) {
                    Values subClassValues = onThisRow.get(subClassAlias);
                    if (subClassValues == null || QueryBuilder.allNulls(subClassValues)) continue;
                    merged.putAll(onThisRow.get(subClassAlias));
                    id = this.createId(subClassAlias, merged, a.getIdFields());
                    entityClass = this.aliases.get(subClassAlias).getResultClass();
                    values = merged;
                }
            }
            if ((entity = allEntities.get(id)) == null) {
                entity = this.buildEntity(entityClass, values, a.getOtherField());
                allEntities.put(id, entity);
            }
            this.putValueIntoField(parent, a.getLinkField(), entity);
        }
    }

    public Map<String, Values> remapSubClasses(Map<String, Values> onThisRow) {
        LinkedHashMap<String, Values> result = new LinkedHashMap<String, Values>();
        for (String alias : onThisRow.keySet()) {
            Values values = onThisRow.get(alias);
            Alias a = this.aliases.get(alias);
            if (a.getIsASubClass()) {
                if (values == null || QueryBuilder.allNulls(values)) continue;
                a.getParentAlias();
            }
            result.put(alias, values);
        }
        return result;
    }

    private void putValueIntoField(Object parentEntity, Field linkField, Object entity) {
        try {
            if (List.class.isAssignableFrom(linkField.getType())) {
                ArrayList<Object> coll = (ArrayList<Object>)linkField.get(parentEntity);
                if (coll == null) {
                    coll = new ArrayList<Object>();
                    linkField.set(parentEntity, coll);
                }
                if (!coll.contains(entity) && entity != null) {
                    coll.add(entity);
                }
            } else if (Set.class.isAssignableFrom(linkField.getType())) {
                HashSet<Object> coll = (HashSet<Object>)linkField.get(parentEntity);
                if (coll == null) {
                    coll = new HashSet<Object>();
                    linkField.set(parentEntity, coll);
                }
                if (!coll.contains(entity) && entity != null) {
                    coll.add(entity);
                }
            } else if (linkField.getType().isArray()) {
                Object arr = linkField.get(parentEntity);
                if (arr == null) {
                    arr = Array.newInstance(linkField.getType().getComponentType(), 0);
                }
                boolean contains = false;
                int arrlen = Array.getLength(arr);
                int i = 0;
                while (i < arrlen) {
                    if (Array.get(arr, i).equals(entity)) {
                        contains = true;
                        break;
                    }
                    ++i;
                }
                if (!contains && entity != null) {
                    Object extended = Array.newInstance(linkField.getType().getComponentType(), arrlen + 1);
                    if (arrlen > 0) {
                        System.arraycopy(arr, 0, extended, 0, arrlen);
                    }
                    Array.set(extended, arrlen, entity);
                    arr = extended;
                }
                linkField.set(parentEntity, arr);
            } else {
                linkField.set(parentEntity, entity);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MappingException(e);
        }
    }

    private Object createId(String alias, Values values, List<Field> idFields) {
        if (idFields.size() == 0) {
            return values;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(alias);
        for (Field f : idFields) {
            result.add((String)values.get(alias + "." + f.getName()));
        }
        return result;
    }

    private Map<String, Values> collectValuesByAlias(Map<String, Object> row, Map<String, List<String>> keysByAlias) {
        HashMap<String, Values> result = new HashMap<String, Values>();
        for (Alias a : this.aliases.values()) {
            String alias = a.getAlias();
            List<String> fieldList = keysByAlias.get(alias);
            if (fieldList == null) continue;
            Values values = QueryBuilder.getAliasValues(row, fieldList);
            result.put(alias, values);
        }
        return result;
    }

    private <E> E buildEntity(Class<E> resultClass, Values values, Field otherField) {
        if (QueryBuilder.allNulls(values)) {
            return null;
        }
        E entity = QueryBuilder.createInstance(resultClass);
        Values other = this.applyValues(entity, values);
        if (otherField != null) {
            otherField.setAccessible(true);
            try {
                otherField.set(entity, other);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MappingException(e);
            }
        }
        return entity;
    }

    public static <E> E enumValueOf(Class<E> enumClass, String name) {
        return Enum.valueOf(enumClass, name);
    }

    private Values applyValues(Object entity, Values aliasValues) {
        Values other = new Values();
        for (String fieldAlias : aliasValues.keySet()) {
            FieldMapping mapping = this.fieldMappings.get(fieldAlias);
            if (mapping != null) {
                mapping.apply(entity, aliasValues.get(fieldAlias));
                continue;
            }
            String fieldName = fieldAlias.substring(fieldAlias.lastIndexOf(".") + 1);
            other.put(fieldName, aliasValues.get(fieldAlias));
        }
        return other;
    }

    private static boolean allNulls(Map<String, Object> values) {
        for (Object val : values.values()) {
            if (val == null) continue;
            return false;
        }
        return true;
    }

    private static Values getAliasValues(Map<String, Object> row, List<String> fieldList) {
        Values result = new Values();
        for (String key : fieldList) {
            result.put(key, row.get(key));
        }
        return result;
    }

    public LinkedHashMap<String, Alias> getAliases() {
        return this.aliases;
    }

    public Map<String, FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public Class<T> getResultClass() {
        return this.resultClass;
    }

    public static List<Field> assertIdFields(Class<?> resultClass) {
        List<Field> idFields = QueryBuilder.determineIdFields(resultClass);
        if (idFields.size() == 0) {
            throw new MappingException("No @Id annotations found on fields of class " + resultClass.getName());
        }
        return idFields;
    }

    public static List<SqlExpression> buildIdCondition(DbContext context, Class<?> resultClass, Object id) {
        List<Field> idFields = QueryBuilder.assertIdFields(resultClass);
        List<TableMapping> tables = QueryBuilder.determineTableMapping(resultClass);
        String tableName = tables.get((int)(tables.size() - 1)).tableName;
        if (idFields.size() == 1) {
            return Arrays.asList(new SqlExpression(context.quoteObjectNames(tableName, idFields.get(0).getName()) + "=?", Arrays.asList(id)));
        }
        if (id instanceof Map) {
            Map idvalues = (Map)id;
            ArrayList<SqlExpression> result = new ArrayList<SqlExpression>();
            for (String field : idvalues.keySet()) {
                result.add(new SqlExpression(context.quoteObjectNames(tableName, field) + "=?", Arrays.asList(idvalues.get(field))));
            }
            return result;
        }
        throw new MappingException("Multiple @Id annotations on class " + resultClass.getName() + ": expecting a map id.");
    }

    public static <T> T createInstance(Class<T> valClass) {
        try {
            Constructor<T> constructor = valClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MappingException("Exception creating instance of class " + String.valueOf(valClass), e);
        }
    }

    public static String determinePrefix(Field f) {
        Object prefix = f.getAnnotation(Embedded.class).prefix();
        if (((String)prefix).equals("__DEFAULT__")) {
            prefix = f.getName();
        }
        if (!((String)prefix).isEmpty()) {
            prefix = (String)prefix + "_";
        }
        return prefix;
    }

    public static List<TableMapping> determineTableMapping(Class<?> clz) {
        Class<?> mappedClz = clz;
        ArrayList<TableMapping> tables = new ArrayList<TableMapping>();
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clz != null) {
            if (mappedClz == null) {
                mappedClz = clz;
            }
            Table tableAnn = clz.getAnnotation(Table.class);
            fields.addAll(0, QueryBuilder.collectFieldsOfClass(clz, clz.getSuperclass()));
            if (tableAnn != null) {
                String name = tableAnn.value();
                tables.add(0, new TableMapping(tableAnn.schema(), name, mappedClz, new ArrayList<Field>(fields)));
                fields.clear();
                mappedClz = null;
            }
            clz = clz.getSuperclass();
        }
        if (fields.size() > 0 && tables.size() > 0) {
            ((TableMapping)tables.get((int)0)).fields.addAll(0, fields);
        }
        return tables;
    }

    public static List<String> getFieldNames(String table, List<Field> fields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field f : fields) {
            fieldNames.add(table + "." + f.getName());
        }
        return fieldNames;
    }

    public static Collection<Field> filterFields(Class<?> clz) {
        ArrayList<Field> result = new ArrayList<Field>();
        Field[] fieldArray = clz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if ((f.getModifiers() & 8) <= 0 && (f.getModifiers() & 0x80) <= 0 && f.getAnnotation(Transient.class) == null) {
                result.add(f);
            }
            ++n2;
        }
        return result;
    }

    public static List<Field> collectFieldsOfClass(Class<?> clz, Class<?> stopAtSuperClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (clz != null && !clz.equals(stopAtSuperClass)) {
            result.addAll(0, QueryBuilder.filterFields(clz));
            clz = clz.getSuperclass();
        }
        return result;
    }

    public static Iterable<Field> collectFieldsOfClass(Class<?> type) {
        return QueryBuilder.collectFieldsOfClass(type, null);
    }

    public static final List<Field> determineIdFields(Class<?> clz) {
        Iterable<Field> fields = QueryBuilder.collectFieldsOfClass(clz);
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field f : fields) {
            if (f.getAnnotation(Id.class) == null) continue;
            result.add(f);
        }
        return result;
    }

    public static Field determineIdField(Class<?> clz) {
        List<Field> idFields = QueryBuilder.determineIdFields(clz);
        if (idFields.size() != 1) {
            throw new MappingException("Need single id field annotated with @Id on class " + String.valueOf(clz));
        }
        return idFields.get(0);
    }

    public static class Values
    extends HashMap<String, Object> {
        public Values() {
        }

        public Values(Values values) {
            super(values);
        }
    }
}

