/*
 * Decompiled with CFR 0.152.
 */
package nl.pojoquery.pipeline;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import nl.pojoquery.FieldMapping;
import nl.pojoquery.internal.MappingException;
import nl.pojoquery.pipeline.QueryBuilder;

public class SimpleFieldMapping
implements FieldMapping {
    private Field f;

    public SimpleFieldMapping(Field f) {
        this.f = f;
    }

    @Override
    public void apply(Object targetEntity, Object value) {
        try {
            if (value instanceof String && this.f.getType().isEnum()) {
                value = QueryBuilder.enumValueOf(this.f.getType(), (String)value);
            }
            if (value instanceof BigDecimal && (this.f.getType().equals(Integer.class) || this.f.getType().equals(Integer.TYPE))) {
                value = ((BigDecimal)value).intValue();
            }
            if (value instanceof BigDecimal && (this.f.getType().equals(Long.class) || this.f.getType().equals(Long.TYPE))) {
                value = ((BigDecimal)value).longValue();
            }
            if (value instanceof Date && this.f.getType().equals(LocalDate.class)) {
                value = ((Date)value).toLocalDate();
            }
            if (value instanceof LocalDateTime && this.f.getType().equals(Instant.class)) {
                value = ((LocalDateTime)value).atZone(ZoneOffset.UTC).toInstant();
            }
            this.f.setAccessible(true);
            this.f.set(targetEntity, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MappingException("Exception setting value of field " + String.valueOf(this.f) + " of entity " + String.valueOf(targetEntity), e);
        }
    }

    public Field getField() {
        return this.f;
    }
}

