/*
 * Decompiled with CFR 0.152.
 */
package nl.pojoquery.pipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.pojoquery.DB;
import nl.pojoquery.DbContext;
import nl.pojoquery.SqlExpression;
import nl.pojoquery.util.Iterables;
import nl.pojoquery.util.Strings;

public class SqlQuery {
    private int offset = -1;
    private int rowCount = -1;
    private String schema;
    private String table;
    private List<SqlField> fields = new ArrayList<SqlField>();
    private List<SqlJoin> joins = new ArrayList<SqlJoin>();
    private List<SqlExpression> wheres = new ArrayList<SqlExpression>();
    private List<String> groupBy = new ArrayList<String>();
    private List<String> orderBy = new ArrayList<String>();
    private final DbContext dbContext;

    public SqlQuery(DbContext context) {
        this.dbContext = context;
    }

    public SqlQuery(DbContext context, String table) {
        this(context);
        this.table = table;
    }

    public List<SqlField> getFields() {
        return this.fields;
    }

    public void setFields(List<SqlField> fields) {
        this.fields = fields;
    }

    public List<SqlJoin> getJoins() {
        return this.joins;
    }

    public void setJoins(List<SqlJoin> joins) {
        this.joins = joins;
    }

    public List<SqlExpression> getWheres() {
        return this.wheres;
    }

    public void setWheres(List<SqlExpression> wheres) {
        this.wheres = wheres;
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<String> groupBy) {
        this.groupBy = groupBy;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public SqlQuery setOrderBy(List<String> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public SqlQuery addField(SqlExpression expression) {
        this.fields.add(new SqlField(expression));
        return this;
    }

    public SqlQuery addField(SqlExpression expression, String alias) {
        this.fields.add(new SqlField(expression, alias));
        return this;
    }

    public SqlQuery addGroupBy(String group) {
        this.groupBy.add(group);
        return this;
    }

    public SqlQuery addWhere(SqlExpression where) {
        this.wheres.add(where);
        return this;
    }

    public SqlQuery addWhere(String sql, Object ... params) {
        this.wheres.add(new SqlExpression(sql, Arrays.asList(params)));
        return this;
    }

    public SqlQuery addOrderBy(String order) {
        this.orderBy.add(order);
        return this;
    }

    public SqlQuery setLimit(int rowCount) {
        return this.setLimit(-1, rowCount);
    }

    public SqlQuery setLimit(int offset, int rowCount) {
        this.offset = offset;
        this.rowCount = rowCount;
        return this;
    }

    public SqlExpression toStatement() {
        ArrayList<SqlExpression> fieldExpressions = new ArrayList<SqlExpression>();
        for (SqlField field : this.fields) {
            if (field.alias == null) {
                fieldExpressions.add(field.expression);
                continue;
            }
            SqlExpression resolved = SqlQuery.resolveAliases(this.dbContext, field.expression, this.table, "", null);
            String sql = resolved.getSql() + " AS " + this.dbContext.quoteAlias(field.alias);
            fieldExpressions.add(new SqlExpression(sql, resolved.getParameters()));
        }
        SqlExpression fieldsExp = SqlExpression.implode(",\n ", fieldExpressions);
        return this.toStatement(new SqlExpression("SELECT\n " + fieldsExp.getSql(), fieldsExp.getParameters()), this.schema, this.table, this.joins, this.wheres, this.groupBy, this.orderBy, this.offset, this.rowCount);
    }

    public static SqlExpression resolveAliases(DbContext context, SqlExpression sql, String thisAlias, String prefixAlias, String linkTableAlias) {
        StringBuffer result = new StringBuffer();
        Matcher m = Pattern.compile("\\{([a-zA-Z0-9_\\.]+)\\}\\.").matcher(sql.getSql());
        while (m.find()) {
            String alias = m.group(1);
            Object combinedAlias = "this".equals(alias) ? thisAlias : ("linktable".equals(alias) ? linkTableAlias : (!prefixAlias.isEmpty() ? prefixAlias + "." + alias : alias));
            m.appendReplacement(result, context.quoteAlias((String)combinedAlias));
            result.append(".");
        }
        m.appendTail(result);
        return new SqlExpression(result.toString(), sql.getParameters());
    }

    public SqlExpression toStatement(SqlExpression selectClause, String schema, String from, List<SqlJoin> joins, List<SqlExpression> wheres, List<String> groupBy, List<String> orderBy, int offset, int rowCount) {
        ArrayList<Object> params = new ArrayList<Object>();
        Iterables.addAll(params, selectClause.getParameters());
        SqlExpression whereClause = this.buildWhereClause(wheres);
        Iterables.addAll(params, whereClause.getParameters());
        String groupByClause = SqlQuery.resolveAliases(this.dbContext, SqlExpression.sql(SqlQuery.buildClause("GROUP BY", groupBy), new Object[0]), this.getTable(), this.getTable(), null).getSql();
        String orderByClause = SqlQuery.resolveAliases(this.dbContext, SqlExpression.sql(SqlQuery.buildClause("ORDER BY", orderBy), new Object[0]), this.getTable(), this.getTable(), null).getSql();
        String limitClause = SqlQuery.buildLimitClause(offset, rowCount);
        ArrayList<SqlExpression> joinExpressions = new ArrayList<SqlExpression>();
        for (SqlJoin j : joins) {
            String sql = j.joinType.name() + " JOIN " + DB.prefixAndQuoteTableName(this.dbContext, j.schema, j.table) + " AS " + this.dbContext.quoteAlias(j.alias);
            SqlExpression resolved = SqlQuery.resolveAliases(this.dbContext, j.joinCondition, this.table, "", null);
            if (j.joinCondition != null) {
                sql = sql + " ON " + resolved.getSql();
            }
            SqlExpression expr = new SqlExpression(sql, resolved.getParameters());
            joinExpressions.add(expr);
        }
        SqlExpression joinsClause = SqlExpression.implode("\n ", joinExpressions);
        Iterables.addAll(params, joinsClause.getParameters());
        String sql = Strings.implode(" ", Arrays.asList(selectClause.getSql(), "\nFROM", DB.prefixAndQuoteTableName(this.dbContext, schema, from), "AS", this.dbContext.quoteAlias(from) + "\n", joinsClause.getSql(), whereClause == null ? "" : whereClause.getSql(), groupByClause, orderByClause, limitClause));
        return new SqlExpression(sql, params);
    }

    private static String buildLimitClause(int offset, int rowCount) {
        Object limitClause = "";
        if (offset > -1 || rowCount > -1) {
            if (rowCount < 0) {
                rowCount = Integer.MAX_VALUE;
            }
            limitClause = offset > -1 ? "\nLIMIT " + offset + "," + rowCount : "\nLIMIT " + rowCount;
        }
        return limitClause;
    }

    private SqlExpression buildWhereClause(List<SqlExpression> parts) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Object whereClause = "";
        if (parts.size() > 0) {
            ArrayList<String> clauses = new ArrayList<String>();
            for (SqlExpression exp : parts) {
                clauses.add(SqlQuery.resolveAliases(this.dbContext, exp, this.getTable(), this.getTable(), null).getSql());
                for (Object o : exp.getParameters()) {
                    parameters.add(o);
                }
            }
            whereClause = "\nWHERE " + Strings.implode("\n AND ", clauses);
        }
        return new SqlExpression((String)whereClause, parameters);
    }

    private static String buildClause(String preamble, List<String> parts) {
        Object groupByClause = "";
        if (parts != null && parts.size() > 0) {
            groupByClause = "\n" + preamble + " " + Strings.implode(", ", parts);
        }
        return groupByClause;
    }

    public void addJoin(JoinType type, String tableName, String alias, SqlExpression joinCondition) {
        this.addJoin(type, null, tableName, alias, joinCondition);
    }

    public void addJoin(JoinType type, String schemaName, String tableName, String alias, SqlExpression joinCondition) {
        this.joins.add(new SqlJoin(type, schemaName, tableName, alias, joinCondition));
    }

    public void setTable(String schemaName, String tableName) {
        this.schema = schemaName;
        this.table = tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public static enum JoinType {
        LEFT,
        RIGHT,
        INNER;

    }

    public static class NamedParameter {
        private final String name;

        public NamedParameter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class SqlField {
        public final String alias;
        public final SqlExpression expression;

        public SqlField(SqlExpression expression) {
            this(expression, null);
        }

        public SqlField(SqlExpression expression, String alias) {
            this.expression = expression;
            this.alias = alias;
        }
    }

    public static class SqlJoin {
        public final JoinType joinType;
        public final String schema;
        public final String table;
        public final String alias;
        public final SqlExpression joinCondition;

        public SqlJoin(JoinType type, String schemaName, String tableName, String alias, SqlExpression joinCondition) {
            this.joinType = type;
            this.schema = "".equals(schemaName) ? null : schemaName;
            this.table = tableName;
            this.alias = alias;
            this.joinCondition = joinCondition;
        }
    }
}

